<?php

namespace App\Http\Controllers\Api\Student;

use App\Models\City;
use App\Models\State;
use App\Models\Country;
use App\Models\Subject;
use App\Models\HeardAboutUs;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CountryController extends Controller
{

    public function getCountries(Request $request)
    {

        $lang = $request->query('lang', 'ar');
        app()->setLocale($lang);


        $countries = Country::all()->map(function ($country) use ($lang) {
            return [
                'id' => $country->id,
                'name' => $country->getTranslation('name', $lang), // Get the translated name for the specified language
            ];
        });

        return response()->json([
            'countries' => $countries,
            'message' => __('dashboard.countries')
        ]);
    }

    public function getStates(Request $request)
    {
        // Get the current locale from the app (set by CheckLang middleware)
        $lang = app()->getLocale();

        // Eager load the 'country' relationship and fetch only necessary fields
        $states = State::all()->map(function ($state) use ($lang) {
            return [
                'id' => $state->id,
                'name' => $state->getTranslation('name', $lang),
                'country_name' => $state->country->getTranslation('name', $lang),
            ];
        });


        return response()->json([
            'states' => $states,
            'msg' => __('dashboard.states'),
        ], 200);
    }

    public function getCities(Request $request)
    {
        $lang = app()->getLocale();

        $cities = City::with('state.country')->get()->map(function ($city) use ($lang) {
            return [

                'id' => $city->state->country->id,
                'name' => $city->state->country->getTranslation('name', $lang),
                'created_at' => $city->state->country->created_at,


                'state' => [
                    'id' => $city->state->id,
                    'name' => $city->state->getTranslation('name', $lang),
                    'created_at' => $city->state->created_at,


                    'city' => [
                        'id' => $city->id,
                        'name' => $city->getTranslation('name', $lang),
                        'created_at' => $city->created_at,

                    ]
                ],

            ];
        });

        return response()->json([
            'status' => true,
            'message' => 'ok',
            'data' => $cities
        ], 200);
    }




    public function getState(Request $request, $id)
    {
        // Get the language from the query parameter or default to 'ar'
        $lang = $request->query('lang', 'ar');

        // Set the locale based on the language parameter (optional if you have global middleware)
        app()->setLocale($lang);

        // Fetch the state based on the country_id
        $state = State::where('country_id', $id)
            ->select('id', 'name')
            ->first();

        if (!$state) {
            return response()->json([
                'message' => __('dashboard.state_not_found')
            ], 404);
        }

        // Return the state with id and translated name based on the locale
        return response()->json([
            'state' => [
                'id' => $state->id,
                'name' => $state->getTranslation('name', $lang) // Get translated name based on the current locale
            ],
            'message' => __('dashboard.state')
        ]);
    }


    public function getCity(Request $request, $id)
    {
        // Get the language from the query parameter or default to 'ar'
        $lang = $request->query('lang', 'ar');

        // Set the locale based on the language parameter (optional if you have global middleware)
        app()->setLocale($lang);

        // Fetch the state based on the country_id
        $city = City::where('state_id', $id)
            ->select('id', 'name')
            ->first();

        if (!$city) {
            return response()->json([
                'message' => __('dashboard.city_not_found')
            ], 404);
        }

        // Return the state with id and translated name based on the locale
        return response()->json([
            'city' => [
                'id' => $city->id,
                'name' => $city->getTranslation('name', $lang) // Get translated name based on the current locale
            ],
            'message' => __('dashboard.city')
        ]);
    }


    public function getHeards(Request $request)
    {

        $lang = $request->query('lang', 'ar');
        app()->setLocale($lang);


        $heards = HeardAboutUs::all()->map(function ($heard) use ($lang) {
            return [
                'id' => $heard->id,
                'name' => $heard->getTranslation('name', $lang), // Get the translated name for the specified language
            ];
        });

        return response()->json([
            'heards' => $heards,
            'message' => __('messages.success')
        ]);
    }


    
}