<?php

namespace App\Http\Controllers\Api\Student;

use App\Models\Grade;
use App\Models\Classroom;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class GradeController extends Controller
{

    public function getGrades(Request $request)
    {

        $lang = $request->query('lang', 'ar');
        app()->setLocale($lang);


        $grades = Grade::all()->map(function ($grade) use ($lang) {
            return [
                'id' => $grade->id,
                'name' => $grade->getTranslation('name', $lang), // Get the translated name for the specified language
            ];
        });

        return response()->json([
            'grades' => $grades,
            'message' => __('dashboard.grades')
        ]);
    }

    public function getByGrade($lang, $grade_id, Request $request)
    {

        $lang = in_array($lang, ['ar', 'en']) ? $lang : 'ar';
        app()->setLocale($lang);

     
        $classrooms = Classroom::where('grade_id', $grade_id)->get();


        if ($classrooms->isEmpty()) {
            return response()->json([
                'message' => __('messages.no_classrooms_found'),
                'grade_id' => $grade_id,
            ], 404);
        }


        $data = $classrooms->map(function ($classroom) use ($lang) {
            return [
                'id' => $classroom->id,
                'name' => $classroom->getTranslation('name', $lang),
            ];
        });

        return response()->json([
            'classrooms' => $data,
            'grade_id' => $grade_id,

        ], 200);
    }
}