<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Permission;
use Yajra\DataTables\Facades\DataTables;

class PermissionController extends Controller
{
    public function index()
    {
        return view('permissions.index');
    }

    public function list()
    {
        $data = Permission::all();
        return DataTables::of($data)
            ->addColumn(
                'actions',
                fn($perm) =>
                "<button class='btn btn-sm btn-warning editPermission' data-id='{$perm->id}'>تعديل</button>
                 <button class='btn btn-sm btn-danger deletePermission' data-id='{$perm->id}'>حذف</button>"
            )
            ->rawColumns(['actions'])
            ->make(true);
    }

    public function store(Request $request)
    {
        $request->validate(['name' => 'required|unique:permissions,name']);
        Permission::create(['name' => $request->name, 'guard_name' => 'web']);
        return response()->json(['status' => true]);
    }

    public function edit(Permission $permission)
    {
        return response()->json($permission);
    }

    public function update(Request $request, Permission $permission)
    {
        $request->validate(['name' => 'required']);
        $permission->update(['name' => $request->name]);
        return response()->json(['status' => true]);
    }

    public function destroy(Permission $permission)
    {
        $permission->delete();
        return response()->json(['status' => true]);
    }

    public function show(Permission $permission)
    {
        return response()->json([
            'id' => $permission->id,
            'name' => $permission->name,
            'branch_id' => $permission->branch_id,
            'created_at' => $permission->created_at?->toDateTimeString(),
            'updated_at' => $permission->updated_at?->toDateTimeString(),
        ]);
    }
}
