<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckLang
{
    public function handle(Request $request, Closure $next)
    {
        $lang = $request->route('lang');

        if (!in_array($lang, ['ar', 'en'])) {
            $lang = config('app.locale');
        }

        app()->setLocale($lang);

        return $next($request);
    }
}