<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCustomerRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'branch_id' => ['required', 'exists:branches,id'],
            'name'      => ['required', 'string', 'max:255'],
        ];
    }

    public function attributes(): array
    {
        return [
            'branch_id' => 'الفرع',
            'name'      => 'اسم العميل',
        ];
    }
}
