<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateMemberRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $memberId = $this->route('member')?->id ?? $this->route('id');

        $rules = [
            'branch_id' => ['sometimes', 'exists:branches,id'],
            'status'    => ['nullable', Rule::in(['new', 'active', 'inactive'])],

            'name'      => ['sometimes', 'required', 'string', 'max:255'],

            'id_type'   => ['nullable', Rule::in(['national_id', 'iqama', 'passport', 'driving_license', 'work_card'])],
            'id_number' => ['nullable', 'string', 'max:20', Rule::unique('members', 'id_number')->ignore($memberId)],

            'id_issue_greg'  => ['nullable', 'date'],
            'id_expiry_greg' => ['nullable', 'date'],
            'id_issue_hijri' => ['nullable', 'string', 'max:20'],
            'id_expiry_hijri' => ['nullable', 'string', 'max:20'],

            'gender'         => ['nullable', Rule::in(['male', 'female'])],
            'nationality_id' => ['nullable', 'exists:countries,id'],
            'birth_greg'     => ['nullable', 'date'],
            'birth_hijri'    => ['nullable', 'string', 'max:20'],
            'age'            => ['nullable', 'integer', 'min:0', 'max:120'],

            'phone'       => ['nullable', 'string', 'max:30'],
            'email'       => ['nullable', 'email', 'max:191'],
            'po_box'      => ['nullable', 'string', 'max:50'],
            'postal_code' => ['nullable', 'string', 'max:20'],
            'address'     => ['nullable', 'string', 'max:255'],

            'avatar'         => ['nullable', 'image', 'max:2048'],
            'id_image'       => ['nullable', 'image', 'max:4096'],
            'work_card_image' => ['nullable', 'image', 'max:4096'],

            'how_heard' => ['nullable', 'array'],
        ];

        if ($this->filled('id_type') && $this->filled('id_number')) {
            if ($this->id_type === 'national_id') {
                $rules['id_number'][] = 'regex:/^1\d{9}$/';
            } elseif ($this->id_type === 'iqama') {
                $rules['id_number'][] = 'regex:/^2\d{9}$/';
            }
        }

        return $rules;
    }

    public function messages(): array
    {
        return [
            'id_number.regex' => 'رقم الهوية غير صحيح بالنسبة لنوع الوثيقة.',
        ];
    }
}
