<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateOfferRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name.ar' => ['required', 'string', 'max:255'],
            'name.en' => ['required', 'string', 'max:255'],

            'scope'   => ['required', 'in:all,members,customers,coupons'],

            'target_member_ids'   => ['nullable', 'array'],
            'target_member_ids.*' => ['integer', 'exists:members,id', 'distinct'],

            'target_customer_ids'   => ['nullable', 'array'],
            'target_customer_ids.*' => ['integer', 'exists:customers,id', 'distinct'],

            'coupon_codes'   => ['nullable', 'array'],
            'coupon_codes.*' => ['string', 'max:50', 'distinct'],

            'start_date_g' => ['required', 'date'],
            'end_date_g'   => ['required', 'date', 'after_or_equal:start_date_g'],

            'start_date_h' => ['nullable', 'string', 'max:20'],
            'end_date_h'   => ['nullable', 'string', 'max:20'],

            'discount_type'  => ['required', 'in:percent,amount'],
            'discount_value' => ['required', 'numeric', 'min:0'],
            'extra_days'     => ['nullable', 'integer', 'min:0'],

            'items'                 => ['required', 'array', 'min:1'],
            'items.*.service_id'    => ['required', 'integer', 'exists:services,id', 'distinct'],
            'items.*.discount_type' => ['nullable', 'in:percent,amount'],
            'items.*.discount_value' => ['nullable', 'numeric', 'min:0'],
            'items.*.extra_days'    => ['nullable', 'integer', 'min:0'],

            'active' => ['nullable', 'boolean'],
        ];
    }

    public function messages(): array
    {
        return [
            'items.required' => 'لا يمكن حفظ العرض بدون خدمات.',
            'items.min'      => 'لا يمكن حفظ العرض بدون خدمات.',
        ];
    }
}
