<?php

namespace App\Models;

use App\Models\City;
use App\Models\Customer;
use App\Models\BranchType;
use App\Models\BranchCategory;
use App\Models\BranchMonthlyGoal;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Branch extends Model
{
    use HasFactory, HasTranslations;

    protected $fillable = [
        'branch_code',
        'name',
        'branch_category_id',
        'branch_type_id',
        'city_id',
        'primary_phone',
        'phones',
        'active',
        'address',
        'min_age',
        'max_discount_percent'
    ];

    public $translatable = ['name']; // لو هتترجم عناوين: ضيفها هنا

    protected $casts = [
        'phones'  => 'array',
        'address' => 'array',
        'active'  => 'boolean',
    ];

    public function goals()
    {
        return $this->hasMany(BranchMonthlyGoal::class);
    }
    public function state()
    {
        return $this->belongsTo(\App\Models\State::class, 'city_id');
    }

    public function category()
    {
        return $this->belongsTo(BranchCategory::class, 'branch_category_id');
    }
    public function type()
    {
        return $this->belongsTo(BranchType::class, 'branch_type_id');
    }

    // app/Models/Branch.php
    public function customers()
    {
        return $this->hasMany(Customer::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }
}
