<?php

namespace App\Models;

use App\Models\Country;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CompanySetting extends Model
{
    use HasFactory , HasTranslations;

    protected $fillable = [
        'name','logo_path','primary_color','secondary_color','email','phones','country_id'
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public $translatable = ['name'];     // مهم لـ Spatie

    protected $casts = [
        'phones' => 'array',              // يضمن حفظ/قراءة JSON
    ];

    // public function mainBranch()
    // {
    //     return $this->belongsTo(Branch::class, 'main_branch_id'); // اختياري
    // }
}