<?php
// app/Models/Member.php

namespace App\Models;

use App\Models\Subscription;
use Illuminate\Database\Eloquent\Model;

class Member extends Model
{
    protected $fillable = [
        'member_code',
        'branch_id',
        'status',
        'id_type',
        'id_number',
        'id_issue_greg',
        'id_expiry_greg',
        'id_issue_hijri',
        'id_expiry_hijri',
        'name',
        'gender',
        'nationality_id',
        'birth_greg',
        'birth_hijri',
        'age',
        'phone',
        'email',
        'po_box',
        'postal_code',
        'address',
        'avatar_path',
        'id_image_path',
        'work_card_image_path',
        'how_heard',
    ];

    protected $casts = [
        'how_heard'   => 'array',
        'id_issue_greg'  => 'date',
        'id_expiry_greg' => 'date',
        'birth_greg'     => 'date',
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function nationality()
    {
        return $this->belongsTo(Country::class, 'nationality_id');
    }




    public function subscriptions()
    {
        return $this->hasMany(Subscription::class, 'member_id');
    }
}
