<?php

namespace App\Models;

use App\Models\OfferItem;
use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
    protected $fillable = [
        'offer_no',
        'name',
        'scope',
        'target_member_ids',
        'target_customer_ids',
        'coupon_codes',
        'start_date_g',
        'end_date_g',
        'start_date_h',
        'end_date_h',
        'duration_days',
        'discount_type',
        'discount_value',
        'extra_days',
        'active',
    ];

    protected $casts = [
        'name'                => 'array',
        'target_member_ids'   => 'array',
        'target_customer_ids' => 'array',
        'coupon_codes'        => 'array',
        'start_date_g'        => 'date',
        'end_date_g'          => 'date',
        'active'              => 'boolean',
    ];

     public function items()
    {
        return $this->hasMany(OfferItem::class, 'offer_id');
    }

    public function services()
    {
        return $this->belongsToMany(Service::class, 'offer_items')
            ->withPivot([
                'base_price',
                'base_duration_value',
                'base_duration_unit',
                'discount_type',
                'discount_value',
                'extra_days',
                'final_price',
                'final_duration',
            ])
            ->withTimestamps();
    }



}