<?php

namespace App\Models;

use App\Models\Offer;
use App\Models\Service;
use Illuminate\Database\Eloquent\Model;

class OfferItem extends Model
{
    protected $fillable = [
        'offer_id',
        'service_id',
        'service_name',
        'base_price',
        'base_duration_value',
        'base_duration_unit',
        'row_discount_type',
        'row_discount_value',
        'row_extra_days',
        'final_price',
        'final_duration_value',
        'final_duration_unit',
    ];

    protected $casts = [
        'service_name' => 'array',
    ];

    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }
    public function service()
    {
        return $this->belongsTo(Service::class);
    }
}
