<?php

// app/Models/Service.php
namespace App\Models;

use App\Models\Branch;
use App\Models\ServiceType;
use App\Models\ServiceCategory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Service extends Model
{
    use HasTranslations;

    protected $fillable = [
        'name',
        'service_code',
        'service_category_id',
        'service_type_id',
        'price',
        'discount_price',
        'duration_value',
        'duration_unit',
        'start_time',
        'end_time',
        'notes',
        'settings',
        'active'
    ];

    public $translatable = ['name', 'notes'];

    protected $casts = [
        'price'          => 'decimal:2',
        'discount_price' => 'decimal:2',
        'settings'       => 'array',
        'active'         => 'boolean',
    ];

    public function category()
    {
        return $this->belongsTo(ServiceCategory::class, 'service_category_id');
    }
    public function type()
    {
        return $this->belongsTo(ServiceType::class, 'service_type_id');
    }

    public function providedBranches()
    {
        return $this->belongsToMany(Branch::class, 'branch_service_provided');
    }
    public function soldBranches()
    {
        return $this->belongsToMany(Branch::class, 'branch_service_sold');
    }

    public function offers()
    {
        return $this->belongsToMany(Offer::class, 'offer_items')
            ->withPivot([
                'base_price',
                'base_duration_value',
                'base_duration_unit',
                'discount_type',
                'discount_value',
                'extra_days',
                'final_price',
                'final_duration',
            ])
            ->withTimestamps();
    }
}
