<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceInvoice extends Model
{
    protected $fillable = [
        'document_no',
        'invoice_no',
        'branch_id',
        'member_id',
        'provider_user_id',
        'service_user_id',
        'created_by',
        'account_user_id',
        'greg_date',
        'hijri_date',
        'notes',
        'extra_discount',     // ⭐ لازم يكون موجود
        'total_price',
        'total_discount',
        'total_tax',
        'total_net',
        'payment_methods',
    ];


    protected $dates = ['greg_date'];

    protected $casts = [
        'greg_date' => 'date',
        'hijri_date' => 'string',
        'service_date' => 'date',
        'end_date' => 'date',
    ];


    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function member()
    {
        return $this->belongsTo(Member::class);
    }

    public function provider()
    {
        return $this->belongsTo(User::class, 'provider_user_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function items()
    {
        return $this->hasMany(ServiceInvoiceItem::class);
    }
}
