<?php

namespace App\Models;

use App\Models\City;
use App\Models\Country;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class State extends Model
{
  use HasFactory, HasTranslations;

  protected $fillable = ['name', 'country_id'];
  public $translatable = ['name'];


  

  public function country()
  {
      return $this->belongsTo(Country::class,'country_id');
  }

  public function cities()
  {
      return $this->hasMany(City::class);
  }
}
