<?php

namespace App\Models;

use App\Models\User;
use App\Models\Offer;
use App\Models\Branch;
use App\Models\Member;
use App\Models\Service;
use App\Models\PaymentMethod;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'subscription_no',
        'invoice_no',            // ✅ العمود الصحيح
        'verification_code',     // ✅ لو موجود في الجدول
        'branch_id',
        'member_id',
        'subscription_type',
        'item_id',
        'item_name',
        'start_date',
        'end_date',
        'duration',
        'price',
        'tax',
        'discount',
        'total',
        'payment_methods',       // ✅ JSON بدلاً من payment_method_id
        'status',
        'rejection_notes',
        'active',
        'account_user_id',
        'created_by'
    ];


    protected $casts = [
        'active' => 'boolean',
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    public function member()
    {
        return $this->belongsTo(Member::class);
    }
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function offer()
    {
        return $this->belongsTo(Offer::class, 'item_id')
            ->with('items'); // عشان يرجع offer_items
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'item_id');
    }

    public function getItemsAttribute()
    {
        // ⬅ لو الاشتراك "service"
        if ($this->subscription_type === 'service') {
            if ($this->service) {
                return collect([
                    (object)[
                        'service_name' => $this->service->name['ar'] ?? $this->service->name['en'] ?? 'خدمة',
                        'final_price' => $this->service->price,
                        'final_duration_value' => $this->service->duration_value,
                        'final_duration_unit' => $this->service->duration_unit,
                    ]
                ]);
            }
        }

        // ⬅ لو الاشتراك "offer"
        if ($this->subscription_type === 'offer') {
            return $this->offer?->items ?? collect();
        }

        return collect();
    }
}
