<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->id();
            $table->string('branch_code', 10)->unique();
            $table->json('name');                         // Spatie translatable: {ar,en}
            $table->foreignId('branch_category_id')->constrained()->cascadeOnDelete();
            $table->foreignId('branch_type_id')->constrained()->cascadeOnDelete();
            $table->foreignId('city_id')->constrained('states')->cascadeOnDelete();
            $table->string('primary_phone');              // الهاتف الأساسي
            $table->json('phones')->nullable();           // [{label:{ar,en}, number:""}...]
            $table->boolean('active')->default(true);
            // أمثلة عناوين إن محتاج:
            $table->json('address')->nullable();          // {street:{ar,en}, district:{ar,en}, building_no, postal_code, ...}
            // قيود
            $table->unsignedTinyInteger('min_age')->nullable();
            $table->decimal('max_discount_percent', 5, 2)->nullable(); // 0-100
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branches');
    }
};