<?php
// database/migrations/2025_10_04_000001_create_members_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();

            // 7 خانات: فرع(2) + تسلسل(5)
            $table->char('member_code', 7)->unique();

            $table->foreignId('branch_id')->constrained('branches')->cascadeOnDelete();

            // الحالة الافتراضية "new"
            $table->enum('status', ['new', 'active', 'inactive'])->default('new');

            // الهوية
            $table->enum('id_type', ['national_id', 'residence', 'passport', 'driving_license', 'work_card'])->nullable();
            $table->string('id_number', 20)->nullable()->unique(); // يسمح بتعدد NULL

            // تواريخ الهوية (ميلادي تحفظ كـ DATE)
            $table->date('id_issue_greg')->nullable();
            $table->date('id_expiry_greg')->nullable();

            // الهجري للنص/العرض (اختياري)
            $table->string('id_issue_hijri', 20)->nullable();
            $table->string('id_expiry_hijri', 20)->nullable();

            // بيانات شخصية
            $table->string('name'); // الاسم الكامل
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->foreignId('nationality_id')->nullable()->constrained('countries')->nullOnDelete();

            // الميلاد
            $table->date('birth_greg')->nullable();
            $table->string('birth_hijri', 20)->nullable();
            $table->unsignedSmallInteger('age')->nullable();

            // تواصل
            $table->string('phone', 30)->nullable();
            $table->string('email')->nullable();
            $table->string('po_box', 50)->nullable();
            $table->string('postal_code', 20)->nullable();
            $table->string('address')->nullable();

            // صور
            $table->string('avatar_path')->nullable();
            $table->string('id_image_path')->nullable();
            $table->string('work_card_image_path')->nullable();

            // كيف تعرف علينا
            $table->json('how_heard')->nullable(); // array of strings

            $table->timestamps();

            $table->index(['branch_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('members');
    }
};
