<?php
// database/migrations/2025_10_04_000002_create_member_sequences_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('member_sequences', function (Blueprint $table) {
            $table->foreignId('branch_id')->primary()->constrained('branches')->cascadeOnDelete();
            $table->char('prefix', 2);               // آخر رقمين من branch_code (أو id)
            $table->unsignedInteger('last_seq')->default(0);
            $table->timestamps();
        });

        // تهيئة أولية من البيانات الموجودة (لو فيه أعضاء مُسجَّلين مسبقًا)
        DB::statement("
            INSERT INTO member_sequences (branch_id, prefix, last_seq, created_at, updated_at)
SELECT
    b.id,
    LPAD(RIGHT(COALESCE(NULLIF(MAX(b.branch_code),''), b.id), 2), 2, '0') AS prefix,
    COALESCE(MAX(CAST(SUBSTRING(m.member_code, 3) AS UNSIGNED)), 0) AS last_seq,
    NOW(), NOW()
FROM branches b
LEFT JOIN members m ON m.branch_id = b.id
GROUP BY b.id
ON DUPLICATE KEY UPDATE
    prefix   = VALUES(prefix),
    last_seq = GREATEST(member_sequences.last_seq, VALUES(last_seq)),
    updated_at = NOW();

        ");
    }

    public function down(): void
    {
        Schema::dropIfExists('member_sequences');
    }
};
