<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('offer_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('offer_id')->constrained('offers')->cascadeOnDelete();
            $table->foreignId('service_id')->constrained('services')->cascadeOnDelete();

            // لقطة من الخدمة لحظة الإضافة
            $table->json('service_name');                            // {ar,en}
            $table->decimal('base_price', 10, 2);
            $table->unsignedInteger('base_duration_value');
            $table->enum('base_duration_unit', ['days', 'months', 'years']);

            // خصم خاص لهذا الصف (إن تُرك null نستخدم العام)
            $table->enum('row_discount_type', ['percent', 'amount'])->nullable();
            $table->decimal('row_discount_value', 10, 2)->nullable();
            $table->unsignedInteger('row_extra_days')->nullable();

            // النتائج النهائية بعد التطبيق
            $table->decimal('final_price', 10, 2);
            $table->unsignedInteger('final_duration_value');         // قيمة بعد إضافة extra
            $table->enum('final_duration_unit', ['days', 'months', 'years']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('offer_items');
    }
};
