<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();

            // 🔹 أرقام منفصلة
            $table->unsignedBigInteger('subscription_no'); // رقم داخلي حسب الفرع
            $table->string('invoice_no')->unique();

            $table->string('verification_code')->nullable(); // رقم توثيق عند الاعتماد

            // 🔹 العلاقات الأساسية
            $table->foreignId('branch_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('member_id')->nullable()->constrained()->cascadeOnDelete();

            // 🔹 تفاصيل الاشتراك
            $table->enum('subscription_type', ['service', 'offer']);
            $table->unsignedBigInteger('item_id');
            $table->string('item_name');

            // 🔹 التواريخ والمدة
            $table->date('start_date');
            $table->date('end_date');
            $table->unsignedInteger('duration');

            // 🔹 القيم المالية
            $table->decimal('price', 10, 2);
            $table->decimal('tax', 10, 2)->default(0);
            $table->decimal('discount', 10, 2)->default(0);
            $table->decimal('total', 10, 2);

            // 🔹 طرق الدفع (متعددة)
            $table->json('payment_methods')->nullable();

            // 🔹 الحالة وملاحظات الرفض
            $table->enum('status', ['new', 'under_review', 'approved', 'rejected'])->default('new');
            $table->text('rejection_notes')->nullable();

            $table->boolean('active')->default(true);

            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('account_user_id')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};