<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\PaymentMethod;
use Database\Seeders\adminSeed;
use Illuminate\Database\Seeder;
use Database\Seeders\SuperAdminSeeder;
use Database\Seeders\CountryStateCitySeeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // \App\Models\User::factory(10)->create();

        // \App\Models\User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);

        // $this->call(adminSeed::class);
        $this->call(CountryStateCitySeeder::class);
        $this->call([
            CompanySettingSeeder::class,
        ]);
        $this->call([
            PermissionsSeeder::class,
            SuperAdminSeeder::class,
        ]);

        $methods = [
            ['name_ar' => 'نقدي', 'name_en' => 'Cash', 'code' => 'cash'],
            ['name_ar' => 'بطاقة بنكية', 'name_en' => 'Card', 'code' => 'card'],
            ['name_ar' => 'تحويل بنكي', 'name_en' => 'Bank Transfer', 'code' => 'bank'],
            ['name_ar' => 'مدى', 'name_en' => 'Mada', 'code' => 'mada'],
            ['name_ar' => 'Apple Pay', 'name_en' => 'Apple Pay', 'code' => 'apple'],
        ];

        foreach ($methods as $m) {
            PaymentMethod::updateOrCreate(['code' => $m['code']], $m);
        }
    }
}