<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            // 🧍 المستخدمين
            'users.view',
            'users.create',
            'users.edit',
            'users.delete',

            // 🧩 الأدوار والصلاحيات
            'roles.view',
            'roles.create',
            'roles.edit',
            'roles.delete',

            // 🏢 الفروع
            'branches.view',
            'branches.create',
            'branches.edit',
            'branches.delete',

            // 📊 التقارير
            'reports.view',
            'reports.export',
        ];

        foreach ($permissions as $name) {
            Permission::firstOrCreate([
                'name' => $name,
                'guard_name' => 'web',
                'branch_id' => null, // صلاحية عامة لكل الفروع
            ]);
        }

        $this->command->info('✅ Basic permissions created successfully.');
    }
}