'use strict';
(function() {
    var db = {
        loadData: function(filter) {
            return $.grep(this.clients, function(client) {
                return (!filter.Name || client.Name.indexOf(filter.Name) > -1)
                    && (!filter.Age || client.Age === filter.Age)
                    && (!filter.Address || client.Address.indexOf(filter.Address) > -1)
                    && (!filter.Country || client.Country === filter.Country)
                    && (filter.Married === undefined || client.Married === filter.Married);
            });
        },
        insertItem: function(insertingClient) {
            this.clients.push(insertingClient);
        },
        updateItem: function(updatingClient) { },

        deleteItem: function(deletingClient) {
            var clientIndex = $.inArray(deletingClient, this.clients);
            this.clients.splice(clientIndex, 1);
        }
    };
    window.db = db;
    db.countries = [
        { Name: "India", Id: 0 },
        { Name: "United States", Id: 1 },
        { Name: "Canada", Id: 2 },
        { Name: "United Kingdom", Id: 3 },
        { Name: "France", Id: 4 },
        { Name: "Brazil", Id: 5 },
        { Name: "China", Id: 6 },
        { Name: "Russia", Id: 7 }
    ];
    db.clients = [
        {
            "Task": "Wordpress",
            "Email": "Pixel@efo.com",
            "Phone": "+91 9152639845",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>", 
            "Progress": "100%",

            "Id": "1",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 40%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Dewvrak12@gmail.com",
            "Phone": "+91 9563256895",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "60%",

            "Id": "2",
            "Product": "Airpord Pro",
            "Order Id": "#TD6Y56W",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Php",
            "Email": "Lakhsr33@gmail.com",
            "Phone": "+91 8569325641",
            "Assign": "Ruby Rocha",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "42%",

            "Id": "3",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#9E75CF4",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$89241",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Web Development",
            "Email": "Fatik02@gmail.com",
            "Phone": "+91 7589563241",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "90%",

            "Id": "4",
            "Product": "i phone 14 pro Max",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 60%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Qmab555@gmail.com",
            "Phone": "+91 6598741235",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "100%",

            "Id": "5",
            "Product": "i phone 11 pro",
            "Order Id": "#1A84RD3",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$89241",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 50%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "React",
            "Email": "Tatypd85@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "75%",

            "Id": "6",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#F8ST59L",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Laravel",
            "Email": "dohamo6883@gmail.com",
            "Phone": "+91 7152849563",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "7",
            "Product": "Airpord Pro",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 25%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Flutter",
            "Email": "femecom377@gmail.com",
            "Phone": "+91 7594826315",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "60%",

            "Id": "8",
            "Product": "i phone 11 pro",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$15645",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 36%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Php",
            "Email": "gawej29037@gmail.com",
            "Phone": "+91 6235845932",
            "Assign": "Mark Jecno",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "100%",

            "Id": "9",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#TD6Y56W",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$45680",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "React",
            "Email": "pohoca6274@gmail.com",
            "Phone": "+91 7584698512",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "42%",

            "Id": "10",
            "Product": "Airpord Pro",
            "Order Id": "#F8ST59L",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 96%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Graphics",
            "Email": "bonowap375@gmail.com",
            "Phone": "+91 8412369572",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "11",
            "Product": "i phone 14 pro Max",
            "Order Id": "#J56F8S7",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 81%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "React",
            "Email": "xatov42918@gmail.com",
            "Phone": "+91 8529631478",
            "Assign": "Ruby Rocha",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "12",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#1A84RD3",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$45680",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 52%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Flutter",
            "Email": "jodokar148@gmail.com",
            "Phone": "+91 7145632896",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "42%",

            "Id": "13",
            "Product": "Airpord Pro",
            "Order Id": "#TD6Y56W",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Laravel",
            "Email": "hapif86263@gmail.com",
            "Phone": "+91 7402258963",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "60%",

            "Id": "14",
            "Product": "i phone 11 pro",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 60%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "cehewe9494@gmail.com",
            "Phone": "+91 9563201456",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "100%",

            "Id": "15",
            "Product": "i phone 11 pro",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$12457",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 77%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Flutter",
            "Email": "jeffbanasen@gmail.com",
            "Phone": "+91 7458893210",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "16",
            "Product": "Airpord Pro",
            "Order Id": "#9E75CF4",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "React",
            "Email": "Bmw@gmail..com",
            "Phone": "+91 7414253697",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "17",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#J56F8S7",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Php",
            "Email": "Audi@gmail..com",
            "Phone": "+91 8523690153",
            "Assign": "Otto Clay",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "18",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Web Development",
            "Email": "Seltos@gmail..com",
            "Phone": "+91 9513574560",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "60%",

            "Id": "19",
            "Product": "Airpord Pro",
            "Order Id": "#F8ST59L",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$89241",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Koho@gmail..com",
            "Phone": "+91 8624953170",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "20",
            "Product": "i phone 14 pro Max",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Xolo@gmail..com",
            "Phone": "+91 8526547193",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "100%",

            "Id": "21",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#9E75CF4",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Shopify",
            "Email": "Admiro@gmail..com",
            "Phone": "+91 7136982564",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "100%",

            "Id": "22",
            "Product": "Airpord Pro",
            "Order Id": "#J56F8S7",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$45680",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Multikart@gmail..com",
            "Phone": "+91 9099758263",
            "Assign": "Connor Johnston",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "23",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Zeta@gmail..com",
            "Phone": "+91 7854121367",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "60%",

            "Id": "24",
            "Product": "i phone 11 pro",
            "Order Id": "#F8ST59L",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$12457",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 25%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Viho@gmail..com",
            "Phone": "+91 8546213978",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "25",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#1A84RD3",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$89241",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Voxo@gmail..com",
            "Phone": "+91 7412589630",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "42%",

            "Id": "26",
            "Product": "Airpord Pro",
            "Order Id": "#9E75CF4",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Unice@gmail..com",
            "Phone": "+91 85523697410",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "100%",

            "Id": "27",
            "Product": "i phone 14 pro Max",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Php",
            "Email": "Fastkart@gmail..com",
            "Phone": "+91 9856321470",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "60%",

            "Id": "28",
            "Product": "i phone 14 pro Max",
            "Order Id": "#TD6Y56W",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$15645",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Php",
            "Email": "Oslo@gmail..com",
            "Phone": "+91 796413520",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "75%",

            "Id": "29",
            "Product": "i phone 11 pro",
            "Order Id": "#F8ST59L",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Shopify",
            "Email": "Petkart@gmail..com",
            "Phone": "+91 8080907062",
            "Assign": "Connor Johnston",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "30",
            "Product": "Airpord Pro",
            "Order Id": "#1A84RD3",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$45680",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "React",
            "Email": "Grokery@gmail..com",
            "Phone": "+91 7775552465",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "31",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$89241",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Groka.com",
            "Phone": "+91 9944562378",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "60%",

            "Id": "32",
            "Product": "i phone 14 pro Max",
            "Order Id": "#1A84RD3",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Cosmocart@gmail..com",
            "Phone": "+91 7889552336",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "33",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#9E75CF4",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "React",
            "Email": "Wingo@gmail..com",
            "Phone": "+91 8754692314",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "100%",

            "Id": "34",
            "Product": "Airpord Pro",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Chitchart@gmail.com",
            "Phone": "+91 7854691230",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "100%",

            "Id": "35",
            "Product": "i phone 14 pro Max",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Appish@gmail.com",
            "Phone": "+91 9080702563",
            "Assign": "Connor Johnston",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "60%",

            "Id": "36",
            "Product": "i phone 11 pro",
            "Order Id": "#9E75CF4",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Booksbuy@gmail.com",
            "Phone": "+91 7845123690",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "37",
            "Product": "Airpord Pro",
            "Order Id": "#9E75CF4",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$45680",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Jewelskart@gmail.com",
            "Phone": "+91 8765320146",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "42%",

            "Id": "38",
            "Product": "i phone 11 pro",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Shopify",
            "Email": "Booksbuy@gmail.com",
            "Phone": "+91 7946132508",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "90%",

            "Id": "39",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#TD6Y56W",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$56893",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Chatloop@gmail.com",
            "Phone": "+91 9854321760",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "60%",

            "Id": "40",
            "Product": "Airpord Pro",
            "Order Id": "#J56F8S7",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "React",
            "Email": "Friendbook@gmail.com",
            "Phone": "+91 3164978520",
            "Assign": "Mark Jecno",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "100%",

            "Id": "41",
            "Product": "i phone 14 pro Max",
            "Order Id": "#1A84RD3",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 25%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Qurox.com",
            "Phone": "+91 2356987410",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "42%",

            "Id": "42",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#F8ST59L",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$45680",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Compost.com",
            "Phone": "+91 8523697410",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "43",
            "Product": "Airpord Pro",
            "Order Id": "#J56F8S7",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$12457",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Sheltos.com",
            "Phone": "+91 0258963147",
            "Assign": "Connor Johnston",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "60%",

            "Id": "44",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#J56F8S7",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Wordpress@gmail.com",
            "Phone": "+91 6548231790",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "100%",

            "Id": "45",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#9E75CF4",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$89241",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Graphics@gmail.com",
            "Phone": "+91 8526931470",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "42%",

            "Id": "46",
            "Product": "Airpord Pro",
            "Order Id": "#TD6Y56W",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Flutter@gmail.com",
            "Phone": "+91 9510357482",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "47",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#F8ST59L",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Php",
            "Email": "Php@gmail.com",
            "Phone": "+91 7856234109",
            "Assign": "Mark Jecno",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "60%",

            "Id": "48",
            "Product": "i phone 11 pro",
            "Order Id": "#1A84RD3",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Flutter@gmail.com",
            "Phone": "+91 9030258740",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "100%",

            "Id": "49",
            "Product": "i phone 14 pro Max",
            "Order Id": "#TD6Y56W",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "Web Development",
            "Email": "Web Development@gmail.com",
            "Phone": "+91 7778456234",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "90%",

            "Id": "50",
            "Product": "Airpord Pro",
            "Order Id": "#9E75CF4",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$89241",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Laravel@gmail.com.com",
            "Phone": "+91 859361247",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "42%",

            "Id": "51",
            "Product": "i phone 11 pro",
            "Order Id": "#9E75CF4",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "React",
            "Email": "React@gmail.com.com",
            "Phone": "+91 1234567890",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "60%",

            "Id": "52",
            "Product": "i phone 11 pro",
            "Order Id": "#F8ST59L",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Web ddesigner@gmail.com.com",
            "Phone": "+91 9874563210",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "53",
            "Product": "Airpord Pro",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$45680",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Graphics@gmail.com.com",
            "Phone": "+91 9870231456",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "90%",

            "Id": "54",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$56893",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "React",
            "Email": "Shpify@gmail.com.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "42%",

            "Id": "55",
            "Product": "i phone 11 pro",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Wordpress@gmail.com.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "56",
            "Product": "Airpord Pro",
            "Order Id": "#9E75CF4",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$45680",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Aaman999@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "100%",

            "Id": "57",
            "Product": "i phone 14 pro Max",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$45680",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Shopify",
            "Email": "Swatgv548748@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "42%",

            "Id": "58",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#TD6Y56W",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Soeye46@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "60%",

            "Id": "59",
            "Product": "Airpord Pro",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Sdkmg99@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "90%",

            "Id": "60",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Php",
            "Email": "Tiktok850077@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "61",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#9E75CF4",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "React",
            "Email": "Movie5785@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "60%",

            "Id": "62",
            "Product": "Airpord Pro",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$15645",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 25%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "factormovie@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Otto Clay",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "63",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Flutter",
            "Email": "cottonproduction@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "64",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#9E75CF4",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Amazon@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "90%",

            "Id": "65",
            "Product": "Airpord Pro",
            "Order Id": "#9E75CF4",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$89241",

            "Employee Name": "MS Dhoni",
            "Salary": "$50,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "5:00",
            "Experience": "10 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Meesho@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "42%",

            "Id": "66",
            "Product": "i phone 14 pro Max",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$45680",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Flipkart@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Ruby Rocha",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "100%",

            "Id": "67",
            "Product": "i phone 11 pro",
            "Order Id": "#F8ST59L",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "React",
            "Email": "Snapchat@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Otto Clay",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "60%",

            "Id": "68",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#TD6Y56W",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Php",
            "Email": "Facebook@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "69",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#J56F8S7",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Linkdin@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "75%",

            "Id": "70",
            "Product": "i phone 11 pro",
            "Order Id": "#TD6Y56W",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$56893",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
           "Task": "Shopify",
            "Email": "Instagram@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "60%",

            "Id": "71",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$45680",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Rummy@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "72",
            "Product": "i phone 14 pro Max",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "React",
            "Email": "Whatsapp@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "90%",

            "Id": "73",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$56893",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 25%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Google@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Ruby Rocha",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "90%",

            "Id": "74",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Chrome@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "60%",

            "Id": "75",
            "Product": "i phone 14 pro Max",
            "Order Id": "#9E75CF4",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Php",
            "Email": "Firefox@gmail.com.com",
            "Phone": "+91 7874226671",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "42%",

            "Id": "76",
            "Product": "i phone 11 pro",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$45680",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Screenmeter@gmail.com.com",
            "Phone": "+91 9586471230",
            "Assign": "Mark Jecno",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "100%",

            "Id": "77",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#F8ST59L",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Flock@gmail.com.com",
            "Phone": "+91 9586471230",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "78",
            "Product": "i phone 11 pro",
            "Order Id": "#1A84RD3",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$56893",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Github@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "60%",

            "Id": "79",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$89241",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "React",
            "Email": "Trush@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "80",
            "Product": "i phone 11 pro",
            "Order Id": "#TD6Y56W",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Web Development",
            "Email": "File@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Ruby Rocha",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "90%",

            "Id": "81",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#9E75CF4",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Youtube@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "82",
            "Product": "i phone 14 pro Max",
            "Order Id": "#F8ST59L",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Resso@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "100%",

            "Id": "83",
            "Product": "i phone 14 pro Max",
            "Order Id": "#9E75CF4",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 56%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "React",
            "Email": "Telegram@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "84",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Shopify",
            "Email": "Botim@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "85",
            "Product": "i phone 14 pro Max",
            "Order Id": "#J56F8S7",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "React",
            "Email": "Mx Player@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "100%",

            "Id": "86",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$12457",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Watch@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Ruby Rocha",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "90%",

            "Id": "87",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#F8ST59L",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Health@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "90%",

            "Id": "88",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#9E75CF4",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$45680",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Setting@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "75%",

            "Id": "89",
            "Product": "i phone 14 pro Max",
            "Order Id": "#J56F8S7",
            "Quantity": "4",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$15645",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Product@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "100%",

            "Id": "90",
            "Product": "i phone 11 pro",
            "Order Id": "#1A84RD3",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$45680",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 61%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Web Designer",
            "Email": "Clock@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "91",
            "Product": "i phone 14 pro Max",
            "Order Id": "#TD6Y56W",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
            "Task": "Wordpress",
            "Email": "Tv@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Otto Clay",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "92",
            "Product": "i phone 14 pro Max",
            "Order Id": "#J56F8S7",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$56893",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "React",
            "Email": "Lg@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Christopher Mcclure",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "60%",

            "Id": "93",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$25364",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-danger\" role=\"progressbar\" style=\"width: 45%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Shopify",
            "Email": "Photos@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "75%",

            "Id": "94",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#J56F8S7",
            "Quantity": "6",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$15645",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 35%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "Shopify",
            "Email": "Mail@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Ruby Rocha",
            "Date": "12/07/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "100%",

            "Id": "95",
            "Product": "i phone 11 pro",
            "Order Id": "#9E75CF4",
            "Quantity": "1",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$89241",

            "Employee Name": "Ronaldo",
            "Salary": "$80,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 25%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "UK",
            "Hours": "3:00",
            "Experience": "20 Year",
        },
        {
            "Task": "Laravel",
            "Email": "Calendar@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-warning\">In progress</span>",
            "Progress": "90%",

            "Id": "96",
            "Product": "i phone 11 pro",
            "Order Id": "#1A84RD3",
            "Quantity": "5",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$45680",

            "Employee Name": "Virat Kohli",
            "Salary": "$12,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-info\" role=\"progressbar\" style=\"width: 80%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "India",
            "Hours": "4:30",
            "Experience": "12 Year",
        },
        {
            "Task": "React",
            "Email": "Vlc@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "100%",

            "Id": "97",
            "Product": "Samsung S22 ultra ",
            "Order Id": "#J56F8S7",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Out For Delivery</span>",
            "Total": "$56893",

            "Employee Name": "Jos Buttler",
            "Salary": "$70,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-warning\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "Englend",
            "Hours": "4:00",
            "Experience": "8 Year",
        },
        {
            "Task": "Graphics",
            "Email": "Vellum@gmail.com",
            "Phone": "+91 9586471230",
            "Assign": "Mark Jecno",
            "Date": "12/07/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "60%",

            "Id": "98",
            "Product": "i phone 14 pro Max",
            "Order Id": "#9E75CF4",
            "Quantity": "2",
            "Shipped": "<span class=\"badge badge-light-danger\">Order Cancelled</span>",
            "Total": "$12457",

            "Employee Name": "Otto Clay",
            "Salary": "$10,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-primary\" role=\"progressbar\" style=\"width: 78%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "London",
            "Hours": "9:30",
            "Experience": "5 Year",
        },
        {
            "Task": "Flutter",
            "Email": "Redmi@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Mark Jecno",
            "Date": "26/09/2022",
            "Price": "$1598.50",
            "Status": "<span class=\"font-success\">Done</span>",
            "Progress": "75%",

            "Id": "99",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#F8ST59L",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-success\">Delivery Completed</span>",
            "Total": "$25364",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-success\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
        {
           "Task": "Web Designer",
            "Email": "Mi@gmail.com",
            "Phone": "+91 7874226671",
            "Assign": "Connor Johnston",
            "Date": "26/09/2022",
            "Price": "$2315.00",
            "Status": "<span class=\"font-danger\">Pending</span>",
            "Progress": "90%",

            "Id": "100",
            "Product": "OnePlus Nord CE 2 Lite",
            "Order Id": "#TD6Y56W",
            "Quantity": "3",
            "Shipped": "<span class=\"badge badge-light-warning\">On The Way</span>",
            "Total": "$12457",

            "Employee Name": "Kane Williamson",
            "Salary": "$25,000",
            "Skill": "<div class=\"progress-showcase\"><div class=\"progress sm-progress-bar\"><div class=\"progress-bar bg-secondary\" role=\"progressbar\" style=\"width: 65%\" aria-valuenow=\"50\" aria-valuemin=\"0\" aria-valuemax=\"100\"></div></div></div>",
            "Office": "New Zealand",
            "Hours": "5:00",
            "Experience": "15 Year",
        },
    ];
    db.users = [
        {
            "": "x",
            "Account": "A758A693-0302-03D1-AE53-EEFE22855556",
            "Name": "Carson Kelley",
            "RegisterDate": "2002-04-20T22:55:52-07:00"
        },
        {
            "Account": "D89FF524-1233-0CE7-C9E1-56EFF017A321",
            "Name": "Prescott Griffin",
            "RegisterDate": "2011-02-22T05:59:55-08:00"
        },
        {
            "Account": "06FAAD9A-5114-08F6-D60C-961B2528B4F0",
            "Name": "Amir Saunders",
            "RegisterDate": "2014-08-13T09:17:49-07:00"
        },
        {
            "Account": "EED7653D-7DD9-A722-64A8-36A55ECDBE77",
            "Name": "Derek Thornton",
            "RegisterDate": "2012-02-27T01:31:07-08:00"
        },
        {
            "Account": "2A2E6D40-FEBD-C643-A751-9AB4CAF1E2F6",
            "Name": "Fletcher Romero",
            "RegisterDate": "2010-06-25T15:49:54-07:00"
        },
        {
            "Account": "3978F8FA-DFF0-DA0E-0A5D-EB9D281A3286",
            "Name": "Thaddeus Stein",
            "RegisterDate": "2013-11-10T07:29:41-08:00"
        },
        {
            "Account": "658DBF5A-176E-569A-9273-74FB5F69FA42",
            "Name": "Nash Knapp",
            "RegisterDate": "2005-06-24T09:11:19-07:00"
        },
        {
            "Account": "76D2EE4B-7A73-1212-F6F2-957EF8C1F907",
            "Name": "Quamar Vega",
            "RegisterDate": "2011-04-13T20:06:29-07:00"
        },
        {
            "Account": "00E46809-A595-CE82-C5B4-D1CAEB7E3E58",
            "Name": "Philip Galloway",
            "RegisterDate": "2008-08-21T18:59:38-07:00"
        },
        {
            "Account": "C196781C-DDCC-AF83-DDC2-CA3E851A47A0",
            "Name": "Mason French",
            "RegisterDate": "2000-11-15T00:38:37-08:00"
        },
        {
            "Account": "5911F201-818A-B393-5888-13157CE0D63F",
            "Name": "Ross Cortez",
            "RegisterDate": "2010-05-27T17:35:32-07:00"
        },
        {
            "Account": "B8BB78F9-E1A1-A956-086F-E12B6FE168B6",
            "Name": "Logan King",
            "RegisterDate": "2003-07-08T16:58:06-07:00"
        },
        {
            "Account": "06F636C3-9599-1A2D-5FD5-86B24ADDE626",
            "Name": "Cedric Leblanc",
            "RegisterDate": "2011-06-30T14:30:10-07:00"
        },
        {
            "Account": "FE880CDD-F6E7-75CB-743C-64C6DE192412",
            "Name": "Simon Sullivan",
            "RegisterDate": "2013-06-11T16:35:07-07:00"
        },
        {
            "Account": "BBEDD673-E2C1-4872-A5D3-C4EBD4BE0A12",
            "Name": "Jamal West",
            "RegisterDate": "2001-03-16T20:18:29-08:00"
        },
        {
            "Account": "19BC22FA-C52E-0CC6-9552-10365C755FAC",
            "Name": "Hector Morales",
            "RegisterDate": "2012-11-01T01:56:34-07:00"
        },
        {
            "Account": "A8292214-2C13-5989-3419-6B83DD637D6C",
            "Name": "Herrod Hart",
            "RegisterDate": "2008-03-13T19:21:04-07:00"
        },
        {
            "Account": "0285564B-F447-0E7F-EAA1-7FB8F9C453C8",
            "Name": "Clark Maxwell",
            "RegisterDate": "2004-08-05T08:22:24-07:00"
        },
        {
            "Account": "EA78F076-4F6E-4228-268C-1F51272498AE",
            "Name": "Reuben Walter",
            "RegisterDate": "2011-01-23T01:55:59-08:00"
        },
        {
            "Account": "6A88C194-EA21-426F-4FE2-F2AE33F51793",
            "Name": "Ira Ingram",
            "RegisterDate": "2008-08-15T05:57:46-07:00"
        },
        {
            "Account": "4275E873-439C-AD26-56B3-8715E336508E",
            "Name": "Damian Morrow",
            "RegisterDate": "2015-09-13T01:50:55-07:00"
        },
        {
            "Account": "A0D733C4-9070-B8D6-4387-D44F0BA515BE",
            "Name": "Macon Farrell",
            "RegisterDate": "2011-03-14T05:41:40-07:00"
        },
        {
            "Account": "B3683DE8-C2FA-7CA0-A8A6-8FA7E954F90A",
            "Name": "Joel Galloway",
            "RegisterDate": "2003-02-03T04:19:01-08:00"
        },
        {
            "Account": "01D95A8E-91BC-2050-F5D0-4437AAFFD11F",
            "Name": "Rigel Horton",
            "RegisterDate": "2015-06-20T11:53:11-07:00"
        },
        {
            "Account": "F0D12CC0-31AC-A82E-FD73-EEEFDBD21A36",
            "Name": "Sylvester Gaines",
            "RegisterDate": "2004-03-12T09:57:13-08:00"
        },
        {
            "Account": "874FCC49-9A61-71BC-2F4E-2CE88348AD7B",
            "Name": "Abbot Mckay",
            "RegisterDate": "2008-12-26T20:42:57-08:00"
        },
        {
            "Account": "B8DA1912-20A0-FB6E-0031-5F88FD63EF90",
            "Name": "Solomon Green",
            "RegisterDate": "2013-09-04T01:44:47-07:00"
        }
     ];
}());