@extends('layouts.master')

@section('title', __('قائمة الفروع'))
@section('pages') {{ __('dashboard.home') }} @endsection

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
  #branches-table th, #branches-table td { text-align:center; vertical-align:middle; }
  .dataTables_processing { background:none!important; color:teal!important; font-weight:bold; }
  #branches-table td .btn { width:auto!important; padding:.25rem .5rem!important; }
</style>
@endsection

@section('btn')
  <a href="{{ route('branches.create') }}" class="btn btn-outline-success">
    <i class="fas fa-plus-circle mx-2"></i> {{ __('إضافة فرع') }}
  </a>
@endsection

@section('content')
<div class="row">
  <div class="col-xl-12">
    @if(session('success')) <div class="alert alert-success">{{ session('success') }}</div> @endif
    <div class="table-responsive">
      <table class="table table-bordered dataTable" id="branches-table" style="width:100%">
        <thead>
          <tr>
            <th>#</th>
            <th>{{ __('الاسم') }}</th>
            <th>{{ __('الفئة') }}</th>
            <th>{{ __('النوع') }}</th>
            <th>{{ __('المدينة') }}</th>
            <th>{{ __('الهاتف الأساسي') }}</th>
            <th>{{ __('الحالة') }}</th>
            <th>{{ __('إجراءات') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
</div>
@endsection

@section('js')
<script>
document.addEventListener('DOMContentLoaded', function () {
  $('#branches-table').DataTable({
    processing: true,
    serverSide: true,
    ajax: "{{ route('branches.index') }}",
    language: {!! json_encode(__('datatable')) !!},
    columns: [
      { data: 'DT_RowIndex',    name: 'DT_RowIndex', orderable:false, searchable:false },
      { data: 'translated_name',name: 'name' },
      { data: 'category_name',  name: 'category_name', orderable:false },
      { data: 'type_name',      name: 'type_name',     orderable:false },
      { data: 'city_name',      name: 'city_name',     orderable:false },
      { data: 'primary_phone',  name: 'primary_phone' },
      { data: 'active_badge',   name: 'active', orderable:false, searchable:false },
      { data: 'action',         name: 'action', orderable:false, searchable:false },
    ],
    order: [[0,'asc']]
  });
});
</script>
@endsection
