@extends('layouts.master')


@section('pages')
    {{ __('dashboard.home') }}
@endsection

@section('css')
    <style>
        .card-section {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 16px
        }

        .card-section h6 {
            margin-bottom: 12px
        }

        .kv {
            display: grid;
            grid-template-columns: 180px 1fr;
            gap: .5rem .75rem;
            margin-bottom: .25rem
        }

        .badge {
            font-size: .85rem
        }
    </style>

    <style>
        :root {
            --primary: #0ea5b6;
            /* عدّل لو حابب */
            --secondary: #1e293b;
            /* عدّل لو حابب */
            --glass-bg: rgba(255, 255, 255, .06);
            --glass-br: 16px;
        }

        .goals-wrap {
            position: relative;
            overflow: hidden;
            border-radius: var(--glass-br);
            background: linear-gradient(135deg, rgba(14, 165, 182, .15), rgba(30, 41, 59, .35));
            padding: 18px;
        }

        .goals-wrap::before {
            content: "";
            position: absolute;
            inset: -40%;
            background: radial-gradient(600px 300px at 20% 10%, rgba(14, 165, 182, .18), transparent 60%),
                radial-gradient(400px 300px at 90% 80%, rgba(14, 165, 182, .12), transparent 60%);
            pointer-events: none;
        }

        .goals-header {
            position: relative;
            z-index: 2;
            display: flex;
            align-items: center;
            gap: .75rem;
            justify-content: space-between;
            margin-bottom: 14px;
        }

        .goals-title {
            display: flex;
            align-items: center;
            gap: .65rem;
            font-weight: 700;
            letter-spacing: .3px;
        }

        .goals-title .dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: var(--primary);
            box-shadow: 0 0 12px var(--primary);
        }

        .glass {
            position: relative;
            z-index: 2;
            background: var(--glass-bg);
            border: 1px solid rgba(255, 255, 255, .08);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: var(--glass-br);
        }

        .kpi-grid {
            display: grid;
            gap: 12px;
            grid-template-columns: repeat(12, 1fr);
        }

        .kpi-card {
            grid-column: span 4;
            padding: 14px;
        }

        @media (max-width: 992px) {
            .kpi-card {
                grid-column: span 12;
            }
        }

        .kpi-label {
            font-size: .85rem;
            opacity: .8;
            margin-bottom: 6px;
        }

        .kpi-value {
            font-size: 1.4rem;
            font-weight: 800;
            line-height: 1;
        }

        .kpi-sub {
            font-size: .85rem;
            opacity: .8;
        }

        .progress-slim {
            height: 6px;
            background: rgba(255, 255, 255, .12);
            border-radius: 999px;
            overflow: hidden;
        }

        .progress-slim>span {
            display: block;
            height: 100%;
            background: var(--primary);
        }

        /* Tabs */
        .goals-tabs {
            margin-top: 14px;
            display: flex;
            gap: 8px;
        }

        .pill {
            cursor: pointer;
            user-select: none;
            padding: 8px 14px;
            border-radius: 999px;
            transition: .2s;
            background: rgba(255, 255, 255, .06);
            border: 1px solid rgba(255, 255, 255, .08);
        }

        .pill.active {
            background: var(--primary);
            color: #001014;
            border-color: transparent;
            box-shadow: 0 0 0 3px rgba(14, 165, 182, .15);
        }

        /* Content grid */
        .goals-content {
            margin-top: 12px;
            display: none;
        }

        .goals-content.active {
            display: block;
        }

        .chart-grid {
            display: grid;
            gap: 12px;
            grid-template-columns: 2fr 1fr;
        }

        @media (max-width:992px) {
            .chart-grid {
                grid-template-columns: 1fr;
            }
        }

        .chart-card {
            height: 360px;
            padding: 12px;
        }

        /* Table */
        .table-card {
            padding: 10px;
        }

        .month-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }

        .month-table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
            background: rgba(0, 0, 0, .25);
            backdrop-filter: blur(6px);
        }

        .month-table th,
        .month-table td {
            text-align: center;
            vertical-align: middle;
            padding: .65rem;
        }

        .month-table tbody tr:nth-child(even) {
            background: rgba(255, 255, 255, .03);
        }

        .bar-cell .bar {
            height: 8px;
            background: rgba(255, 255, 255, .12);
            border-radius: 6px;
            overflow: hidden;
            position: relative;
        }

        .bar-cell .bar>span {
            position: absolute;
            inset: 0 auto 0 0;
            width: 0%;
            background: linear-gradient(90deg, var(--primary), #22d3ee);
        }

        .delta-badge {
            display: inline-block;
            padding: .25rem .5rem;
            border-radius: 999px;
            font-size: .8rem;
        }

        .delta-pos {
            background: rgba(34, 197, 94, .15);
            color: #22c55e;
            border: 1px solid rgba(34, 197, 94, .25);
        }

        .delta-neg {
            background: rgba(239, 68, 68, .15);
            color: #ef4444;
            border: 1px solid rgba(239, 68, 68, .25);
        }

        .delta-zero {
            background: rgba(148, 163, 184, .15);
            color: #94a3b8;
            border: 1px solid rgba(148, 163, 184, .25);
        }
    </style>

    <style>
        :root {
            --primary: #0ea5b6;
            --secondary: #1e293b;
            --glass-bg: rgba(255, 255, 255, .06);
            --glass-br: 16px;
        }

        .glass {
            position: relative;
            z-index: 1;
            background: var(--glass-bg);
            border: 1px solid rgba(255, 255, 255, .08);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: var(--glass-br);
        }

        .branch-hero {
            position: relative;
            overflow: hidden;
            padding: 16px;
            margin-bottom: 12px;
            background: linear-gradient(135deg, rgba(14, 165, 182, .18), rgba(30, 41, 59, .35));
            border-radius: var(--glass-br);
            display: flex;
            align-items: stretch;
            justify-content: space-between;
            gap: 12px;
        }

        .branch-hero::before {
            content: "";
            position: absolute;
            inset: -40%;
            background: radial-gradient(600px 300px at 20% 10%, rgba(14, 165, 182, .18), transparent 60%),
                radial-gradient(400px 300px at 90% 80%, rgba(14, 165, 182, .12), transparent 60%);
            z-index: 0;
        }

        .hero-left {
            display: flex;
            align-items: center;
            gap: 12px;
            position: relative;
            z-index: 2;
            flex: 1;
        }

        .avatar {
            width: 64px;
            height: 64px;
            min-width: 64px;
            border-radius: 50%;
            background: rgba(255, 255, 255, .1);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 900;
            font-size: 22px;
            letter-spacing: .5px;
            box-shadow: 0 0 0 3px rgba(14, 165, 182, .15);
        }

        .hero-meta {
            display: flex;
            flex-direction: column;
            gap: 6px;
        }

        .hero-name {
            font-size: 1.25rem;
            font-weight: 800;
            margin: 0;
            line-height: 1.15;
        }

        .hero-badges {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
        }

        .chip {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 10px;
            border-radius: 999px;
            font-size: .85rem;
            background: rgba(255, 255, 255, .08);
            border: 1px solid rgba(255, 255, 255, .12);
        }

        .chip i {
            opacity: .9
        }

        .chip.status-active {
            background: rgba(34, 197, 94, .12);
            color: #22c55e;
            border-color: rgba(34, 197, 94, .25);
        }

        .chip.status-inactive {
            background: rgba(148, 163, 184, .12);
            color: #94a3b8;
            border-color: rgba(148, 163, 184, .25);
        }

        .hero-actions {
            display: flex;
            align-items: center;
            gap: 8px;
            position: relative;
            z-index: 2;
        }

        .hero-actions .btn {
            padding: .45rem .6rem
        }

        .hero-stats {
            display: grid;
            grid-template-columns: repeat(12, 1fr);
            gap: 10px;
            margin-top: 8px;
        }

        .stat {
            grid-column: span 3;
            padding: 12px;
        }

        @media (max-width: 1200px) {
            .stat {
                grid-column: span 6;
            }
        }

        @media (max-width: 576px) {
            .stat {
                grid-column: span 12;
            }
        }

        .stat-label {
            font-size: .8rem;
            opacity: .75;
            margin-bottom: 6px
        }

        .stat-value {
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 8px;
            flex-wrap: wrap;
        }

        .stat-value a {
            color: inherit;
            text-decoration: none;
            border-bottom: 1px dotted rgba(255, 255, 255, .25);
        }

        .copy-btn {
            cursor: pointer;
            opacity: .85;
            border: 1px dashed rgba(255, 255, 255, .15);
            border-radius: 6px;
            padding: 2px 6px;
            font-size: .8rem;
        }

        .copy-btn:hover {
            opacity: 1;
            border-color: rgba(255, 255, 255, .3);
        }

        .muted {
            opacity: .8
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">


        {{-- هيدر بيانات الفرع --}}
        @php
            $nmAr = $branch->getTranslation('name', 'ar');
            $nmEn = $branch->getTranslation('name', 'en');
            $nm = app()->getLocale() === 'ar' ? $nmAr : $nmEn;
            $avatar = mb_strtoupper(mb_substr($nm, 0, 1));
            $cat = optional($branch->category)?->getTranslation('name', app()->getLocale());
            $type = optional($branch->type)?->getTranslation('name', app()->getLocale());
            $city = optional($branch->city)?->getTranslation('name', app()->getLocale());
            $addr = $branch->address ?? [];
            $shortAr = $addr['short']['ar'] ?? null;
            $shortEn = $addr['short']['en'] ?? null;
            $fullAr = $addr['full']['ar'] ?? null;
            $fullEn = $addr['full']['en'] ?? null;
            $short = app()->getLocale() === 'ar' ? ($shortAr ?: $fullAr) : ($shortEn ?: $fullEn);
        @endphp

        <div class="branch-hero">
            <div class="hero-left">
                <div class="avatar">{{ $avatar }}</div>
                <div class="hero-meta">
                    <h4 class="hero-name">{{ $nm }}</h4>
                    <div class="hero-badges">
                        @if ($city)
                            <span class="chip"><i class="fas fa-location-dot"></i> {{ $city }}</span>
                        @endif
                        @if ($type)
                            <span class="chip"><i class="fas fa-stream"></i> {{ $type }}</span>
                        @endif
                        @if ($cat)
                            <span class="chip"><i class="fas fa-layer-group"></i> {{ $cat }}</span>
                        @endif
                        <span class="chip {{ $branch->active ? 'status-active' : 'status-inactive' }}">
                            <i class="fas fa-circle"></i> {{ $branch->active ? 'نشط' : 'غير نشط' }}
                        </span>
                    </div>
                </div>
            </div>

            <div class="hero-actions">
                <a href="{{ route('branches.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-right mx-1"></i> {{ __('رجوع') }}
                </a>
                <a href="{{ route('branches.edit', $branch) }}" class="btn btn-warning">
                    <i class="fas fa-edit mx-1"></i> {{ __('تعديل') }}
                </a>
            </div>
        </div>

        {{-- بطاقات سريعة أسفل الهيدر --}}
        <div class="hero-stats">
            <div class="glass stat">
                <div class="stat-label">{{ __('الهاتف الأساسي') }}</div>
                <div class="stat-value">
                    <i class="fas fa-phone-alt"></i>
                    @if ($branch->primary_phone)
                        <a href="tel:{{ $branch->primary_phone }}">{{ $branch->primary_phone }}</a>
                      
                    @else
                        <span class="muted">—</span>
                    @endif
                </div>
            </div>

            <div class="glass stat">
                <div class="stat-label">{{ __('عنوان مختصر') }}</div>
                <div class="stat-value">
                    <i class="fas fa-map-marker-alt"></i>
                    @if ($short)
                        <span>{{ $short }}</span>
                 
                    @else
                        <span class="muted">—</span>
                    @endif
                </div>
            </div>

            <div class="glass stat">
                <div class="stat-label">{{ __('تاريخ الإنشاء') }}</div>
                <div class="stat-value">
                    <i class="far fa-calendar-plus"></i>
                    <span>{{ optional($branch->created_at)?->format('Y-m-d H:i') }}</span>
                </div>
            </div>

            <div class="glass stat">
                <div class="stat-label">{{ __('آخر تحديث') }}</div>
                <div class="stat-value">
                    <i class="far fa-clock"></i>
                    <span>{{ optional($branch->updated_at)?->format('Y-m-d H:i') }}</span>
                </div>
            </div>
        </div>

        {{-- (اختياري) تفاصيل إضافية مضغوطة — لو حابب تظهرها أسفل البطاقات --}}
        @if (!empty($branch->phones))
            <div class="glass p-3 mt-2">
                <div class="fw-bold mb-2">{{ __('هواتف فرعية') }}</div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle mb-0 text-center">
                        <thead>
                            <tr>
                                <th style="width:30%">{{ __('المسمّى (ar)') }}</th>
                                <th style="width:30%">{{ __('Label (en)') }}</th>
                                <th>{{ __('رقم الهاتف') }}</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($branch->phones as $p)
                                <tr>
                                    <td>{{ $p['label']['ar'] ?? '' }}</td>
                                    <td>{{ $p['label']['en'] ?? '' }}</td>
                                    <td>{{ $p['number'] ?? '' }}</td>

                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif


        {{-- الأهداف الشهرية (عرض فقط) --}}
        <div class="goals-wrap">
            <div class="goals-header">
                <div class="goals-title">
                    <span class="dot"></span>
                    <span>{{ __('الأهداف السنوية للفرع') }}</span>
                </div>
                <div class="d-flex align-items-center gap-2">
                    <label class="mb-0 small opacity-75">{{ __('السنة') }}</label>
                    <select id="goalsYear" class="form-select form-select-sm" style="min-width:120px">
                        @for ($y = now()->year - 2; $y <= now()->year + 2; $y++)
                            <option value="{{ $y }}" @selected($y == now()->year)>{{ $y }}</option>
                        @endfor
                    </select>
                </div>
            </div>

            {{-- KPIs --}}
            <div class="kpi-grid">
                <div class="glass kpi-card">
                    <div class="kpi-label">{{ __('إجمالي المبيعات الفعلية') }}</div>
                    <div class="kpi-value" id="kpiActual">—</div>
                    <div class="kpi-sub">{{ __('للسنة المختارة') }}</div>
                    <div class="progress-slim mt-2"><span id="actualLine" style="width:0%"></span></div>
                </div>
                <div class="glass kpi-card">
                    <div class="kpi-label">{{ __('إجمالي المستهدف') }}</div>
                    <div class="kpi-value" id="kpiTarget">—</div>
                    <div class="kpi-sub">{{ __('للسنة المختارة') }}</div>
                    <div class="progress-slim mt-2"><span id="targetLine" style="width:0%"></span></div>
                </div>
                <div class="glass kpi-card">
                    <div class="kpi-label">{{ __('نسبة الإنجاز') }}</div>
                    <div class="kpi-value" id="kpiRate">—</div>
                    <div class="kpi-sub"><span id="kpiRateHint">—</span></div>
                    <div class="progress-slim mt-2"><span id="rateLine" style="width:0%"></span></div>
                </div>
            </div>

            {{-- Tabs --}}
            <div class="goals-tabs">
                <div class="pill active" data-tab="tab-charts">{{ __('الرسوم') }}</div>
                <div class="pill" data-tab="tab-table">{{ __('الجدول') }}</div>
            </div>

            {{-- Charts --}}
            <div id="tab-charts" class="goals-content active">
                <div class="chart-grid">
                    <div class="glass chart-card">
                        <canvas id="goalsBarChart"></canvas>
                    </div>
                    <div class="glass chart-card">
                        <canvas id="goalsDoughnutChart"></canvas>
                    </div>
                </div>
            </div>

            {{-- Table --}}
            <div id="tab-table" class="goals-content">
                <div class="glass table-card">
                    <div class="table-responsive" style="max-height:460px">
                        <table class="month-table table table-borderless align-middle mb-0" id="goalsTable">
                            <thead>
                                <tr>
                                    <th style="width:120px">{{ __('الشهر') }}</th>
                                    <th>{{ __('الفعلية') }}</th>
                                    <th>{{ __('المستهدف') }}</th>
                                    <th style="width:200px">{{ __('نسبة الإنجاز') }}</th>
                                    <th>{{ __('الفارق') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $months=[1=>'يناير','فبراير','مارس','أبريل','مايو','يونيو','يوليو','أغسطس','سبتمبر','أكتوبر','نوفمبر','ديسمبر']; @endphp
                                @foreach ($months as $m => $label)
                                    <tr data-month="{{ $m }}">
                                        <td class="fw-semibold">{{ $label }}</td>
                                        <td class="actual-col">—</td>
                                        <td class="target-col">—</td>
                                        <td class="bar-cell">
                                            <div class="bar"><span style="width:0%"></span></div>
                                        </td>
                                        <td class="delta-col"><span class="delta-badge delta-zero">—</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>




    </div>
@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const goalsYear = document.getElementById('goalsYear');
            const goalsTable = document.getElementById('goalsTable');

            function clearGoals() {
                goalsTable.querySelectorAll('tbody tr').forEach(tr => {
                    tr.querySelector('.actual-col').textContent = '—';
                    tr.querySelector('.target-col').textContent = '—';
                });
            }

            function loadGoals() {
                clearGoals();
                const url = "{{ route('branches.goals', $branch) }}?year=" + goalsYear.value;
                fetch(url).then(r => r.json()).then(res => {
                    res.items.forEach(item => {
                        const tr = goalsTable.querySelector(`tr[data-month="${item.month}"]`);
                        if (!tr) return;
                        tr.querySelector('.actual-col').textContent = (item.actual ?? '') === '' ?
                            '—' : item.actual;
                        tr.querySelector('.target-col').textContent = (item.target ?? '') === '' ?
                            '—' : item.target;
                    });
                });
            }
            goalsYear.addEventListener('change', loadGoals);
            loadGoals();
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // تبويبات بسيطة
            document.querySelectorAll('.goals-tabs .pill').forEach(p => {
                p.addEventListener('click', () => {
                    document.querySelectorAll('.goals-tabs .pill').forEach(x => x.classList.remove(
                        'active'));
                    document.querySelectorAll('.goals-content').forEach(x => x.classList.remove(
                        'active'));
                    p.classList.add('active');
                    document.getElementById(p.dataset.tab).classList.add('active');
                });
            });

            const goalsYear = document.getElementById('goalsYear');
            const goalsTable = document.getElementById('goalsTable');
            const kpiActual = document.getElementById('kpiActual');
            const kpiTarget = document.getElementById('kpiTarget');
            const kpiRate = document.getElementById('kpiRate');
            const kpiRateHint = document.getElementById('kpiRateHint');
            const actualLine = document.getElementById('actualLine');
            const targetLine = document.getElementById('targetLine');
            const rateLine = document.getElementById('rateLine');

            let barChartInstance = null,
                doughnutChartInstance = null;
            const monthLabels = ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
                'أكتوبر', 'نوفمبر', 'ديسمبر'
            ];

            function fmt(n) {
                return (n === null || n === undefined || isNaN(n)) ? '—' : (Number(n).toLocaleString());
            }

            function pct(a, b) {
                if (!b || b == 0) return null;
                return Math.round((a / b) * 100);
            }

            function clearRows() {
                goalsTable.querySelectorAll('tbody tr').forEach(tr => {
                    tr.querySelector('.actual-col').textContent = '—';
                    tr.querySelector('.target-col').textContent = '—';
                    tr.querySelector('.bar > span').style.width = '0%';
                    const delta = tr.querySelector('.delta-col .delta-badge');
                    delta.textContent = '—';
                    delta.className = 'delta-badge delta-zero';
                });
            }

            function renderBarChart(labels, actualData, targetData) {
                const ctx = document.getElementById('goalsBarChart').getContext('2d');
                const config = {
                    type: 'bar',
                    data: {
                        labels,
                        datasets: [{
                                label: 'Actual',
                                data: actualData,
                                borderWidth: 1
                            },
                            {
                                label: 'Target',
                                data: targetData,
                                borderWidth: 1
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'top'
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    precision: 0
                                }
                            }
                        }
                    }
                };
                if (barChartInstance) {
                    barChartInstance.data = config.data;
                    barChartInstance.update();
                } else {
                    barChartInstance = new Chart(ctx, config);
                }
            }

            function renderDoughnutChart(totalActual, totalTarget) {
                const ctx = document.getElementById('goalsDoughnutChart').getContext('2d');
                const config = {
                    type: 'doughnut',
                    data: {
                        labels: ['Actual (Total)', 'Target (Total)'],
                        datasets: [{
                            data: [totalActual, totalTarget]
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'bottom'
                            }
                        },
                        cutout: '60%'
                    }
                };
                if (doughnutChartInstance) {
                    doughnutChartInstance.data = config.data;
                    doughnutChartInstance.update();
                } else {
                    doughnutChartInstance = new Chart(ctx, config);
                }
            }

            function animateLine(el, to) {
                el.style.transition = 'width .6s ease';
                el.style.width = Math.max(0, Math.min(100, to)) + '%';
            }

            function loadGoals() {
                clearRows();

                const url = "{{ route('branches.goals', $branch) }}?year=" + goalsYear.value;
                fetch(url).then(r => r.json()).then(res => {
                    const actual = new Array(12).fill(0);
                    const target = new Array(12).fill(0);

                    res.items.forEach(item => {
                        const m = (item.month ?? 1) - 1;
                        const a = parseFloat(item.actual ?? 0) || 0;
                        const t = parseFloat(item.target ?? 0) || 0;
                        actual[m] = a;
                        target[m] = t;

                        const tr = goalsTable.querySelector(`tr[data-month="${item.month}"]`);
                        if (tr) {
                            tr.querySelector('.actual-col').textContent = a ? a.toLocaleString() :
                                '—';
                            tr.querySelector('.target-col').textContent = t ? t.toLocaleString() :
                                '—';
                            const ratio = pct(a, t);
                            tr.querySelector('.bar > span').style.width = (ratio ?? 0) + '%';
                            const d = a - t;
                            const badge = tr.querySelector('.delta-col .delta-badge');
                            if (t === 0 && a === 0) {
                                badge.textContent = '—';
                                badge.className = 'delta-badge delta-zero';
                            } else if (d > 0) {
                                badge.textContent = '+' + d.toLocaleString();
                                badge.className = 'delta-badge delta-pos';
                            } else if (d < 0) {
                                badge.textContent = d.toLocaleString();
                                badge.className = 'delta-badge delta-neg';
                            } else {
                                badge.textContent = '0';
                                badge.className = 'delta-badge delta-zero';
                            }
                        }
                    });

                    const sumA = actual.reduce((s, v) => s + v, 0);
                    const sumT = target.reduce((s, v) => s + v, 0);
                    const rate = pct(sumA, sumT);

                    // KPIs
                    kpiActual.textContent = fmt(sumA);
                    kpiTarget.textContent = fmt(sumT);
                    kpiRate.textContent = (rate === null) ? '—' : (rate + '%');
                    kpiRateHint.textContent = (rate === null) ? 'لا يوجد مستهدف لإحتساب النسبة' : (sumA >=
                        sumT ? 'أداء أعلى من المستهدف' : 'أقل من المستهدف');

                    const scaleMax = Math.max(sumA, sumT, 1);
                    animateLine(actualLine, (sumA / scaleMax) * 100);
                    animateLine(targetLine, (sumT / scaleMax) * 100);
                    animateLine(rateLine, (rate ?? 0));

                    // Charts
                    renderBarChart(monthLabels, actual, target);
                    renderDoughnutChart(sumA, sumT);
                });
            }

            goalsYear.addEventListener('change', loadGoals);
            loadGoals();
        });
    </script>
@endsection
