@extends('layouts.master')

@php
    $isEdit = isset($customer);
    $action = $isEdit ? route('customers.update', $customer) : route('customers.store');
    $method = $isEdit ? 'PUT' : 'POST';
@endphp

@section('title', $isEdit ? 'تعديل عميل' : 'إضافة عميل')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('content')
    <div class="container-fluid">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $e)
                        <li>{{ $e }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ $action }}" method="POST">
            @csrf @if ($isEdit)
                @method('PUT')
            @endif

            <div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
                <h5 class="mb-0">{{ $isEdit ? 'تعديل عميل' : 'إضافة عميل' }}</h5>
                <div class="d-flex gap-2">
                    <button class="btn btn-primary"><i class="fas fa-save mx-2"></i>{{ $isEdit ? 'تحديث' : 'حفظ' }}</button>
                    <a href="{{ route('customers.index') }}" class="btn btn-secondary">رجوع</a>
                </div>
            </div>

            <div class="card p-3">
                <div class="row g-3">

                    <div class="col-md-12">
                        @if ($userBranchId && $userBranch)
                            {{-- 🔹 المستخدم له فرع ثابت --}}
                            <div class="alert d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>🔸  الفرع الحالي : </strong>
                                    {{ is_array($userBranch->name)
                                        ? $userBranch->name[app()->getLocale()] ?? ($userBranch->name['en'] ?? '')
                                        : (method_exists($userBranch, 'getTranslation')
                                            ? $userBranch->getTranslation('name', app()->getLocale())
                                            : $userBranch->name) }}
                                    <span class="text-muted">({{ $userBranch->branch_code }})</span>
                                </div>
                                <input type="hidden" name="branch_id" id="branch_id" value="{{ $userBranch->id }}">
                            </div>
                        @else
                            {{-- 🔹 المستخدم ليس له فرع → يظهر له الاختيار --}}
                            <div class="col-md-12">
                                <label class="form-label">الفرع <span class="text-danger">*</span></label>
                                <select name="branch_id" id="branch_id" class="form-select" required>
                                    <option value="">— اختر —</option>
                                    @foreach ($branches as $b)
                                        <option value="{{ $b->id }}" @selected((int) old('branch_id', $isEdit ? $customer->branch_id : null) === (int) $b->id)>
                                            {{ method_exists($b, 'getTranslation')
                                                ? $b->getTranslation('name', app()->getLocale())
                                                : (is_array($b->name)
                                                    ? $b->name[app()->getLocale()] ?? ($b->name['en'] ?? '')
                                                    : $b->name) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        @endif
                    </div>


                    <div class="col-md-6">
                        <label class="form-label">كود العميل</label>
                        <input type="text" id="code_preview" class="form-control"
                            value="{{ $isEdit ? $customer->customer_code : '— جاري توليد الكود —' }}" readonly>
                        {{-- <div class="form-text text-muted">الكود يثبت عند الحفظ، ويُولَّد تسلسليًا لكل فرع.</div> --}}
                    </div>


                    <div class="col-md-6">
                        <label class="form-label">اسم العميل <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control"
                            value="{{ old('name', $isEdit ? $customer->name : '') }}" required>
                    </div>

                </div>
            </div>
        </form>
    </div>
@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const branchSel = document.getElementById('branch_id');
            const codePrev = document.getElementById('code_preview');

            function loadPreview() {
                const bid = branchSel?.value;
                if (!bid) {
                    codePrev.value = '— حدّد الفرع لعرض الكود المقترح —';
                    return;
                }

                fetch(`{{ route('customers.predict') }}?branch_id=${bid}`)
                    .then(r => r.json())
                    .then(res => codePrev.value = res.code || '—')
                    .catch(() => codePrev.value = '—');
            }

            // ✅ الحالة 1: المستخدم له فرع (مخفي من الاختيار)
            if (branchSel && branchSel.tagName === 'INPUT') {
                loadPreview(); // توليد الكود فورًا
            }

            // ✅ الحالة 2: المستخدم يختار يدويًا (السوبر أدمن)
            if (branchSel && branchSel.tagName === 'SELECT') {
                branchSel.addEventListener('change', loadPreview);
            }
        });
    </script>
@endsection
