@extends('layouts.master')

@section('title', 'عرض عميل')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('content')
    <div class="container-fluid">
        <div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
            <h5 class="mb-0">عرض عميل</h5>
            <div class="d-flex gap-2">
                <a href="{{ route('customers.edit', $customer) }}" class="btn btn-warning"><i
                        class="fas fa-edit mx-2"></i>تعديل</a>
                <a href="{{ route('customers.index') }}" class="btn btn-secondary">رجوع</a>
            </div>
        </div>

        <div class="card p-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <div class="fw-bold text-muted mb-1">كود العميل</div>
                    <div class="fs-5">{{ $customer->customer_code }}</div>
                </div>
                <div class="col-md-4">
                    <div class="fw-bold text-muted mb-1">اسم العميل</div>
                    <div class="fs-5">{{ $customer->name }}</div>
                </div>
                <div class="col-md-4">
                    <div class="fw-bold text-muted mb-1">الفرع</div>
                    <div class="fs-6">
                        {{ method_exists($customer->branch, 'getTranslation')
                            ? $customer->branch->getTranslation('name', app()->getLocale())
                            : (is_array($customer->branch->name)
                                ? $customer->branch->name[app()->getLocale()] ?? ($customer->branch->name['en'] ?? '')
                                : $customer->branch->name) }}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="fw-bold text-muted mb-1">تاريخ الإنشاء</div>
                    <div>{{ $customer->created_at }}</div>
                </div>
                <div class="col-md-4">
                    <div class="fw-bold text-muted mb-1">آخر تحديث</div>
                    <div>{{ $customer->updated_at }}</div>
                </div>
            </div>
        </div>
    </div>
@endsection
