@extends('layouts.master')
@section('title', 'الأعضاء')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
            <h5 class="mb-0">الأعضاء</h5>
            <a href="{{ route('members.create') }}" class="btn btn-primary"><i class="fas fa-user-plus mx-2"></i>إضافة عضو</a>
        </div>

        <div class="card p-3 mb-3">
            <div class="row g-2">
                <div class="col-md-4"><input id="f_name" type="text" class="form-control" placeholder="ابحث بالاسم">
                </div>
                <div class="col-md-4">
                    <select id="f_branch" class="form-select">
                        <option value="">— كل الفروع —</option>
                        @foreach ($branches as $b)
                            <option value="{{ $b->id }}">
                                {{ method_exists($b, 'getTranslation') ? $b->getTranslation('name', app()->getLocale()) : (is_array($b->name) ? $b->name[app()->getLocale()] ?? ($b->name['en'] ?? '') : $b->name) }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 d-grid d-md-flex gap-2">
                    <button id="f_reset" class="btn btn-secondary">إعادة تعيين</button>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table id="members-table" class="table table-bordered w-100">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>كود العضو</th>
                        <th>الاسم</th>
                        <th>الفرع</th>
                        <th>الحالة</th>
                        <th>أُنشئ</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(function() {
            $('#members-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('members.index') }}",
                    type: "GET",
                    data: function(d) {
                        d.branch_id = $('#filter-branch').val() || ''; // لو عندك فلتر فرع
                        d.name = $('#filter-name').val() || '';
                    },
                    error: function(xhr) {
                        console.error('DT load failed:', xhr.responseText);
                        alert('فشل تحميل البيانات. راجع السجل أو Network.');
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'member_code',
                        name: 'member_code'
                    },
                    {
                        data: 'branch_name',
                        name: 'branch.name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'status_badge',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                order: [
                    [4, 'desc']
                ]
            });

            // إعادة التحميل عند تغيير الفلاتر
            $('#filter-branch, #filter-name').on('change keyup', function() {
                $('#members-table').DataTable().ajax.reload();
            });
        });
    </script>

@endsection
