{{-- resources/views/admin/members/show.blade.php --}}
@extends('layouts.master')

@section('title', 'عرض العضو')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('css')
    <style>
        .card-section {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 16px
        }

        .kv {
            display: flex;
            gap: .5rem;
            align-items: center;
            margin: .25rem 0
        }

        .kv .k {
            min-width: 150px;
            color: #9fb3c8
        }

        .badge-status {
            font-size: .85rem
        }

        .avatar {
            max-height: 140px;
            border-radius: 12px
        }

        .img-doc {
            max-height: 140px;
            border-radius: 10px
        }

        .grid-2 {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px
        }

        @media (max-width: 768px) {
            .grid-2 {
                grid-template-columns: 1fr
            }
        }
    </style>

    <style>
        .media-grid {
            display: grid;
            gap: 14px
        }

        @media (min-width:768px) {
            .media-grid {
                grid-template-columns: repeat(12, 1fr)
            }

            .media-col {
                grid-column: auto/span 4
            }
        }

        .media-card {
            background: #0e1b27;
            border: 1px solid #203242;
            border-radius: 16px;
            padding: 12px;
            position: relative;
            box-shadow: 0 10px 28px rgba(0, 0, 0, .25);
            transition: transform .2s ease, border-color .2s ease
        }

        .media-card:hover {
            transform: translateY(-2px);
            border-color: #2ca0ff
        }

        .media-head {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 10px
        }

        .media-title {
            margin: 0;
            font-weight: 700;
            color: #d9f0ff
        }

        .media-stage {
            position: relative;
            border-radius: 12px;
            background: #0a1621;
            overflow: hidden;
            min-height: 220px;
            display: flex;
            align-items: center;
            justify-content: center
        }

        .media-img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
            display: block
        }

        .media-empty {
            color: #95b9d6;
            display: flex;
            flex-direction: column;
            gap: 8px;
            align-items: center
        }

        .media-empty i {
            font-size: 34px;
            opacity: .8
        }

        .media-badge {
            position: absolute;
            top: 10px;
            inset-inline-start: 10px;
            background: #0f2434;
            color: #bfe4ff;
            border: 1px solid #234760;
            border-radius: 999px;
            padding: 4px 10px;
            font-size: .78rem
        }

        .media-actions {
            position: absolute;
            inset-inline: 0;
            bottom: 0;
            padding: 10px;
            background: linear-gradient(180deg, rgba(10, 22, 33, 0) 0%, rgba(10, 22, 33, .85) 60%, rgba(10, 22, 33, .98) 100%);
            display: flex;
            gap: 8px;
            justify-content: center;
            transform: translateY(100%);
            transition: transform .2s ease
        }

        .media-card:hover .media-actions {
            transform: translateY(0)
        }

        .btn-soft {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 7px 12px;
            border-radius: 999px;
            border: 1px solid #2b4a64;
            background: #0f2230;
            color: #d2ebff;
            font-size: .85rem;
            text-decoration: none;
            transition: .2s
        }

        .btn-soft:hover {
            transform: translateY(-1px);
            border-color: #3aa9ff;
            color: #eafbff
        }

        .btn-soft.outline {
            background: transparent
        }

        .btn-soft.danger {
            border-color: #7a2b2b;
            color: #ffbcbc;
            background: #1a0f12
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">

        {{-- Header --}}
        <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
            <div>
                <h5 class="mb-1">
                    {{ $member->name ?? ($member->full_name ?? '—') }}
                    <small class="text-muted">(#{{ $member->member_code }})</small>
                </h5>
                <div>
                    @php
                        $status = $member->status;
                        $badge = match ($status) {
                            'new' => 'info',
                            'active' => 'success',
                            default => 'secondary',
                        };
                        $statusText = match ($status) {
                            'new' => 'جديد',
                            'active' => 'نشط',
                            default => 'غير نشط',
                        };
                    @endphp
                    <span class="badge bg-{{ $badge }} badge-status">{{ $statusText }}</span>
                </div>
            </div>

            <div class="d-flex gap-2">
                <a href="{{ route('members.edit', $member->id) }}" class="btn btn-warning">
                    <i class="fas fa-edit me-1"></i> تعديل
                </a>
                <a href="{{ route('members.index') }}" class="btn btn-secondary">
                    رجوع
                </a>
            </div>
        </div>


        @php
            $avatarUrl = !empty($member->avatar_path) ? asset($member->avatar_path) : null;
            $idUrl = !empty($member->id_image_path ?? $member->id_card_image_path)
                ? asset($member->id_image_path ?? $member->id_card_image_path)
                : null;
            $workUrl = !empty($member->work_card_image_path) ? asset($member->work_card_image_path) : null;
        @endphp
        {{-- صف الصور --}}
        <div class="card-section">
            <h6 class="mb-2">الصور</h6>
            <div class="media-grid">
                {{-- الصورة الشخصية --}}
                <div class="media-col">
                    <div class="media-card">
                        <div class="media-head">
                            <h6 class="media-title">الصورة الشخصية</h6>
                        </div>
                        <div class="media-stage">
                            <div class="media-badge">معاينة</div>
                            @if ($avatarUrl)
                                <img class="media-img" src="{{ $avatarUrl }}" alt="avatar">
                                <div class="media-actions">
                                    <a href="#" class="btn-soft" data-bs-toggle="modal" data-bs-target="#imgModal"
                                        data-img="{{ $avatarUrl }}">
                                        <i class="fas fa-eye"></i> عرض
                                    </a>
                                    <a class="btn-soft outline" href="{{ $avatarUrl }}" download>
                                        <i class="fas fa-download"></i> تحميل
                                    </a>
                                </div>
                            @else
                                <div class="media-empty">
                                    <i class="far fa-user-circle"></i>
                                    <span>— لا توجد صورة —</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- صورة بطاقة الهوية --}}
                <div class="media-col">
                    <div class="media-card">
                        <div class="media-head">
                            <h6 class="media-title">صورة الهوية</h6>
                        </div>
                        <div class="media-stage">
                            <div class="media-badge">معاينة</div>
                            @if ($idUrl)
                                <img class="media-img" src="{{ $idUrl }}" alt="id">
                                <div class="media-actions">
                                    <a href="#" class="btn-soft" data-bs-toggle="modal" data-bs-target="#imgModal"
                                        data-img="{{ $idUrl }}">
                                        <i class="fas fa-eye"></i> عرض
                                    </a>
                                    <a class="btn-soft outline" href="{{ $idUrl }}" download>
                                        <i class="fas fa-download"></i> تحميل
                                    </a>
                                </div>
                            @else
                                <div class="media-empty">
                                    <i class="far fa-id-card"></i>
                                    <span>— لا توجد صورة —</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- صورة بطاقة العمل --}}
                <div class="media-col">
                    <div class="media-card">
                        <div class="media-head">
                            <h6 class="media-title">صورة بطاقة العمل</h6>
                        </div>
                        <div class="media-stage">
                            <div class="media-badge">معاينة</div>
                            @if ($workUrl)
                                <img class="media-img" src="{{ $workUrl }}" alt="work-card">
                                <div class="media-actions">
                                    <a href="#" class="btn-soft" data-bs-toggle="modal" data-bs-target="#imgModal"
                                        data-img="{{ $workUrl }}">
                                        <i class="fas fa-eye"></i> عرض
                                    </a>
                                    <a class="btn-soft outline" href="{{ $workUrl }}" download>
                                        <i class="fas fa-download"></i> تحميل
                                    </a>
                                </div>
                            @else
                                <div class="media-empty">
                                    <i class="fas fa-briefcase"></i>
                                    <span>— لا توجد صورة —</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Modal لعرض الصورة بالحجم الكامل --}}
        <div class="modal fade" id="imgModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl">
                <div class="modal-content" style="background:#0b1621;border:1px solid #23465e">
                    <div class="modal-header" style="border-bottom-color:#22394e">
                        <h6 class="modal-title">عرض الصورة</h6>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body p-2"
                        style="display:flex;justify-content:center;align-items:center;min-height:60vh;background:#07121b">
                        <img id="imgModalTag" src="" alt="preview"
                            style="max-width:100%;max-height:80vh;border-radius:12px;box-shadow:0 12px 40px rgba(0,0,0,.45)">
                    </div>
                    <div class="modal-footer" style="border-top-color:#22394e">
                        <a id="imgModalDownload" class="btn btn-primary" href="#" download>
                            <i class="fas fa-download me-1"></i> تحميل
                        </a>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    </div>
                </div>
            </div>
        </div>

        {{-- بيانات أساسية --}}
        <div class="card-section">
            <h6 class="mb-2">البيانات الأساسية</h6>
            <div class="grid-2">
                <div>
                    <div class="kv">
                        <div class="k">الفرع</div>
                        <div>
                            @php $b = $member->branch ?? null; @endphp
                            {{ $b
                                ? (method_exists($b, 'getTranslation')
                                    ? $b->getTranslation('name', app()->getLocale())
                                    : (is_array($b->name)
                                        ? $b->name[app()->getLocale()] ?? ($b->name['en'] ?? '')
                                        : $b->name))
                                : '—' }}
                            @if ($b?->branch_code)
                                <small class="text-muted">(كود: {{ $b->branch_code }})</small>
                            @endif
                        </div>
                    </div>
                    <div class="kv">
                        <div class="k">اسم العضو</div>
                        <div>{{ $member->name ?? ($member->full_name ?? '—') }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">الجنس</div>
                        <div>
                            @if ($member->gender === 'male')
                                ذكر
                            @elseif($member->gender === 'female')
                                أنثى
                            @else
                                —
                            @endif
                        </div>
                    </div>
                    <div class="kv">
                        <div class="k">الجنسية</div>
                        <div>
                            {{ $member->nationality->name ?? '—' }}
                        </div>
                    </div>
                </div>

                <div>
                    <div class="kv">
                        <div class="k">الهاتف</div>
                        <div>{{ $member->phone ?: '—' }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">البريد الإلكتروني</div>
                        <div>{{ $member->email ?: '—' }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">العنوان</div>
                        <div>{{ $member->address ?: '—' }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">صندوق/رمز بريدي</div>
                        <div>
                            {{ $member->po_box ?: '—' }}
                            @if ($member->postal_code)
                                — {{ $member->postal_code }}
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- الهوية --}}
        <div class="card-section">
            <h6 class="mb-2">بيانات الهوية</h6>
            <div class="grid-2">
                <div>
                    <div class="kv">
                        <div class="k">نوع الهوية</div>
                        <div>
                            @php
                                $typesMap = [
                                    'national_id' => 'هوية وطنية',
                                    'iqama' => 'إقامة',
                                    'passport' => 'جواز سفر',
                                    'driving_license' => 'رخصة قيادة',
                                    'work_card' => 'بطاقة عمل',
                                    'residence' => 'إقامة', // تلاؤم مع سكيمات قديمة
                                ];
                            @endphp
                            {{ $typesMap[$member->id_type ?? ($member->card_type ?? '')] ?? '—' }}
                        </div>
                    </div>
                    <div class="kv">
                        <div class="k">رقم الهوية</div>
                        <div>{{ $member->id_number ?? ($member->card_number ?? '—') }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">تاريخ الإصدار (ميلادي)</div>
                        <div>
                            {{ $member->id_issue_greg ?? $member->issued_at_g
                                ? \Carbon\Carbon::parse($member->id_issue_greg ?? $member->issued_at_g)->format('Y-m-d')
                                : '—' }}
                        </div>
                    </div>
                    <div class="kv">
                        <div class="k">تاريخ الانتهاء (ميلادي)</div>
                        <div>
                            {{ $member->id_expiry_greg ?? $member->expires_at_g
                                ? \Carbon\Carbon::parse($member->id_expiry_greg ?? $member->expires_at_g)->format('Y-m-d')
                                : '—' }}
                        </div>
                    </div>
                </div>

                <div>
                    <div class="kv">
                        <div class="k">تاريخ الإصدار (هجري)</div>
                        <div>{{ $member->id_issue_hijri ?? ($member->issued_at_h ?? '—') }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">تاريخ الانتهاء (هجري)</div>
                        <div>{{ $member->id_expiry_hijri ?? ($member->expires_at_h ?? '—') }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">تاريخ الميلاد (ميلادي)</div>
                        <div>
                            {{ $member->birth_greg ?? $member->dob_g
                                ? \Carbon\Carbon::parse($member->birth_greg ?? $member->dob_g)->format('Y-m-d')
                                : '—' }}
                        </div>
                    </div>
                    <div class="kv">
                        <div class="k">تاريخ الميلاد (هجري)</div>
                        <div>{{ $member->birth_hijri ?? ($member->dob_h ?? '—') }}</div>
                    </div>
                    <div class="kv">
                        <div class="k">العمر</div>
                        <div>{{ $member->age ?? '—' }}</div>
                    </div>
                </div>
            </div>
        </div>

        {{-- كيف تعرف علينا --}}
        <div class="card-section">
            <h6 class="mb-2">كيف تعرف علينا</h6>
            @php
                $how = $member->how_heard ?? ($member->hear_about_us ?? []);
                if (is_string($how)) {
                    $decoded = json_decode($how, true);
                    if (json_last_error() === JSON_ERROR_NONE) {
                        $how = $decoded;
                    }
                }
                if (!is_array($how)) {
                    $how = [];
                }
            @endphp
            @if (count($how))
                <div class="d-flex flex-wrap gap-2">
                    @foreach ($how as $tag)
                        <span class="badge bg-dark">{{ $tag }}</span>
                    @endforeach
                </div>
            @else
                <div class="text-muted">— لا توجد —</div>
            @endif
        </div>

    </div>
@endsection
@section('js')
    <script>
        // ضبط صورة المودال ورابط التحميل بشكل ديناميكي
        document.addEventListener('click', function(e) {
            const btn = e.target.closest('[data-bs-target="#imgModal"][data-img]');
            if (!btn) return;
            const url = btn.getAttribute('data-img');
            const img = document.getElementById('imgModalTag');
            const dl = document.getElementById('imgModalDownload');
            img.src = url || '';
            dl.href = url || '#';
            // نحاول اقتراح اسم ملف عند التحميل
            try {
                const name = url.split('/').pop();
                dl.setAttribute('download', name || 'download');
            } catch (_) {}
        });
    </script>
    
@endsection
