{{-- resources/views/admin/offers/create.blade.php --}}
@extends('layouts.master')
@section('title', 'إضافة عرض')

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <!-- ✅ Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <style>
        .shell {
            background: #0f1e2b;
            border-radius: 14px;
            padding: 14px
        }

        .block {
            background: #0b1621;
            border: 1px solid #203446;
            border-radius: 12px;
            padding: 12px
        }

        .muted {
            opacity: .8
        }

        .badge-soft {
            background: #13283a;
            border: 1px solid #254a65;
            border-radius: 999px;
            padding: 2px 10px;
            color: #d6f0ff
        }

        .table-offer th,
        .table-offer td {
            vertical-align: middle
        }

        .side-panel {
            min-height: 100%;
            display: flex;
            flex-direction: column;
            gap: 10px
        }

        .btn-circle {
            width: 38px;
            height: 38px;
            border-radius: 50%
        }

        .disabled-wrap {
            opacity: .55;
            pointer-events: none;
            filter: grayscale(.3)
        }

        .svc-name {
            white-space: normal;
            line-height: 1.35
        }

        .svc-meta {
            font-size: .85rem;
            opacity: .85
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $e)
                        <li>{{ $e }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('offers.store') }}" method="POST" id="offerForm">
            @csrf
            <div class="d-flex align-items-center justify-content-between mb-3">
                <h2 class="mb-0">إضافة عرض رقم : <strong class="text-danger bold">
                        {{ $nextNo }}
                    </strong>
                </h2>
                <div class="d-flex gap-2">
                    <button class="btn btn-primary"><i class="fas fa-save me-2"></i>حفظ</button>
                    <a href="{{ route('offers.index') }}" class="btn btn-secondary">رجوع</a>
                </div>
            </div>
            <div class="row g-3">
                {{-- يسار --}}
                <div class="col-lg-8">
                    <div class="shell">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <div class="block">
                                    <label class="form-label">اسم العرض (ar) <span class="text-danger">*</span></label>
                                    <input type="text" name="name[ar]" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="block">
                                    <label class="form-label">اسم العرض (en) <span class="text-danger">*</span></label>
                                    <input type="text" name="name[en]" class="form-control" required>
                                </div>
                            </div>

                            {{-- ✅ النطاق + التخصيص --}}
                            <div class="col-md-12">
                                <div class="card shadow-sm">
                                    <div class="card-header bg-light fw-bold text-center">
                                        <i class="fas fa-bullseye me-1 text-primary "></i> الفئة المستهدفة
                                    </div>

                                    <div class="card-body">
                                        <div class="d-flex flex-wrap gap-4 mb-4 justify-content-around">
                                            <div class="form-check">
                                                <input class="form-check-input scope-check" type="checkbox" id="chk_members"
                                                    value="members" name="scope">
                                                <label class="form-check-label fw-semibold" for="chk_members">
                                                    <i class="fas fa-users text-primary me-1"></i> الأعضاء
                                                </label>
                                            </div>

                                            <div class="form-check">
                                                <input class="form-check-input scope-check" type="checkbox"
                                                    id="chk_customers" value="customers" name="scope">
                                                <label class="form-check-label fw-semibold" for="chk_customers">
                                                    <i class="fas fa-user-tie text-success me-1"></i> العملاء
                                                </label>
                                            </div>

                                            <div class="form-check">
                                                <input class="form-check-input scope-check" type="checkbox" id="chk_coupons"
                                                    value="coupons" name="scope">
                                                <label class="form-check-label fw-semibold" for="chk_coupons">
                                                    <i class="fas fa-ticket-alt text-warning me-1"></i> كوبونات
                                                </label>
                                            </div>
                                        </div>

                                        {{-- 🧍 الأعضاء --}}
                                        <div id="box_members" class="d-none">

                                        </div>

                                        {{-- 👤 العملاء --}}
                                        <div id="box_customers" class="d-none text-center">
                                            <button type="button" class="btn btn-outline-success mb-3"
                                                data-bs-toggle="modal" data-bs-target="#customerModal">
                                                <i class="fas fa-user-plus mx-1"></i> اختيار العميل
                                            </button>

                                            <div id="selectedCustomerBox"
                                                class="alert alert-light border text-muted small d-none">
                                                <i class="fas fa-user"></i> <span id="selectedCustomerName"></span>
                                            </div>
                                        </div>

                                        {{-- 🎟️ الكوبونات --}}
                                        <div id="box_coupons" class="d-none">
                                            <label class="form-label fw-bold">أكواد الكوبونات</label>
                                            <input type="text" class="form-control" id="coupon_inline"
                                                name="coupon_inline" placeholder="ABC123, XYZ50"
                                                value="{{ old('coupon_inline', '') }}">
                                            <div class="form-text text-muted">اكتب الأكواد مفصولة بفواصل (،)</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- 🧩 مودال اختيار عميل --}}
                            <div class="modal fade" id="customerModal" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog modal-lg modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header bg-success text-white">
                                            <h5 class="modal-title"><i class="fas fa-user-check me-1"></i> اختيار العميل
                                            </h5>
                                            <button type="button" class="btn-close btn-close-white"
                                                data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <label class="form-label fw-bold">ابحث عن العميل:</label>
                                            <select class="form-select" id="customer_select_modal" style="width: 100%">
                                                <option value="">— اختر العميل —</option>
                                                @foreach ($customers as $c)
                                                    <option value="{{ $c->id }}">{{ $c->name }} —
                                                        {{ $c->customer_code ?? $c->id }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-success"
                                                id="saveSelectedCustomer">تأكيد الاختيار</button>
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">إغلاق</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- حقل مخفي لحفظ العميل المختار --}}
                            <input type="hidden" name="target_customer_id" id="target_customer_id">


                            {{-- التواريخ --}}
                            <div class="col-md-12">
                                <div class="block">
                                    <div class="row g-3 align-items-end">
                                        <div class="col-md-6">
                                            <label class="form-label">تاريخ البداية (ميلادي)</label>
                                            <input type="date" class="form-control" name="start_date_g"
                                                id="start_g" required>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">تاريخ النهاية (ميلادي)</label>
                                            <input type="date" class="form-control" name="end_date_g" id="end_g"
                                                required>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">تاريخ البداية (هجري)</label>
                                            <input type="text" class="form-control" name="start_date_h"
                                                id="start_h" readonly>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">تاريخ النهاية (هجري)</label>
                                            <input type="text" class="form-control" name="end_date_h" id="end_h"
                                                readonly>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">المدّة (أيام)</label>
                                            <input type="text" class="form-control" id="duration_days" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="shell side-panel">
                        <div class="row g-3">
                            <div class="col-md-12">
                                <label class="form-label">الخصم العام</label>
                                <div class="input-group">
                                    <select class="form-select" name="g_discount_type" id="g_discount_type"
                                        style="max-width:110px">
                                        <option value="percent" selected>%</option>
                                        <option value="amount">مبلغ</option>
                                    </select>
                                    <input type="number" step="0.01" min="0" class="form-control"
                                        name="g_discount_value" id="g_discount_value" placeholder="0">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">أيام إضافية (لكل خدمة)</label>
                                <input type="number" class="form-control" name="g_extra_days" id="g_extra_days"
                                    min="0" placeholder="0">
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">عدد أيام الإيقاف</label>
                                <input type="number" class="form-control" name="g_stop_days" id="g_stop_days"
                                    min="0" placeholder="0">
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">عدد مرات الإيقاف</label>
                                <input type="number" class="form-control" name="g_stop_times" id="g_stop_times"
                                    min="0" placeholder="0">
                            </div>

                            <div class="col-md-12">
                                <label class="form-label fw-bold">الخدمات</label>
                                <button type="button" class="btn btn-outline-primary w-100" id="openServicesModal">
                                    <i class="fas fa-list me-1"></i> اختيار الخدمات
                                </button>

                                <div id="selectedServicesBox" class="alert  mt-2 d-none small text-center">
                                    <strong>الخدمات المختارة:</strong>
                                    <div id="selectedServicesNames" class="fw-semibold text-dark mt-1"></div>
                                </div>

                            </div>
                            <div class="col-md-12">
                                <button type="button" class="btn btn-success w-100" id="addServiceBtn">
                                    <i class="fas fa-plus me-1"></i> إضافة الخدمات المحددة
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- جدول الخدمات --}}
                <div class="col-md-12 mt-3">
                    <div class="block">
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered text-center align-middle" id="itemsTable">
                                <thead class="">
                                    <tr>
                                        <th>#</th>
                                        <th>الخدمة</th>
                                        <th>السعر الأساسي</th>
                                        <th>السعر بعد الخصم</th>
                                        <th>المدة الإضافية</th>
                                        <th>أيام الإيقاف</th>
                                        <th>مرات الإيقاف</th>
                                        <th>حذف</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div id="itemsHidden"></div>
                {{-- مودال اختيار الخدمات --}}
                <div class="modal fade" id="servicesModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header bg-primary text-white">
                                <h5 class="modal-title"><i class="fas fa-list-check me-2"></i> اختيار الخدمات</h5>
                                <button type="button" class="btn-close btn-close-white"
                                    data-bs-dismiss="modal"></button>
                            </div>

                            <div class="modal-body">
                                <select class="form-select" id="services_select_modal" multiple style="width:100%">
                                    @foreach ($services as $s)
                                        <option value="{{ $s->id }}" data-price="{{ $s->price }}">
                                            {{ $s->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="form-text text-muted mt-2">يمكنك البحث واختيار أكثر من خدمة.</div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-success" id="saveSelectedServices">تأكيد</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                            </div>
                        </div>
                    </div>
                </div>

                <input type="hidden" name="selected_service_ids" id="selected_service_ids">

            </div>


        </form>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment-hijri@2.2.0/moment-hijri.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {

            // ======== 🔹 تفعيل الفئات المستهدفة (Scope) ========
            const checkboxes = $('.scope-check');
            const boxes = {
                members: $('#box_members'),
                customers: $('#box_customers'),
                coupons: $('#box_coupons')
            };
            const selectedCustomerBox = $('#selectedCustomerBox');
            const selectedCustomerName = $('#selectedCustomerName');
            const targetCustomerInput = $('#target_customer_id');

            // عرض القسم المختار فقط (واحد في كل مرة)
            function toggleScope(target) {
                checkboxes.prop('checked', false);
                target.prop('checked', true);

                $.each(boxes, function(_, el) {
                    el.addClass('d-none');
                });

                targetCustomerInput.val('');
                selectedCustomerBox.addClass('d-none');
                selectedCustomerName.text('');
                $('#coupon_inline').val('');

                const scope = target.val();
                if (boxes[scope]) boxes[scope].removeClass('d-none');
            }

            // عند تحميل الصفحة: إعادة عرض القسم المختار لو رجع old()
            const oldScope = "{{ old('scope') }}";
            if (oldScope && boxes[oldScope]) {
                $('#chk_' + oldScope).prop('checked', true);
                boxes[oldScope].removeClass('d-none');
            }

            checkboxes.on('change', function() {
                toggleScope($(this));
            });

            // ======== 🔹 مودال اختيار العميل ========
            $('#customer_select_modal').select2({
                dropdownParent: $('#customerModal'),
                width: '100%',
                placeholder: 'ابحث عن العميل...',
                allowClear: true,
                language: {
                    noResults: () => 'لا توجد نتائج',
                    searching: () => 'جارٍ البحث...'
                }
            });

            $('#saveSelectedCustomer').click(function() {
                const selected = $('#customer_select_modal').find(':selected');
                const id = selected.val();
                const name = selected.text();
                if (!id) return alert('من فضلك اختر العميل أولاً');

                targetCustomerInput.val(id);
                selectedCustomerName.text(name);
                selectedCustomerBox.removeClass('d-none');
                bootstrap.Modal.getInstance(document.getElementById('customerModal')).hide();
            });

            // ======== 🔹 التواريخ: هجري + تحقق ========
            function gToH(iso) {
                if (!iso) return '';
                try {
                    // نحاول أولاً استخدام moment-hijri إن كانت متوفرة
                    const m = moment(iso, 'YYYY-MM-DD', true);
                    if (!m.isValid() || typeof m.iYear !== 'function') {
                        console.warn('moment-hijri غير مفعّل، نحاول بديل محلي.');
                        return convertWithIntl(iso); // fallback للطريقة المحلية
                    }
                    return m.iFormat('iYYYY-iMM-iDD'); // ✅ التحويل الحقيقي للهجري
                } catch (err) {
                    console.error('خطأ أثناء التحويل للهجري:', err);
                    return convertWithIntl(iso);
                }
            }

            // في حالة فشل moment-hijri نستخدم بديل موثوق من المتصفح نفسه
            function convertWithIntl(iso) {
                try {
                    const dt = new Date(iso + 'T00:00:00');
                    const fmt = new Intl.DateTimeFormat('en-u-ca-islamic', {
                        year: 'numeric',
                        month: '2-digit',
                        day: '2-digit'
                    });
                    const parts = fmt.formatToParts(dt);
                    const y = parts.find(p => p.type === 'year').value;
                    const m = parts.find(p => p.type === 'month').value;
                    const d = parts.find(p => p.type === 'day').value;
                    return `${y}-${m}-${d}`;
                } catch {
                    return '';
                }
            }

            function refreshDates() {
                const s = $('#start_g').val();
                const e = $('#end_g').val();

                if (s && e && moment(e).isBefore(moment(s))) {
                    alert('❌ لا يمكن أن يكون تاريخ النهاية قبل تاريخ البداية');
                    $('#end_g, #end_h, #duration_days').val('');
                    return;
                }

                $('#start_h').val(gToH(s));
                $('#end_h').val(gToH(e));

                if (s && e) {
                    const diff = moment(e).diff(moment(s), 'days') + 1;
                    $('#duration_days').val(diff > 0 ? diff : 0);
                } else {
                    $('#duration_days').val('');
                }
            }


            $('#start_g, #end_g').on('change', refreshDates);
            refreshDates();

            // ======== 🔹 مودال اختيار الخدمات ========
            $('#services_select_modal').select2({
                dropdownParent: $('#servicesModal'),
                width: '100%',
                placeholder: 'اختر الخدمات...',
                language: {
                    noResults: () => 'لا توجد نتائج',
                    searching: () => 'جارٍ البحث...'
                }
            });

            $('#openServicesModal').click(() => $('#servicesModal').modal('show'));

            $('#saveSelectedServices').click(function() {
                const selected = $('#services_select_modal').find(':selected');
                if (selected.length === 0) {
                    alert('يرجى اختيار خدمة واحدة على الأقل');
                    return;
                }

                const ids = [];
                const names = [];

                selected.each(function() {
                    ids.push($(this).val());
                    names.push($(this).text());
                });

                // حفظ الـ IDs في hidden input
                $('#selected_service_ids').val(ids.join(','));

                // ✅ عرض الأسماء أسفل الزر
                $('#selectedServicesNames').html(
                    names.map(n => `<span class="badge bg-primary mx-1">${n}</span>`).join('')
                );

                $('#selectedServicesBox').removeClass('d-none');

                // إغلاق المودال
                $('#servicesModal').modal('hide');
            });


            // ======== 🔹 إضافة الخدمات ========
            $('#addServiceBtn').click(function() {
                const ids = $('#selected_service_ids').val();
                const discountType = $('#g_discount_type').val();
                const discountValue = parseFloat($('#g_discount_value').val());
                const extraDays = parseInt($('#g_extra_days').val());
                const stopDays = parseInt($('#g_stop_days').val());
                const stopTimes = parseInt($('#g_stop_times').val());

                if (!ids) return alert('يرجى اختيار الخدمات أولاً.');
                if (isNaN(discountValue)) return alert('قيمة الخصم مطلوبة.');
                if (isNaN(extraDays)) return alert('عدد الأيام الإضافية مطلوب.');
                if (isNaN(stopDays)) return alert('عدد أيام الإيقاف مطلوب.');
                if (isNaN(stopTimes)) return alert('عدد مرات الإيقاف مطلوبة.');

                const tbody = $('#itemsTable tbody');
                const hiddenBox = $('#itemsHidden');
                tbody.empty();
                hiddenBox.empty();

                $('#services_select_modal').find(':selected').each(function(i) {
                    const id = $(this).val();
                    const name = $(this).text();
                    const price = parseFloat($(this).data('price')) || 0;
                    const finalPrice = discountType === 'percent' ?
                        price - (price * discountValue / 100) :
                        Math.max(0, price - discountValue);

                    tbody.append(`
                <tr data-id="${id}">
                    <td>${i + 1}</td>
                    <td>${name}</td>
                    <td>${price.toFixed(2)}</td>
                    <td>${finalPrice.toFixed(2)}</td>
                    <td>${extraDays}</td>
                    <td>${stopDays}</td>
                    <td>${stopTimes}</td>
                    <td><button type="button" class="btn btn-danger btn-sm removeService"><i class="fas fa-trash"></i></button></td>
                </tr>
            `);

                    hiddenBox.append(`
                <input type="hidden" name="items[${i}][service_id]" value="${id}">
                <input type="hidden" name="items[${i}][price]" value="${price.toFixed(2)}">
                <input type="hidden" name="items[${i}][final_price]" value="${finalPrice.toFixed(2)}">
                <input type="hidden" name="items[${i}][extra_days]" value="${extraDays}">
                <input type="hidden" name="items[${i}][stop_days]" value="${stopDays}">
                <input type="hidden" name="items[${i}][stop_times]" value="${stopTimes}">
            `);
                });
            });

            $(document).on('click', '.removeService', function() {
                const id = $(this).closest('tr').data('id');
                $(this).closest('tr').remove();
                $('#itemsHidden input[value="' + id + '"]').remove();
            });

            // ======== 🔹 التحقق النهائي قبل الحفظ ========
            $('form').on('submit', function(e) {
                const scope = $('.scope-check:checked').val();
                const customerId = $('#target_customer_id').val();
                const itemsCount = $('#itemsHidden input[name^="items"]').length;
                const startDate = $('#start_g').val();
                const endDate = $('#end_g').val();

                if (!scope) return e.preventDefault(), alert('اختر الفئة المستهدفة أولاً.');
                if (scope === 'customers' && !customerId)
                    return e.preventDefault(), alert('اختر عميل واحد قبل الحفظ.');
                if (itemsCount === 0)
                    return e.preventDefault(), alert('أضف خدمة واحدة على الأقل.');
                if (!startDate || !endDate)
                    return e.preventDefault(), alert('أدخل تاريخ البداية والنهاية.');
                if (moment(endDate).isBefore(moment(startDate)))
                    return e.preventDefault(), alert('❌ تاريخ النهاية لا يمكن أن يسبق البداية.');
            });
        });


        
    </script>
@endsection
