@extends('layouts.master')
@section('title', 'العروض')

@section('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <style>
        .badge-status {
            min-width: 64px
        }
    </style>
@endsection

@section('content')
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h5 class="mb-0">قائمة العروض</h5>
        <a href="{{ route('offers.create') }}" class="btn btn-primary"><i class="fas fa-plus me-1"></i> عرض جديد</a>
    </div>

    <div class="card p-3 mb-3">
        <div class="row g-2">
            <div class="col-md-3">
                <label class="form-label">بحث بالاسم</label>
                <input type="text" id="f_name" class="form-control" placeholder="..." />
            </div>
            <div class="col-md-3">
                <label class="form-label">النطاق</label>
                {{-- resources/views/admin/offers/index.blade.php --}}
                <select id="f_scope" class="form-select">
                    <option value="">الكل</option> {{-- كانت allx --}}
                    <option value="all">جميع الأعضاء/العملاء</option>
                    <option value="members">الأعضاء</option>
                    <option value="customers">العملاء</option>
                    <option value="coupons">كوبونات</option>
                </select>

            </div>
            <div class="col-md-2">
                <label class="form-label">الحالة</label>
                <select id="f_active" class="form-select">
                    <option value="">الكل</option>
                    <option value="1">نشط</option>
                    <option value="0">مغلق</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">من</label>
                <input type="date" id="f_from" class="form-control">
            </div>
            <div class="col-md-2">
                <label class="form-label">إلى</label>
                <input type="date" id="f_to" class="form-control">
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table id="offers-table" class="table table-striped align-middle w-100 text-center">
            <thead>
                <tr>
                    <th>#</th>
                    <th>رقم العرض</th>
                    <th>الاسم</th>
                    <th>النطاق</th>
                    <th>الفترة</th>
                    <th>خصم عام</th>

                    <th>الحالة</th>
                    <th></th>
                </tr>
            </thead>
        </table>
    </div>
@endsection

@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        const table = $('#offers-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: {
                url: "{{ route('offers.index') }}",
                data: function(d) {
                    d.name = $('#f_name').val();
                    d.scope = $('#f_scope').val();
                    d.active = $('#f_active').val();
                    d.from = $('#f_from').val();
                    d.to = $('#f_to').val();
                }
            },
            order: [
                [1, 'desc']
            ],
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'offer_no',
                    name: 'offer_no'
                },
                {
                    data: 'translated_name',
                    name: 'translated_name'
                },
                {
                    data: 'scope_badge',
                    name: 'scope',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'date_range',
                    name: 'date_range'
                },
                {
                    data: 'discount_summary',
                    name: 'discount_summary'
                },
                {
                    data: 'status_badge',
                    name: 'status_badge',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ],
        });

        $('#f_name,#f_scope,#f_active,#f_from,#f_to').on('change keyup', () => table.ajax.reload());


        $(document).on('click', '.btnToggleActive', function(e) {
            e.preventDefault();
            const url = $(this).data('url');
            const id = $(this).data('id');
            const btn = $(this);

            Swal.fire({
                title: 'تأكيد الإجراء',
                text: 'هل تريد بالتأكيد تغيير حالة هذا العرض؟',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'نعم، متابعة',
                cancelButtonText: 'إلغاء',
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: url,
                        type: 'PATCH',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(res) {
                            if (res.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: res.message,
                                    showConfirmButton: false,
                                    timer: 1200
                                });

                                // 🔄 إعادة تحميل الجدول بالكامل بدون كاش
                                const dt = $('#offers-table').DataTable();
                                dt.ajax.reload(null, false); // false => يفضل نفس الصفحة
                            } else {
                                Swal.fire('خطأ!', 'تعذر تغيير الحالة.', 'error');
                            }
                        },
                        error: function() {
                            Swal.fire('خطأ!', 'حدث خطأ أثناء الاتصال بالخادم.', 'error');
                        }
                    });

                }
            });
        });
    </script>


@endsection
