@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.cities') }}
@endsection

@section('btn')
    <div class="dropdown text-center py-3">
        <button class="btn btn-outline-warning dropdown-toggle" type="button" id="cityActionsDropdown" data-bs-toggle="dropdown"
            aria-expanded="false">
            <i class="fas fa-cog"></i>
             {{ __('dashboard.action') }}
        </button>
        <ul class="dropdown-menu dropdown-menu-end shadow-sm" aria-labelledby="cityActionsDropdown">
            <li>
                <a class="dropdown-item text-success d-flex align-items-center fw-bold" href="#" data-bs-toggle="modal"
                    data-bs-target="#cityAdd">
                    <i class="fas fa-plus-circle me-2"></i> {{ __('dashboard.addCity') }}
                </a>
            </li>
            <li>
                <a class="dropdown-item text-danger d-flex align-items-center fw-bold" href="#" data-bs-toggle="modal"
                    data-bs-target="#cityAddmulti">
                    <i class="fas fa-plus-circle me-2"></i> {{ __('dashboard.addCityfromCountry') }}
                </a>
            </li>
        </ul>
    </div>
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #cities-table th,
        #cities-table td {
            text-align: center;
            /* Center text horizontally */
            vertical-align: middle;
            /* Center text vertically */
        }

        /* Remove background from the DataTables processing overlay */
        .dataTables_processing {
            background: none !important;
            /* Removes background */
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="cities-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('dashboard.state') }}</th>
                            <th>{{ __('dashboard.country') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>

        </div>
    </div>


    <!-- city Add -->
    <div class="modal fade" id="cityAdd" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addCity') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>

                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('cities.store') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="cityName_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="cityName_ar" type="text" required="" name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="cityName_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="cityName_en" type="text" required="" name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="form-label" for="stateSelect">{{ __('dashboard.states') }}</label>
                                <select class="form-select" id="stateSelect" required="" name="state_id">
                                    <option selected="" disabled="" value="">{{ __('dashboard.Choose..') }}
                                    </option>
                                    @foreach ($states as $state)
                                        <option value="{{ $state->id }}">{{ $state->name }}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>

                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- city Add from country and state -->
    <div class="modal fade" id="cityAddmulti" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addCityfromCountry') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>

                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('CityState') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">

                            <div class="col-12">
                                <label class="form-label" for="stateSelect">{{ __('dashboard.countries') }}</label>
                                <select id="country_id" class="form-select" required="">
                                    <option value="">{{ __('dashboard.Choose..') }}</option>
                                    @foreach ($countries as $country)
                                        <option value="{{ $country->id }}">
                                            {{ $country->getTranslation('name', app()->getLocale()) }}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>

                            </div>

                            <div class="col-12">
                                <label class="form-label" for="stateSelect">{{ __('dashboard.states') }}</label>
                                <select id="state_id" name="state_id" class="form-select" required="">


                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>

                            </div>


                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="cityName_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="cityName_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="cityName_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="cityName_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>


                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- City Edit -->

    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.ُeditCity') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="cityEdit" class=" needs-validation custom-input validation-forms" novalidate="">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <input type="hidden" id="city_id">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="name_ar" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="name_en" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="form-label" for="state_id">{{ __('dashboard.states') }}</label>
                                <select class="form-select" id="state_id" required="" name="country_id">
                                    @foreach ($states as $state)
                                        <option value="{{ $state->id }}">
                                            {{ $state->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.update') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var table = $('#cities-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('cities.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'state_name',
                        name: 'states.name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'country_name',
                        name: 'countries.name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            $(document).on('click', '.edit-btn', function() {
                let cityId = $(this).data('id');
                let nameAr = $(this).data('name_ar');
                let nameEn = $(this).data('name_en');
                let stateId = $(this).data('state_id');


                $('#city_id').val(cityId);
                $('#name_ar').val(nameAr);
                $('#name_en').val(nameEn);
                $('#state_id').val(stateId).trigger('change');
            });

            // Handle form submission for editing
            $('#cityEdit').on('submit', function(e) {
                e.preventDefault();

                let cityId = $('#city_id').val();
                let nameAr = $('#name_ar').val();
                let nameEn = $('#name_en').val();
                let stateId = $('#state_id').val(); // Get selected country ID

                $.ajax({
                    url: "cities/" + cityId,
                    type: "PUT",
                    data: {
                        _token: "{{ csrf_token() }}",
                        name: {
                            ar: nameAr,
                            en: nameEn
                        },
                        state_id: stateId // Send country ID in request
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message); // Show Toastr success message
                        } else {
                            toastr.error(
                                "{{ __('dashboard.update_failed') }}"); // Show error message
                        }
                        $('#editModal').modal('hide'); // Close modal after success
                        $('#cities-table').DataTable().ajax.reload(); // Reload DataTable
                    },
                    error: function(xhr) {
                        toastr.error("{{ __('dashboard.update_failed') }}"); // Show error
                    }
                });
            });


            $('#country_id').change(function() {
                var countryId = $(this).val();
                $('#state_id').html('<option value="">{{ __('dashboard.loading') }}</option>');

                if (countryId) {
                    $.ajax({
                        url: "/get-states/" + countryId,
                        type: "GET",
                        success: function(states) {
                            $('#state_id').html(
                                '<option value="">{{ __('dashboard.Choose..') }}</option>'
                            );
                            $.each(states, function(key, state) {
                                $('#state_id').append('<option value="' + state.id +
                                    '">' + state.name + '</option>');
                            });
                        },
                        error: function() {
                            $('#state_id').html(
                                '<option value="">{{ __('dashboard.error_loading') }}</option>'
                            );
                        }
                    });
                } else {
                    $('#state_id').html('<option value="">{{ __('dashboard.Choose..') }}</option>');
                }
            });



        });
    </script>
@endsection
