@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.countries') }}
@endsection

@section('btn')
    <button class="btn btn-outline-success" type="button" data-bs-toggle="modal" data-bs-target="#countryAdd"><i
            class="fas fa-plus-circle mx-2"></i> {{ __('dashboard.addCountry') }} </button>
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #countries-table th,
        #countries-table td {
            text-align: center;
            /* Center text horizontally */
            vertical-align: middle;
            /* Center text vertically */
        }

        /* Remove background from the DataTables processing overlay */
        .dataTables_processing {
            background: none !important;
            /* Removes background */
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="countries-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>


    <!-- Country Add -->
    <div class="modal fade" id="countryAdd" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addCountry') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('countries.store') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="countryName_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="countryName_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="countryName_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="countryName_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Country Edit -->

    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.ُeditCountry') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="editForm" class=" needs-validation custom-input validation-forms" novalidate="">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <input type="hidden" id="country_id">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="name_ar" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="name_en" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.update') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var table = $('#countries-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('countries.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            $(document).on('click', '.edit-btn', function() {
                let countryId = $(this).data('id');
                let nameAr = $(this).data('name_ar');
                let nameEn = $(this).data('name_en');

                $('#country_id').val(countryId);
                $('#name_ar').val(nameAr);
                $('#name_en').val(nameEn);
            });

            // Handle form submission for editing
            $('#editForm').on('submit', function(e) {
                e.preventDefault();
                let countryId = $('#country_id').val();
                let nameAr = $('#name_ar').val();
                let nameEn = $('#name_en').val();

                $.ajax({
                    url: "countries/" + countryId,
                    type: "PUT",
                    data: {
                        _token: "{{ csrf_token() }}",
                        name: {
                            ar: nameAr,
                            en: nameEn
                        }
                    },
                    success: function(response) {
                        if (response.success) {

                            toastr.success(response.message); // Show Toastr success message
                        } else {
                            toastr.error(
                                "{{ __('dashboard.update_failed') }}"); // Fallback message
                        }
                        $('#editModal').modal('hide'); // Close modal after success
                        $('#countries-table').DataTable().ajax.reload(); // Reload DataTable
                    },
                    error: function(xhr) {
                        toastr.error("{{ __('dashboard.update_failed') }}");
                    }
                });
            });


        });
    </script>
@endsection
