@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.states') }}
@endsection

@section('btn')
    <button class="btn btn-outline-success" type="button" data-bs-toggle="modal" data-bs-target="#countryAdd"><i
            class="fas fa-plus-circle mx-2"></i> {{ __('dashboard.addState') }} </button>
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #states-table th,
        #states-table td {
            text-align: center;
            /* Center text horizontally */
            vertical-align: middle;
            /* Center text vertically */
        }

        /* Remove background from the DataTables processing overlay */
        .dataTables_processing {
            background: none !important;
            /* Removes background */
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="states-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('dashboard.country') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>


    <!-- Country Add -->
    <div class="modal fade" id="countryAdd" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addState') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('states.store') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="countryName_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="countryName_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="countryName_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="countryName_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="form-label" for="stateSelect">{{ __('dashboard.countries') }}</label>
                                <select class="form-select" id="stateSelect" required="" name="country_id">
                                    <option selected="" disabled="" value="">{{ __('dashboard.Choose..') }}
                                    </option>
                                    @foreach ($countries as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>

                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Country Edit -->

    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.ُeditState') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="stateEdit" class=" needs-validation custom-input validation-forms" novalidate="">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <input type="hidden" id="state_id">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="name_ar" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="name_en" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="form-label" for="country_id">{{ __('dashboard.countries') }}</label>
                                <select class="form-select" id="country_id" required="" name="country_id">
                                    @foreach ($countries as $country)
                                        <option value="{{ $country->id }}">
                                            {{ $country->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.update') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var table = $('#states-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('states.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'country_name',
                        name: 'countries.name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            $(document).on('click', '.edit-btn', function() {
                let stateId = $(this).data('id');
                let nameAr = $(this).data('name_ar');
                let nameEn = $(this).data('name_en');
                let countryId = $(this).data('country_id');


                $('#state_id').val(stateId);
                $('#name_ar').val(nameAr);
                $('#name_en').val(nameEn);
                $('#country_id').val(countryId).trigger('change');
            });

            // Handle form submission for editing
            $('#stateEdit').on('submit', function(e) {
                e.preventDefault();

                let stateId = $('#state_id').val();
                let nameAr = $('#name_ar').val();
                let nameEn = $('#name_en').val();
                let countryId = $('#country_id').val(); // Get selected country ID

                $.ajax({
                    url: "states/" + stateId,
                    type: "PUT",
                    data: {
                        _token: "{{ csrf_token() }}",
                        name: {
                            ar: nameAr,
                            en: nameEn
                        },
                        country_id: countryId // Send country ID in request
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message); // Show Toastr success message
                        } else {
                            toastr.error(
                                "{{ __('dashboard.update_failed') }}"); // Show error message
                        }
                        $('#editModal').modal('hide'); // Close modal after success
                        $('#states-table').DataTable().ajax.reload(); // Reload DataTable
                    },
                    error: function(xhr) {
                        toastr.error("{{ __('dashboard.update_failed') }}"); // Show error
                    }
                });
            });



        });
    </script>
@endsection
