@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.branch_types') }}
@endsection

@section('btn')
    <button class="btn btn-outline-success" type="button" data-bs-toggle="modal" data-bs-target="#typeAdd">
        <i class="fas fa-plus-circle mx-2"></i> {{ __('dashboard.addType') }}
    </button>
@endsection

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        #types-table th,
        #types-table td {
            text-align: center;
            vertical-align: middle;
        }

        .dataTables_processing {
            background: none !important;
            color: teal !important;
            font-weight: bold;
        }

        /* مهم: خلى أزرار الأكشن جنب بعض */
        #types-table td .btn {
            width: auto !important;
            padding: .25rem .5rem !important;
        }
    </style>
@endsection

@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="types-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    {{-- Add Modal --}}
    <div class="modal fade" id="typeAdd" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5">{{ __('dashboard.addType') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="typeCreateForm" class="needs-validation" novalidate>
                    @csrf
                    <div class="modal-body">
                        <div class="row g-3 align-items-end">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" type="text" name="name[ar]" required>
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" type="text" name="name[en]" required>
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">
                            <i class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}
                        </button>
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-save mx-2"></i>{{ __('dashboard.save') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Show Modal --}}
    <div class="modal fade" id="showTypeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5">{{ __('dashboard.showType') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <dl class="row">
                        <dt class="col-sm-3">ID</dt>
                        <dd class="col-sm-9" id="show_id">—</dd>
                        <dt class="col-sm-3">{{ __('dashboard.name_ar') }}</dt>
                        <dd class="col-sm-9" id="show_name_ar">—</dd>
                        <dt class="col-sm-3">{{ __('dashboard.name_en') }}</dt>
                        <dd class="col-sm-9" id="show_name_en">—</dd>
                    </dl>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">{{ __('dashboard.close') }}</button>
                </div>
            </div>
        </div>
    </div>

    {{-- Edit Modal --}}
    <div class="modal fade" id="editTypeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5">{{ __('dashboard.editType') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
                </div>
                <form id="typeEditForm" class="needs-validation" novalidate>
                    @csrf
                    <input type="hidden" id="edit_id">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label class="form-label">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="edit_name_ar" type="text" required>
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>
                            <div class="col-12 mb-3">
                                <label class="form-label">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="edit_name_en" type="text" required>
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">
                            <i class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}
                        </button>
                        <button class="btn btn-primary" type="submit">
                            <i class="fas a-save mx-2"></i>{{ __('dashboard.update') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(function() {
            // تهيئة Tooltips
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(el => new bootstrap.Tooltip(el));

            // DataTable
            const table = $('#types-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('branch-types.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            // Create
            $('#typeCreateForm').on('submit', function(e) {
                e.preventDefault();
                $.ajax({
                    url: "{{ route('branch-types.store') }}",
                    type: "POST",
                    data: $(this).serialize(),
                    success: function(res) {
                        toastr.success(res.message);
                        $('#typeCreateForm')[0].reset();
                        $('#typeAdd').modal('hide');
                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        const msg = xhr.responseJSON?.message ||
                            "{{ __('dashboard.create_failed') }}";
                        toastr.error(msg);
                    }
                });
            });

            // Show
            $(document).on('click', '.show-btn', function() {
                const id = $(this).data('id');
                $.get("{{ url('branch-types') }}/" + id, function(res) {
                    $('#show_id').text(res.id);
                    $('#show_name_ar').text(res.name?.ar ?? '—');
                    $('#show_name_en').text(res.name?.en ?? '—');
                    $('#showTypeModal').modal('show');
                });
            });

            // Edit (open modal)
            $(document).on('click', '.edit-btn', function() {
                $('#edit_id').val($(this).data('id'));
                $('#edit_name_ar').val($(this).data('name_ar'));
                $('#edit_name_en').val($(this).data('name_en'));
                $('#editTypeModal').modal('show');
            });

            // Edit (submit)
            $('#typeEditForm').on('submit', function(e) {
                e.preventDefault();
                const id = $('#edit_id').val();
                const payload = {
                    _token: "{{ csrf_token() }}",
                    _method: "PUT",
                    'name[ar]': $('#edit_name_ar').val(),
                    'name[en]': $('#edit_name_en').val(),
                };

                $.ajax({
                    url: "{{ url('branch-types') }}/" + id,
                    type: "POST",
                    data: payload,
                    success: function(res) {
                        toastr.success(res.message);
                        $('#editTypeModal').modal('hide');
                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        const msg = xhr.responseJSON?.message ||
                            "{{ __('dashboard.update_failed') }}";
                        toastr.error(msg);
                    }
                });
            });
        });
    </script>
@endsection
