@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.students') }}
@endsection

@section('btn')
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #cart-table th,
        #cart-table td {
            text-align: center;
            /* Center text horizontally */
            vertical-align: middle;
            /* Center text vertically */
        }

        /* Remove background from the DataTables processing overlay */
        .dataTables_processing {
            background: none !important;
            /* Removes background */
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>
@endsection
@section('content')
    <div class="container">
        <table class="table table-bordered table-striped" id="cart-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الطالب</th>
                    <th>المادة</th>
                    <th>الحالة</th>
                    <th>تاريخ الإضافة</th>
                </tr>
            </thead>
        </table>
    </div>
@endsection

@section('js')
    <script>
        $(function() {
            $('#cart-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('admin.cart.data') }}',
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'student',
                        name: 'student.name'
                    },
                    {
                        data: 'subject',
                        name: 'subject.name'
                    },
                    {
                        data: 'is_paid',
                        name: 'is_paid',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    }
                ]
            });
        });
    </script>
@endsection
