@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.Subjects') }}
@endsection

@section('btn')
    <div class="dropdown text-center py-3">
        <button class="btn btn-outline-warning dropdown-toggle" type="button" id="cityActionsDropdown"
            data-bs-toggle="dropdown" aria-expanded="false">
            <i class="fas fa-cog"></i>
            {{ __('dashboard.action') }}
        </button>
        <ul class="dropdown-menu dropdown-menu-end shadow-sm" aria-labelledby="cityActionsDropdown">
            <li>
                <a class="dropdown-item text-success d-flex align-items-center fw-bold" href="#" data-bs-toggle="modal"
                    data-bs-target="#addSubject">
                    <i class="fas fa-plus-circle me-2"></i> {{ __('dashboard.addSub') }}
                </a>
            </li>

        </ul>
    </div>
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #subjects-table th,
        #subjects-table td {
            text-align: center;
            /* Center text horizontally */
            vertical-align: middle;
            /* Center text vertically */
        }

        /* Remove background from the DataTables processing overlay */
        .dataTables_processing {
            background: none !important;
            /* Removes background */
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="subjects-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('dashboard.price') }}</th>
                            <th>{{ __('dashboard.grade') }}</th>
                            <th>{{ __('dashboard.classroom') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>

        </div>
    </div>


    <!-- add Subject -->
    <div class="modal fade" id="addSubject" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addSub') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>

                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('subjects.store') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="stateSelect">{{ __('dashboard.grades') }}</label>
                                <select id="grade_id" class="form-select" required="" name="grade_id">
                                    <option value="">{{ __('dashboard.Choose..') }}</option>
                                    @foreach ($grades as $grade)
                                        <option value="{{ $grade->id }}">
                                            {{ $grade->getTranslation('name', app()->getLocale()) }}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>

                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="stateSelect">{{ __('dashboard.classroom') }}</label>
                                <select id="class_id" name="classroom_id" class="form-select" required="">


                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>

                            </div>


                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="subject_ar" type="text" required="" name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="subject_en" type="text" required="" name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>


                            <div class="col-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-2">
                              <label class="col-sm-12 col-form-label"
                                  for="price">{{ __('dashboard.price') }}</label>
                              <input class="form-control" id="price" type="number" required="" name="price">
                              <div class="invalid-feedback">{{ __('dashboard.price_required') }}</div>
                          </div>


                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Subject Edit Modal -->
    <div class="modal fade" id="editModalSub" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.editSub') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="subjectEditForm1" class="needs-validation custom-input validation-forms" novalidate="">
                    @csrf
                    <input type="hidden" id="subject_id">

                    <div class="modal-body dark-modal">
                        <div class="row">
                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="name_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="name_ar" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="name_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="name_en" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="Edit_grade_id">{{ __('dashboard.grade') }}</label>
                                <select class="form-select" id="Edit_grade_id" required="" name="grade_id">
                                    @foreach ($grades as $grade)
                                        <option value="{{ $grade->id }}">
                                            {{ $grade->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="classroom_id">{{ __('dashboard.classroom') }}</label>
                                <select class="form-select" id="classroom_id" required="" name="classroom_id">
                                    @foreach ($grades as $grade)
                                        @foreach ($grade->classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">
                                                {{ $classroom->getTranslation('name', app()->getLocale()) }}
                                            </option>
                                        @endforeach
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-2">
                              <label class="col-sm-12 col-form-label"
                                  for="price">{{ __('dashboard.price') }}</label>
                              <input class="form-control" id="Edit_price" type="number" required="" name="price">
                              <div class="invalid-feedback">{{ __('dashboard.price_required') }}</div>
                          </div>

                        </div>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">
                            <i class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}
                        </button>
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-save mx-2"></i>{{ __('dashboard.update') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var table = $('#subjects-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('subjects.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'price',
                        name: 'price',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'grade_name',
                        name: 'grades.name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'class_name',
                        name: 'classrooms.name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            $('#grade_id').on('change', function() {
                let gradeId = $(this).val();
                if (gradeId) {
                    $.ajax({
                        url: "{{ route('subjects.getClasses', '') }}/" + gradeId,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#class_id').empty().append(
                                '<option value="">{{ __('dashboard.Choose..') }}</option>');
                            $.each(data, function(key, value) {
                                $('#class_id').append('<option value="' + value.id +
                                    '">' + value.name + '</option>');
                            });
                        },
                        error: function(xhr) {
                            if (xhr.status === 404) {
                                $('#class_id').empty().append(
                                    '<option value="">{{ __('dashboard.no_classes_found') }}</option>'
                                );
                            }
                        }
                    });
                } else {
                    $('#class_id').empty().append(
                        '<option value="">{{ __('dashboard.Choose..') }}</option>');
                }
            });


            $('#Edit_grade_id').on('change', function() {
                let grade_id = $(this).val();
                if (grade_id) {
                    $.ajax({
                        url: "{{ route('subjects.getClasses', '') }}/" + grade_id,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#classroom_id').empty().append(
                                '<option value="">{{ __('dashboard.Choose..') }}</option>');
                            $.each(data, function(key, value) {
                                $('#classroom_id').append('<option value="' + value.id +
                                    '">' + value.name + '</option>');
                            });
                        },
                        error: function(xhr) {
                            if (xhr.status === 404) {
                                $('#classroom_id').empty().append(
                                    '<option value="">{{ __('dashboard.no_classes_found') }}</option>'
                                );
                            }
                        }
                    });
                } else {
                    $('#classroom_id').empty().append(
                        '<option value="">{{ __('dashboard.Choose..') }}</option>');
                }
            });

            $(document).on('click', '.edit-btn', function() {
                let subjectId = $(this).data('id');


                $('#subject_id').val(subjectId);
                $('#name_ar').val($(this).data('name_ar'));
                $('#name_en').val($(this).data('name_en'));
                $('#Edit_grade_id').val($(this).data('grade_id'));
                $('#classroom_id').val($(this).data('class_id'));
                $('#Edit_price').val($(this).data('price'));


                $('#editModalSub').modal('show');
            });


            $('#subjectEditForm1').submit(function(e) {
                e.preventDefault();

                let subjectId = $('#subject_id').val();
                let formData = {
                    name: {
                        ar: $('#name_ar').val(),
                        en: $('#name_en').val()
                    },
                    grade_id: $('#Edit_grade_id').val(),
                    classroom_id: $('#classroom_id').val(),
                    price:$('#Edit_price').val(),
                    _token: $('input[name=_token]').val()
                };

                $.ajax({
                    url: `/subjects_update/${subjectId}`,
                    type: 'PUT',
                    data: formData,
                    success: function(response) {
                        $('#editModalSub').modal('hide');
                        toastr.success(response.message);
                        $('#subjects-table').DataTable().ajax.reload();
                    },
                    error: function(error) {
                        toastr.error(
                            "{{ __('flasher::messages.error') }}");
                    }
                });
            });



        });
    </script>
@endsection
