@extends('layouts.master') <!-- Extend -->

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.Subject') }}
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/flatpickr/flatpickr.min.css') }}">


    <style>
        #exams-table th,
        #exams-table td,
        #group-tbl th,
        #group-tbl td {
            text-align: center;
            vertical-align: middle;
        }

        .dataTables_processing {
            background: none !important;
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>


    </style>
@endsection

@section('content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="email-wrap bookmark-wrap">
            <div class="row">
                <div class="col-xl-3 box-col-6">
                    <div class="md-sidebar"><a class="btn btn-primary md-sidebar-toggle" href="javascript:void(0)"><i
                                class="fas fa-cog mx-2 "></i> {{ __('dashboard.actions') }}</a>
                        <div class="md-sidebar-aside job-left-aside custom-scrollbar">
                            <div class="email-left-aside">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="email-app-sidebar left-bookmark">
                                            <div class="d-flex flex-wrap">
                                                <div class="media-size-email"></div>
                                                <div class="flex-grow-1">
                                                    <h4 class="f-w-600 mb-2">{{ $subject->name }}</h4>
                                                    <p>{{ $subject->classroom->name }} - {{ $subject->grade->name }}</p>
                                                    <small>{{ $subject->price }}</small>

                                                </div>
                                            </div>
                                            <ul class="nav main-menu" role="tablist">
                                                <li class="nav-item">
                                                    <button class="button-primary btn-block btn-mail w-100" type="button"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#editModal{{ $subject->id }}"><i
                                                            class="me-2 fas fa-edit"></i>{{ __('dashboard.editSub') }}</button>
                                                </li>
                                                <li class="nav-item"><span class="main-title">
                                                        <i class="fas fa-cog"></i> {{ __('dashboard.actions') }}</span>
                                                </li>
                                                <li><a class="active" id="subject-semster-tab" data-bs-toggle="pill"
                                                        href="#subject-semster" role="tab"
                                                        aria-controls="subject-semster" aria-selected="true"><span
                                                            class="title">
                                                            <i class="fas fa-graduation-cap"></i>
                                                            {{ __('dashboard.semesters') }}</span></a></li>
                                                <li><a id="units-tab" data-bs-toggle="pill" href="#units" role="tab"
                                                        aria-controls="units" aria-selected="false"><span class="title">
                                                            <i class="fas fa-book-open"></i>
                                                            {{ __('dashboard.units') }}</span></a></li>
                                                <li><a id="lessons-tab" data-bs-toggle="pill" href="#lessons" role="tab"
                                                        aria-controls="lessons" aria-selected="false"><span class="title">
                                                            <i class="fas fa-book-open-reader"></i>
                                                            {{ __('dashboard.lesson') }}</span></a></li>

                                                <li>
                                                    <hr />
                                                </li>

                                                <li><span class="main-title"><i class="fas fa-cog"></i>
                                                        {{ __('dashboard.exams_action') }} <span class="pull-right"><a
                                                                href="#" data-bs-toggle="modal"
                                                                data-bs-target="#createtag"><i
                                                                    data-feather="plus-circle"></i></a></span></span></li>
                                                <li><a id="exams-tab" data-bs-toggle="pill" href="#exams" role="tab"
                                                        aria-controls="exams" aria-selected="false"><span class="title">
                                                            <i class="fas fa-clipboard"></i>
                                                            {{ __('dashboard.exams') }}</span></a></li>
                                                <li><a id="qui_group-tab" data-bs-toggle="pill" href="#qui_group"
                                                        role="tab" aria-controls="qui_group" aria-selected="false"><span
                                                            class="title">
                                                            <i class="fas fa-circle-question"></i>
                                                            {{ __('dashboard.qui_group') }}</span></a></li>
                                                <li><a id="questions-tab" data-bs-toggle="pill" href="#questions"
                                                        role="tab" aria-controls="questions-tab"
                                                        aria-selected="false"><span class="title">
                                                            <i class="fas fa-question"></i>
                                                            {{ __('dashboard.questions') }}</span></a></li>

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-9 col-md-12 box-col-12">
                    <div class="email-right-aside bookmark-tabcontent">
                        <div class="card email-body radius-left">
                            <div class="ps-0">
                                <div class="tab-content">
                                    <div class="tab-pane fade active show" id="subject-semster" role="tabpanel"
                                        aria-labelledby="subject-semster-tab">
                                        <div class="card mb-0">
                                            <div class="card-header d-flex mb-0 card-no-border">
                                                <h3 class="mb-0">{{ __('dashboard.semesters') }} </h3>
                                                <ul>
                                                    <li><a class="grid-bookmark-view" href="javascript:void(0)"
                                                            data-bs-toggle="modal" data-bs-target="#addSemester"><i
                                                                class="fas fa-plus-circle h2 text-primary"></i></a></li>
                                                </ul>
                                            </div>
                                            <div class="card-body pb-0">
                                                <div class="row">
                                                    @foreach ($subject->semesters as $semester)
                                                        <a href="" data-bs-toggle="modal"
                                                            data-bs-target="#edit-semester{{ $semester->id }}"
                                                            class="col-xl col-lg col-md col-sm-12 col-12 text-center">
                                                            <div>
                                                                <div
                                                                    class="card card-with-border bookmark-card overflow-hidden">
                                                                    <div class="card-header">
                                                                        <i
                                                                            class="fas fa-graduation-cap mb-3 text-primary"></i>
                                                                        <div class="card-title">
                                                                            {{ $semester->name }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="card-body text-center badge">
                                                                        <div class="start my-2">
                                                                            {{ __('dashboard.start_date') }} :
                                                                            {{ $semester->start_date }}
                                                                        </div>


                                                                        <div class="end my-2">

                                                                            {{ __('dashboard.end_date') }} :
                                                                            {{ $semester->end_date }}
                                                                        </div>

                                                                    </div>
                                                                    <div class="card-footer badge badge-danger">
                                                                        {{ $semester->created_at->format('Y-m-d H:i') }}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </a>

                                                        <!-- Modal Edit Semester -->
                                                        <div class="modal fade" id="edit-semester{{ $semester->id }}"
                                                            tabindex="-1" aria-labelledby="edit-bookmarkLabel"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="edit-bookmarkLabel">
                                                                            {{ __('dashboard.editsemester') }}</h5>
                                                                        <button type="button" class="btn-close"
                                                                            data-bs-dismiss="modal"
                                                                            aria-label="Close"></button>
                                                                    </div>
                                                                    <form
                                                                        class=" needs-validation custom-input validation-forms"
                                                                        novalidate=""
                                                                        action="{{ route('semester.edit', $semester->id) }}"
                                                                        method="POST">
                                                                        @method('PUT')
                                                                        @csrf
                                                                        <div class="modal-body">
                                                                            <div class="row">
                                                                                <input type="hidden" name="subject_id"
                                                                                    value="{{ $subject->id }}">
                                                                                <div class="col-12 mb-2">
                                                                                    <label class="col-sm-12 col-form-label"
                                                                                        for="subject_ar">{{ __('dashboard.name_ar') }}</label>
                                                                                    <input class="form-control"
                                                                                        id="subject_ar" type="text"
                                                                                        required="" name="name_ar"
                                                                                        value="{{ $semester->getTranslation('name', 'ar') }}">
                                                                                    <div class="invalid-feedback">
                                                                                        {{ __('dashboard.name_ar_required') }}
                                                                                    </div>
                                                                                </div>

                                                                                <div class="col-12 mb-2">
                                                                                    <label class="col-sm-12 col-form-label"
                                                                                        for="subject_en">{{ __('dashboard.name_en') }}</label>
                                                                                    <input class="form-control"
                                                                                        id="subject_en" type="text"
                                                                                        required="" name="name_en"
                                                                                        value="{{ $semester->getTranslation('name', 'en') }}">
                                                                                    <div class="invalid-feedback">
                                                                                        {{ __('dashboard.name_en_required') }}
                                                                                    </div>
                                                                                </div>

                                                                                <label
                                                                                    class="col-xxl-3 box-col-12 text-start">{{ __('dashboard.start_date') }}</label>
                                                                                <div class="col-xxl-9 mb-3">
                                                                                    <div
                                                                                        class="input-group flatpicker-calender">
                                                                                        <input class="form-control"
                                                                                            id="start_date" type="date"
                                                                                            name="start_date"
                                                                                            value="{{ $semester->start_date }}">
                                                                                    </div>
                                                                                </div>

                                                                                <label
                                                                                    class="col-xxl-3 box-col-12 text-start">{{ __('dashboard.end_date') }}</label>
                                                                                <div class="col-xxl-9">
                                                                                    <div
                                                                                        class="input-group flatpicker-calender">
                                                                                        <input class="form-control"
                                                                                            id="end_start" type="date"
                                                                                            name="end_date"
                                                                                            value="{{ $semester->end_date }}">
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button class="btn btn-secondary"
                                                                                type="button" data-bs-dismiss="modal"> <i
                                                                                    class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                                                                            <button class="btn btn-primary"
                                                                                type="submit"> <i
                                                                                    class="fas fa-save mx-2"></i>{{ __('dashboard.save') }}
                                                                            </button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="fade tab-pane" id="units" role="tabpanel"
                                        aria-labelledby="units-tab">
                                        <div class="card mb-0">
                                            <div class="card-header d-flex mb-0 card-no-border">
                                                <h3 class="mb-0">{{ __('dashboard.units') }}</h3>
                                                <ul>
                                                    <li><a class="grid-bookmark-view" href="javascript:void(0)"
                                                            data-bs-toggle="modal" data-bs-target="#addUnit"><i
                                                                class="fas fa-plus-circle h2 text-primary"></i></a></li>
                                                </ul>
                                            </div>
                                            <div class="card-body">
                                                <div class="details-bookmark ">

                                                    <div class="row" id="favouriteData">
                                                        @foreach ($groupedUnits as $semesterId => $semesterData)
                                                            <!-- Semester Header -->
                                                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-4">
                                                                <h4 class="text-center text-uppercase text-primary">
                                                                    {{ $semesterData['name'] }}
                                                                </h4>
                                                                <hr class="my-2">
                                                            </div>

                                                            <!-- Link to Show All Units for the Semester -->
                                                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-4">
                                                                <h4 class="text-center text-uppercase">
                                                                    @if ($semesterData['units']->count() >= 1)
                                                                        <a href="javascript:void(0)" class="text-success"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-target="#show-units{{ $semesterId }}">
                                                                            <i
                                                                                class="fas fa-eye mx-2"></i>{{ __('dashboard.showAll') }}
                                                                        </a>
                                                                    @else
                                                                        <a class="text-danger">
                                                                            <i
                                                                                class="fas fa-ban mx-2"></i>{{ __('dashboard.Semester Not Have Units') }}
                                                                        </a>
                                                                    @endif
                                                                </h4>
                                                                <hr class="my-2">
                                                            </div>

                                                            <div class="row">
                                                                <!-- Loop through units under each semester -->
                                                                @foreach ($semesterData['units']->take(3) as $unit)
                                                                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 mb-4">
                                                                        <!-- Unit Card -->
                                                                        <div class="card shadow rounded-3 text-center">
                                                                            <a href="" data-bs-toggle="modal"
                                                                                data-bs-target="#edit-unit{{ $unit->id }}">
                                                                                <div
                                                                                    class="card-header bg-primary text-white d-flex align-items-center">
                                                                                    <i
                                                                                        class="fas fa-book-open fa-2x me-3 "></i>
                                                                                    <div class="card-title">
                                                                                        <h5>{{ $unit->name }}</h5>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="card-body text-center"
                                                                                    style="height: 100px; max-height: 100px;">
                                                                                    <p>{{ $unit->info ?? '---' }}</p>
                                                                                </div>
                                                                                <div
                                                                                    class="card-footer text-center badge badge-success">
                                                                                    {{ $unit->created_at->format('Y-m-d H:i') }}
                                                                                </div>
                                                                            </a>
                                                                        </div>

                                                                        <!-- Modal for Editing Unit -->
                                                                        <div class="modal fade"
                                                                            id="edit-unit{{ $unit->id }}"
                                                                            tabindex="-1"
                                                                            aria-labelledby="edit-unitLabel{{ $unit->id }}"
                                                                            aria-hidden="true">
                                                                            <div class="modal-dialog modal-lg">
                                                                                <div class="modal-content">
                                                                                    <div class="modal-header ">
                                                                                        <h5 class="modal-title"
                                                                                            id="edit-unitLabel{{ $unit->id }}">
                                                                                            {{ __('dashboard.editUnit') }}
                                                                                        </h5>
                                                                                        <button type="button"
                                                                                            class="btn-close"
                                                                                            data-bs-dismiss="modal"
                                                                                            aria-label="Close"></button>
                                                                                    </div>
                                                                                    <form
                                                                                        action="{{ route('units.update', $unit->id) }}"
                                                                                        method="POST"
                                                                                        class="needs-validation"
                                                                                        novalidate>
                                                                                        @method('PUT')
                                                                                        @csrf
                                                                                        <div class="modal-body">
                                                                                            <div class="row">
                                                                                                <input type="hidden"
                                                                                                    name="unit_id"
                                                                                                    value="{{ $unit->id }}">

                                                                                                <div class="col-12 mb-2">
                                                                                                    <label
                                                                                                        class="col-sm-12 col-form-label"
                                                                                                        for="semester">{{ __('dashboard.semester') }}</label>
                                                                                                    <select
                                                                                                        class="form-select"
                                                                                                        id="semester"
                                                                                                        required=""
                                                                                                        name="semester_id">

                                                                                                        @foreach ($subject->semesters as $semester)
                                                                                                            <option
                                                                                                                value="{{ $semester->id }}"
                                                                                                                @if ($semester->id == $unit->semester_id) selected @endif>
                                                                                                                {{ $semester->getTranslation('name', app()->getLocale()) }}
                                                                                                            </option>
                                                                                                        @endforeach
                                                                                                    </select>
                                                                                                    <div
                                                                                                        class="invalid-feedback">
                                                                                                        {{ __('dashboard.select_required') }}
                                                                                                    </div>
                                                                                                </div>

                                                                                                <!-- Name Fields -->
                                                                                                <div class="col-12 mb-3">
                                                                                                    <label
                                                                                                        class="col-sm-12 col-form-label"
                                                                                                        for="unit_name_ar">{{ __('dashboard.name_ar') }}</label>
                                                                                                    <input
                                                                                                        class="form-control"
                                                                                                        id="unit_name_ar"
                                                                                                        type="text"
                                                                                                        name="name_ar"
                                                                                                        value="{{ $unit->getTranslation('name', 'ar') }}"
                                                                                                        required>
                                                                                                    <div
                                                                                                        class="invalid-feedback">
                                                                                                        {{ __('dashboard.name_ar_required') }}
                                                                                                    </div>
                                                                                                </div>

                                                                                                <div class="col-12 mb-3">
                                                                                                    <label
                                                                                                        for="unit_name_en">{{ __('dashboard.name_en') }}</label>
                                                                                                    <input
                                                                                                        class="form-control"
                                                                                                        id="unit_name_en"
                                                                                                        type="text"
                                                                                                        name="name_en"
                                                                                                        value="{{ $unit->getTranslation('name', 'en') }}"
                                                                                                        required>
                                                                                                    <div
                                                                                                        class="invalid-feedback">
                                                                                                        {{ __('dashboard.name_en_required') }}
                                                                                                    </div>
                                                                                                </div>

                                                                                                <!-- Info Fields -->
                                                                                                <div class="col-12 mb-3">
                                                                                                    <label
                                                                                                        for="info_ar">{{ __('dashboard.info_ar') }}</label>
                                                                                                    <textarea name="info_ar" class="form-control" rows="3">{{ $unit->getTranslation('info', 'ar') }}</textarea>
                                                                                                </div>

                                                                                                <div class="col-12 mb-3">
                                                                                                    <label
                                                                                                        for="info_en">{{ __('dashboard.info_en') }}</label>
                                                                                                    <textarea name="info_en" class="form-control" rows="3">{{ $unit->getTranslation('info', 'en') }}</textarea>
                                                                                                </div>

                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="modal-footer">
                                                                                            <button type="button"
                                                                                                class="btn btn-secondary"
                                                                                                data-bs-dismiss="modal">{{ __('dashboard.close') }}</button>
                                                                                            <button type="submit"
                                                                                                class="btn btn-primary">{{ __('dashboard.save') }}</button>
                                                                                        </div>
                                                                                    </form>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                                <!-- Modal for Show All Units in a Semester -->
                                                                <div class="modal fade"
                                                                    id="show-units{{ $semesterId }}" tabindex="-1"
                                                                    aria-labelledby="show-unitsLabel{{ $semesterId }}"
                                                                    aria-hidden="true">
                                                                    <div class="modal-dialog modal-xl">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header ">
                                                                                <h5 class="modal-title"
                                                                                    id="show-unitsLabel{{ $semesterId }}">
                                                                                    {{ __('dashboard.unit_semester') }}
                                                                                </h5>
                                                                                <button type="button" class="btn-close"
                                                                                    data-bs-dismiss="modal"
                                                                                    aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body"
                                                                                style="height: 75vh; overflow:auto;">
                                                                                <div class="row">
                                                                                    <div class="col-12">

                                                                                    </div>
                                                                                    @foreach ($semesterData['units'] as $unit)
                                                                                        <div
                                                                                            class="col-12 col-xl-4 col-lg-4 col-md-6 col-sm-12 mb-4">
                                                                                            <div
                                                                                                class="card shadow rounded-3">
                                                                                                <div
                                                                                                    class="card-header d-flex align-items-center">
                                                                                                    <i
                                                                                                        class="fas fa-book-open fa-2x me-3 text-primary"></i>
                                                                                                    <div
                                                                                                        class="card-title">
                                                                                                        <h5>{{ $unit->name }}
                                                                                                        </h5>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div
                                                                                                    class="card-body text-center">
                                                                                                    <p>{{ $unit->info ?? 'No information available' }}
                                                                                                    </p>
                                                                                                </div>
                                                                                                <div
                                                                                                    class="card-footer text-center text-muted ">
                                                                                                    <small>{{ $unit->created_at->format('Y-m-d H:i') }}</small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button"
                                                                                    class="btn btn-secondary"
                                                                                    data-bs-dismiss="modal">{{ __('dashboard.close') }}</button>
                                                                                <a href="{{ route('units.show', ['semester_id' => $semesterId, 'subject_id' => $subject->id]) }}"
                                                                                    class="btn btn-primary">{{ __('dashboard.openUpdate') }}</a>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="fade tab-pane" id="lessons" role="tabpanel"
                                        aria-labelledby="lessons-tab">
                                        <div class="card mb-0">
                                            <div class="card-header d-flex mb-0 card-no-border">
                                                <h3 class="mb-0">{{ __('dashboard.lessons') }}</h3>
                                                <ul>
                                                    <li><a class="grid-bookmark-view" href="javascript:void(0)"
                                                            data-bs-toggle="modal" data-bs-target="#addLesson"><i
                                                                class="fas fa-plus-circle h2 text-primary"></i></a></li>
                                                </ul>
                                            </div>
                                            <div class="card-body">
                                                <div class="accordion">
                                                    @foreach ($subject->semesters as $semester)
                                                        <div class="accordion-item border-0 border-bottom">
                                                            <h2 class="accordion-header" id="heading{{ $semester->id }}">
                                                                <button
                                                                    class="accordion-button collapsed gap-2 accordion-secondary"
                                                                    type="button" data-bs-toggle="collapse"
                                                                    data-bs-target="#panel{{ $semester->id }}"
                                                                    aria-expanded="false"
                                                                    aria-controls="panel{{ $semester->id }}">
                                                                    <i class="fas fa-graduation-cap"></i>
                                                                    {{ $semester->getTranslation('name', app()->getLocale()) }}
                                                                </button>
                                                            </h2>
                                                            <div class="accordion-collapse collapse"
                                                                id="panel{{ $semester->id }}"
                                                                aria-labelledby="heading{{ $semester->id }}">
                                                                <div class="accordion-body">
                                                                    @foreach ($semester->units as $unit)
                                                                        <div class="accordion-item border-0 border-bottom">
                                                                            <h2 class="accordion-header"
                                                                                id="headingUnit{{ $unit->id }}">
                                                                                <button
                                                                                    class="accordion-button collapsed gap-2"
                                                                                    type="button"
                                                                                    data-bs-toggle="collapse"
                                                                                    data-bs-target="#pane{{ $unit->id }}"
                                                                                    aria-expanded="false"
                                                                                    aria-controls="pane{{ $unit->id }}">
                                                                                    <i class="fas fa-book-open"></i>
                                                                                    {{ $unit->getTranslation('name', app()->getLocale()) }}
                                                                                </button>
                                                                            </h2>
                                                                            <div class="accordion-collapse collapse"
                                                                                id="pane{{ $unit->id }}"
                                                                                aria-labelledby="headingUnit{{ $unit->id }}">
                                                                                <div class="accordion-body">
                                                                                    @foreach ($unit->lessons as $lesson)
                                                                                        <div
                                                                                            class="accordion-item border-0 border-bottom">
                                                                                            <h2 class="accordion-header"
                                                                                                id="headingLesson{{ $lesson->id }}">
                                                                                                <button
                                                                                                    class="accordion-button collapsed gap-2"
                                                                                                    type="button"
                                                                                                    data-bs-toggle="collapse"
                                                                                                    data-bs-target="#panelLesson{{ $lesson->id }}"
                                                                                                    aria-expanded="false"
                                                                                                    aria-controls="panelLesson{{ $lesson->id }}">
                                                                                                    <i
                                                                                                        class="fas fa-book-open-reader"></i>
                                                                                                    {{ $lesson->getTranslation('title', app()->getLocale()) }}
                                                                                                </button>
                                                                                            </h2>
                                                                                            <div class="accordion-collapse collapse"
                                                                                                id="panelLesson{{ $lesson->id }}"
                                                                                                aria-labelledby="headingLesson{{ $lesson->id }}">
                                                                                                <div
                                                                                                    class="accordion-body">
                                                                                                    <div class="card">
                                                                                                        <div
                                                                                                            class="card-header">
                                                                                                            <div
                                                                                                                class="card-title">
                                                                                                                <div
                                                                                                                    class="d-flex justify-content-between align-item-center gap-5">
                                                                                                                    <h4
                                                                                                                        class="">
                                                                                                                    </h4>
                                                                                                                    <div
                                                                                                                        class="btn">
                                                                                                                        <!-- Edit Lesson Modal -->
                                                                                                                        <a class="btn btn-primary btn-sm btn-activity-danger"
                                                                                                                            href="javascript:void(0)"
                                                                                                                            data-bs-toggle="modal"
                                                                                                                            data-bs-target="#editLessonModal{{ $lesson->id }}">
                                                                                                                            <i
                                                                                                                                class="fas fa-edit mx-1"></i>{{ __('dashboard.editLesson') }}
                                                                                                                        </a>

                                                                                                                        <!-- Add Exam Modal -->
                                                                                                                        <a class="btn btn-danger btn-sm btn-activity-danger"
                                                                                                                            href="javascript:void(0)"
                                                                                                                            data-bs-toggle="modal"
                                                                                                                            data-bs-target="#addExamModal{{ $lesson->id }}">
                                                                                                                            <i
                                                                                                                                class="fas fa-award mx-1"></i>{{ __('dashboard.addexam') }}
                                                                                                                        </a>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="card-body text-center">
                                                                                                            <p
                                                                                                                class="text-wrap">
                                                                                                                {{ $lesson->getTranslation('content', app()->getLocale()) ?? '' }}
                                                                                                            </p>
                                                                                                        </div>
                                                                                                    </div>

                                                                                                    <!-- Edit Lesson Modal -->
                                                                                                    <div class="modal fade"
                                                                                                        id="editLessonModal{{ $lesson->id }}"
                                                                                                        tabindex="-1"
                                                                                                        aria-labelledby="editLessonModalLabel{{ $lesson->id }}"
                                                                                                        aria-hidden="true">
                                                                                                        <div
                                                                                                            class="modal-dialog modal-lg">
                                                                                                            <div
                                                                                                                class="modal-content">
                                                                                                                <div
                                                                                                                    class="modal-header">
                                                                                                                    <h5 class="modal-title"
                                                                                                                        id="editLessonModalLabel{{ $lesson->id }}">
                                                                                                                        {{ __('dashboard.editLesson') }}
                                                                                                                    </h5>
                                                                                                                    <button
                                                                                                                        type="button"
                                                                                                                        class="btn-close"
                                                                                                                        data-bs-dismiss="modal"
                                                                                                                        aria-label="Close"></button>
                                                                                                                </div>
                                                                                                                <form
                                                                                                                    action="{{ route('lessons.update', $lesson->id) }}"
                                                                                                                    method="POST"
                                                                                                                    class="needs-validation custom-input validation-forms"
                                                                                                                    novalidate>
                                                                                                                    @csrf
                                                                                                                    @method('PUT')
                                                                                                                    <div
                                                                                                                        class="modal-body">
                                                                                                                        <input
                                                                                                                            type="hidden"
                                                                                                                            value="{{ $lesson->unit_id }}"
                                                                                                                            name="unit_id">
                                                                                                                        <div
                                                                                                                            class="form-group mb-2">
                                                                                                                            <label
                                                                                                                                for="title_ar">{{ __('dashboard.title_ar') }}</label>
                                                                                                                            <input
                                                                                                                                type="text"
                                                                                                                                class="form-control"
                                                                                                                                name="title_ar"
                                                                                                                                value="{{ $lesson->getTranslation('title', 'ar') }}"
                                                                                                                                required>
                                                                                                                            <div
                                                                                                                                class="invalid-feedback">
                                                                                                                                {{ __('dashboard.title_ar_required') }}
                                                                                                                            </div>
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="form-group mb-2">
                                                                                                                            <label
                                                                                                                                for="title_en">{{ __('dashboard.title_en') }}</label>
                                                                                                                            <input
                                                                                                                                type="text"
                                                                                                                                class="form-control"
                                                                                                                                name="title_en"
                                                                                                                                value="{{ $lesson->getTranslation('title', 'en') }}"
                                                                                                                                required>
                                                                                                                            <div
                                                                                                                                class="invalid-feedback">
                                                                                                                                {{ __('dashboard.title_en_required') }}
                                                                                                                            </div>
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="form-group mb-2">
                                                                                                                            <label
                                                                                                                                for="content_ar">{{ __('dashboard.content_ar') }}</label>
                                                                                                                            <textarea class="form-control" name="content_ar" rows="4" required>{{ $lesson->getTranslation('content', 'ar') }}</textarea>
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="form-group mb-2">
                                                                                                                            <label
                                                                                                                                for="content_en">{{ __('dashboard.content_en') }}</label>
                                                                                                                            <textarea class="form-control" name="content_en" rows="4" required>{{ $lesson->getTranslation('content', 'en') }}</textarea>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                    <div
                                                                                                                        class="modal-footer">
                                                                                                                        <button
                                                                                                                            type="button"
                                                                                                                            class="btn btn-secondary"
                                                                                                                            data-bs-dismiss="modal">{{ __('dashboard.close') }}</button>
                                                                                                                        <button
                                                                                                                            type="submit"
                                                                                                                            class="btn btn-primary">{{ __('dashboard.update') }}</button>
                                                                                                                    </div>
                                                                                                                </form>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>

                                                                                                    <!-- Add Exam Modal -->
                                                                                                    <div class="modal fade"
                                                                                                        id="addExamModal{{ $lesson->id }}"
                                                                                                        tabindex="-1"
                                                                                                        aria-labelledby="addExamModalLabel{{ $lesson->id }}"
                                                                                                        aria-hidden="true">
                                                                                                        <div
                                                                                                            class="modal-dialog modal-lg">
                                                                                                            <div
                                                                                                                class="modal-content">
                                                                                                                <div
                                                                                                                    class="modal-header">
                                                                                                                    <h5 class="modal-title"
                                                                                                                        id="addExamModalLabel{{ $lesson->id }}">
                                                                                                                        {{ __('dashboard.addexam') }}
                                                                                                                    </h5>
                                                                                                                    <button
                                                                                                                        type="button"
                                                                                                                        class="btn-close"
                                                                                                                        data-bs-dismiss="modal"
                                                                                                                        aria-label="Close"></button>
                                                                                                                </div>
                                                                                                                <form
                                                                                                                    action="{{ route('exams.store') }}"
                                                                                                                    method="POST"
                                                                                                                    class="needs-validation custom-input validation-forms"
                                                                                                                    novalidate>
                                                                                                                    @csrf
                                                                                                                    <input
                                                                                                                        type="hidden"
                                                                                                                        name="unit_id"
                                                                                                                        value="{{ $lesson->unit_id }}">
                                                                                                                    <input
                                                                                                                        type="hidden"
                                                                                                                        name="lesson_id"
                                                                                                                        value="{{ $lesson->id }}">
                                                                                                                    <div
                                                                                                                        class="modal-body">
                                                                                                                        <div
                                                                                                                            class="row mb-2">
                                                                                                                            <div
                                                                                                                                class="form-group mb-2 col-12 col-lg-6 col-xl-6 col-md-12 col-sm-12">
                                                                                                                                <label
                                                                                                                                    for="title_ar">{{ __('dashboard.title_ar') }}</label>
                                                                                                                                <input
                                                                                                                                    type="text"
                                                                                                                                    class="form-control"
                                                                                                                                    name="title_ar"
                                                                                                                                    required>
                                                                                                                                <div
                                                                                                                                    class="invalid-feedback">
                                                                                                                                    {{ __('dashboard.title_ar_required') }}
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div
                                                                                                                                class="form-group mb-2 col-12 col-lg-6 col-xl-6 col-md-12 col-sm-12">
                                                                                                                                <label
                                                                                                                                    for="title_en">{{ __('dashboard.title_en') }}</label>
                                                                                                                                <input
                                                                                                                                    type="text"
                                                                                                                                    class="form-control"
                                                                                                                                    name="title_en"
                                                                                                                                    required>
                                                                                                                                <div
                                                                                                                                    class="invalid-feedback">
                                                                                                                                    {{ __('dashboard.title_en_required') }}
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div
                                                                                                                                class="form-group mb-2 col-12 col-lg-6 col-xl-6 col-md-12 col-sm-12">
                                                                                                                                <label
                                                                                                                                    for="content_ar">{{ __('dashboard.info_ar') }}</label>
                                                                                                                                <textarea class="form-control" name="description_ar" rows="4"></textarea>
                                                                                                                            </div>
                                                                                                                            <div
                                                                                                                                class="form-group mb-2 col-12 col-lg-6 col-xl-6 col-md-12 col-sm-12">
                                                                                                                                <label
                                                                                                                                    for="content_en">{{ __('dashboard.info_en') }}</label>
                                                                                                                                <textarea class="form-control" name="description_en" rows="4"></textarea>
                                                                                                                            </div>
                                                                                                                        </div>

                                                                                                                        <div
                                                                                                                            class="row">
                                                                                                                            <div
                                                                                                                                class="col-12 col-xl-4 col-lg-4 col-md-12 col-sm-12 mb-2">
                                                                                                                                <div
                                                                                                                                    class="form-group mb-2">
                                                                                                                                    <label
                                                                                                                                        for="content_en">{{ __('dashboard.min_time') }}</label>
                                                                                                                                    <input
                                                                                                                                        type="number"
                                                                                                                                        class="form-control"
                                                                                                                                        name="min_time"
                                                                                                                                        required>
                                                                                                                                    <div
                                                                                                                                        class="invalid-feedback">
                                                                                                                                        {{ __('dashboard.time_required') }}
                                                                                                                                    </div>
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div
                                                                                                                                class="col-12 col-xl-4 col-lg-4 col-md-12 col-sm-12 mb-2">
                                                                                                                                <div
                                                                                                                                    class="form-group mb-2">
                                                                                                                                    <label
                                                                                                                                        for="content_en">{{ __('dashboard.max_time') }}</label>
                                                                                                                                    <input
                                                                                                                                        type="number"
                                                                                                                                        class="form-control"
                                                                                                                                        name="max_time"
                                                                                                                                        required>
                                                                                                                                    <div
                                                                                                                                        class="invalid-feedback">
                                                                                                                                        {{ __('dashboard.time_required') }}
                                                                                                                                    </div>
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                            <div
                                                                                                                                class="col-12 col-xl-4 col-lg-4 col-md-12 col-sm-12 mb-2">
                                                                                                                                <div
                                                                                                                                    class="form-group mb-2">
                                                                                                                                    <label
                                                                                                                                        for="content_en">{{ __('dashboard.average_time') }}</label>
                                                                                                                                    <input
                                                                                                                                        type="number"
                                                                                                                                        class="form-control"
                                                                                                                                        name="average_time"
                                                                                                                                        required>
                                                                                                                                    <div
                                                                                                                                        class="invalid-feedback">
                                                                                                                                        {{ __('dashboard.time_required') }}
                                                                                                                                    </div>
                                                                                                                                </div>
                                                                                                                            </div>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                    <div
                                                                                                                        class="modal-footer">
                                                                                                                        <button
                                                                                                                            type="button"
                                                                                                                            class="btn btn-secondary"
                                                                                                                            data-bs-dismiss="modal">{{ __('dashboard.close') }}</button>
                                                                                                                        <button
                                                                                                                            type="submit"
                                                                                                                            class="btn btn-primary">{{ __('dashboard.save') }}</button>
                                                                                                                    </div>
                                                                                                                </form>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="fade tab-pane" id="exams" role="tabpanel"
                                        aria-labelledby="exams-tab">
                                        <div class="card mb-0">
                                            <div class="card-header mb-0 card-no-border">
                                                <div class="card-title mb-3">
                                                    <h3 class="mb-0">{{ __('dashboard.exams') }}</h3>
                                                </div>
                                                <div class="row  mb-3 shadow p-3 rounded-3">
                                                    <!-- Filter by Semester -->
                                                    <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-3">
                                                        <select id="semesterFilter" class="form-select">
                                                            <option value="">{{ __('dashboard.semesters') }}
                                                            </option>
                                                            @foreach ($subject->semesters as $semester)
                                                                <option value="{{ $semester->id }}">
                                                                    {{ $semester->getTranslation('name', app()->getLocale()) }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <!-- Filter by Unit -->
                                                    <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-3">
                                                        <select id="unitFilter" class="form-select">
                                                            <option value="">{{ __('dashboard.units') }}
                                                            </option>
                                                            @foreach ($subject->semesters as $semester)
                                                                @foreach ($semester->units as $unit)
                                                                    <option value="{{ $unit->id }}">
                                                                        {{ $unit->getTranslation('name', app()->getLocale()) }}
                                                                    </option>
                                                                @endforeach
                                                            @endforeach

                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="details-bookmark text-center">
                                                    <div class="row" id="exams-date">
                                                        <div class="col-12">
                                                            <div class="table-responsive">
                                                                <table class="table table-bordered dataTable"
                                                                    id="exams-table">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>{{ __('dashboard.name') }}</th>
                                                                            <th>{{ __('dashboard.lesson') }}</th>
                                                                            <th>{{ __('dashboard.semester') }}</th>
                                                                            <th>{{ __('dashboard.unit') }}</th>
                                                                            <th>{{ __('dashboard.min_time') }}</th>
                                                                            <th>{{ __('dashboard.max_time') }}</th>
                                                                            <th>{{ __('dashboard.average_time') }}</th>
                                                                            <th>{{ __('dashboard.action') }}</th>
                                                                        </tr>
                                                                    </thead>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="fade tab-pane" id="qui_group" role="tabpanel"
                                        aria-labelledby="qui_group-tab">
                                        <div class="card mb-0">
                                            <div class="card-header d-flex mb-0 card-no-border">
                                                <h3 class="mb-0">{{ __('dashboard.qui_group') }}</h3>
                                                <ul>
                                                    <li><a class="grid-bookmark-view" href="javascript:void(0)"
                                                            data-bs-toggle="modal" data-bs-target="#addQui_group"><i
                                                                class="fas fa-plus-circle h2 text-primary"></i></a></li>
                                                </ul>
                                            </div>
                                            <div class="card-body">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered dataTable" id="group-tbl">
                                                        <thead>
                                                            <tr>

                                                                <th>{{ __('dashboard.name') }}</th>
                                                                <th>{{ __('dashboard.info') }}</th>
                                                                <th>{{ __('dashboard.actions') }}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="fade tab-pane" id="questions" role="tabpanel"
                                        aria-labelledby="questions-tab">
                                        <div class="card mb-0">
                                            <div class="card-header d-flex mb-0 card-no-border">
                                                <h3 class="mb-0">{{ __('dashboard.questions') }}</h3>
                                                <ul>
                                                    <li><a class="grid-bookmark-view active"
                                                            href="{{ route('question.add') }}"><i
                                                                class="fas fa-plus-circle h2 text-primary"></i></a></li>
                                                </ul>
                                            </div>
                                            <div class="card-body">
                                              <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="card shadow-lg">
                                                        
                                                        <div class="card-body">
                                                            <div class="accordion" id="examAccordion">
                                        
                                                                @foreach ($groupedExams as $index => $exam)
                                                                    <div class="accordion-item border-0 shadow-sm">
                                                                        <h2 class="accordion-header" id="heading{{ $index }}">
                                                                            <button class="accordion-button collapsed d-flex align-items-center gap-2 p-3"
                                                                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $index }}"
                                                                                aria-expanded="false" aria-controls="collapse{{ $index }}">
                                                                                <i class="fas fa-bell text-warning"></i>
                                                                                <span class="fw-bold text-primary">{{ $exam['name'] }}</span>
                                                                                <i class="fas fa-arrow-down me-auto text-secondary"></i>
                                                                            </button>
                                                                        </h2>
                                                                        <div id="collapse{{ $index }}" class="accordion-collapse collapse"
                                                                            aria-labelledby="heading{{ $index }}" data-bs-parent="#examAccordion">
                                                                            <div class="accordion-body bg-light p-4 rounded">
                                        
                                                                                <div class="accordion" id="questionGroupAccordion{{ $index }}">
                                                                                    @foreach ($exam['question_groups'] as $groupId => $questions)
                                                                                        <div class="accordion-item border-0 shadow-sm">
                                                                                            <h2 class="accordion-header" id="groupHeading{{ $index }}{{ $groupId }}">
                                                                                                <button class="accordion-button collapsed d-flex align-items-center gap-2 p-3"
                                                                                                    type="button" data-bs-toggle="collapse"
                                                                                                    data-bs-target="#groupCollapse{{ $index }}{{ $groupId }}"
                                                                                                    aria-expanded="false"
                                                                                                    aria-controls="groupCollapse{{ $index }}{{ $groupId }}">
                                                                                                    <i class="fas fa-layer-group text-info"></i>
                                                                                                    <span class="fw-bold">{{ $questions->first()->group->name }}</span>
                                                                                                    <i class="fas fa-chevron-down me-auto text-secondary"></i>
                                                                                                </button>
                                                                                            </h2>
                                                                                            <div id="groupCollapse{{ $index }}{{ $groupId }}"
                                                                                                class="accordion-collapse collapse"
                                                                                                aria-labelledby="groupHeading{{ $index }}{{ $groupId }}"
                                                                                                data-bs-parent="#questionGroupAccordion{{ $index }}">
                                                                                                <div class="accordion-body bg-white p-3 rounded">
                                                                                                    <ul class="list-group">
                                        
                                                                                                        @foreach ($questions as $question)
                                                                                                            <div class="mb-4 border p-3 rounded shadow-sm bg-light">
                                                                                                              @if ($question->video)
                                                                                                              <div class="mt-3">
                                                                                                                  <video width="100%" class="rounded shadow" controls>
                                                                                                                      <source src="{{ asset('storage/' . $question->video) }}" type="video/mp4">
                                                                                                                      {{ __('dashboard.video_not_supported') }}
                                                                                                                  </video>
                                                                                                              </div>
                                                                                                          @endif

                                                                                                                <div class="d-flex align-items-center justify-content-between">
                                                                                                                    <h5 class="fw-bold text-dark">
                                                                                                                        <i class="fas fa-question-circle text-primary"></i>
                                                                                                                        {{ $question->question_text }}
                                                                                                                    </h5>
                                                                                                                    <span class="badge bg-dark p-2"><i class="fas fa-check-circle text-warning mx-2"></i> {{ __('dashboard.marks') }}: {{ $question->marks }}</span>
                                                                                                                </div>
                                        
                                                                                                                <h6 class="mt-2">
                                                                                                                    <span class="badge">
                                                                                                                      <i class="fas fa-pencil-alt text-warning"></i>
                                                                                                                        {{ $question->question_type == 1 ? __('dashboard.Qui_multi') : __('dashboard.Qui_essay') }}
                                                                                                                    </span>
                                                                                                                </h6>
                                        
                                                                                                              
                                        
                                                                                                                @if ($question->question_type == 1)
                                                                                                                    <h5 class="mt-3"></h5>
                                                                                                                    <ul class="list-group">
                                                                                                                        @php $c = 1; @endphp
                                                                                                                        @foreach ($question->choices as $choice)
                                                                                                                            <li class="list-group-item border-0 d-flex justify-content-between align-items-center 
                                                                                                                                {{ $choice->is_correct ? '' : '' }}">
                                                                                                                                <span>{{ $c++ }} - {{ $choice->choice_text }}</span>
                                                                                                                                @if ($choice->is_correct == 1)
                                                                                                                                    <span class="badge bg-success"> <i class="fas fa-check-circle "></i> {{ __('dashboard.Qui_correct_option') }}</span>
                                                                                                                                @endif
                                                                                                                            </li>
                                                                                                                        @endforeach
                                                                                                                    </ul>
                                                                                                                @endif
                                        
                                                                                                                @if ($question->question_type == 2)
                                                                                                                    <h5 class="mt-3"> </h5>
                                                                                                                    <ul class="list-group">
                                                                                                                        @foreach ($question->essayAnswers as $answer)
                                                                                                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                                                                                                <span class="fw-bold text-primary">{{ $answer->user_answer }}</span>
                                                                                                                                <span class="text-muted"></span>
                                                                                                                                <span class="fw-bold badge bg-success">{{ $answer->correct_answer }}</span>
                                                                                                                            </li>
                                                                                                                        @endforeach
                                                                                                                    </ul>
                                                                                                                @endif
                                                                                                            </div>
                                                                                                        @endforeach
                                                                                                    </ul>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div> <!-- End Question Group Accordion -->
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                        
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Subject Edit Modal (Dynamic for Each Subject) -->
    <div class="modal fade" id="editModal{{ $subject->id }}" tabindex="-1" aria-labelledby="mdModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5">{{ __('dashboard.editSub') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('subjects.sub_update', $subject->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <input type="hidden" class="subject_id" value="{{ $subject->id }}">

                    <div class="modal-body dark-modal">
                        <div class="row">
                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="name_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control name_ar" type="text" required="" name="name[ar]"
                                    value="{{ $subject->getTranslation('name', 'ar') }}">
                                <div class="invalid-feedback">
                                    {{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="name_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control name_en" type="text" required="" name="name[en]"
                                    value="{{ $subject->getTranslation('name', 'en') }}">
                                <div class="invalid-feedback">
                                    {{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label">{{ __('dashboard.grade') }}</label>
                                <select class="form-select Edit_grade_id" required="" name="grade_id">
                                    @foreach ($grades as $grade)
                                        <option value="{{ $grade->id }}"
                                            {{ $grade->id == $subject->grade_id ? 'selected' : '' }}>
                                            {{ $grade->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">
                                    {{ __('dashboard.select_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label">{{ __('dashboard.classroom') }}</label>
                                <select class="form-select classroom_id" required="" name="classroom_id">
                                    @foreach ($grades as $grade)
                                        @foreach ($grade->classrooms as $classroom)
                                            <option value="{{ $classroom->id }}"
                                                {{ $classroom->id == $subject->classroom_id ? 'selected' : '' }}>
                                                {{ $classroom->getTranslation('name', app()->getLocale()) }}
                                            </option>
                                        @endforeach
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">
                                    {{ __('dashboard.select_required') }}</div>
                            </div>


                            <div class="col-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="price">{{ __('dashboard.price') }}</label>
                                <input class="form-control" id="price" type="number" required=""
                                    value="{{ $subject->price }}" name="price">
                                <div class="invalid-feedback">{{ __('dashboard.price_required') }}</div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">
                            <i class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}
                        </button>
                        <button class="btn btn-primary update-subject" type="submit">
                            <i class="fas fa-save mx-2"></i>{{ __('dashboard.update') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal addSemester -->
    <div class="modal fade" id="addSemester" tabindex="-1" aria-labelledby="edit-bookmarkLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSemester-Label">{{ __('dashboard.addSemester') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('semester.add') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <input type="hidden" name="subject_id" value="{{ $subject->id }}">

                            <div class="col-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="subject_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="subject_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <label class="col-xxl-3 box-col-12 text-start">{{ __('dashboard.start_date') }}</label>
                            <div class="col-xxl-9 mb-3">
                                <div class="input-group flatpicker-calender">
                                    <input class="form-control" id="start_date" type="date" name="start_date">
                                </div>
                            </div>

                            <label class="col-xxl-3 box-col-12 text-start">{{ __('dashboard.end_date') }}</label>
                            <div class="col-xxl-9">
                                <div class="input-group flatpicker-calender">
                                    <input class="form-control" id="end_start" type="date" name="end_date">
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal addUnit -->
    <div class="modal fade" id="addUnit" tabindex="-1" aria-labelledby="edit-bookmarkLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addUnit-Label">{{ __('dashboard.addUnit') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('units.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">

                            <div class="col-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="semester">{{ __('dashboard.semester') }}</label>
                                <select class="form-select" id="semester" required="" name="semester_id">
                                    <option value="">{{ __('dashboard.Choose..') }}</option>
                                    @foreach ($subject->semesters as $semester)
                                        <option value="{{ $semester->id }}">
                                            {{ $semester->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>
                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="subject_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="subject_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="info_ar">{{ __('dashboard.info_ar') }}</label>

                                <textarea name="info_ar" id="" cols="30" rows="3" class="form-control"></textarea>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="info_en">{{ __('dashboard.info_en') }}</label>

                                <textarea name="info_en" id="" cols="30" rows="3" class="form-control"></textarea>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Modal addLesson -->
    <div class="modal fade" id="addLesson" tabindex="-1" aria-labelledby="edit-bookmarkLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addLesson-Label">{{ __('dashboard.addLesson') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('lessons.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="semester_unit">{{ __('dashboard.semester') }}</label>
                                <select class="form-select" id="semester_unit" required="" name="semester_id">
                                    <option value="">{{ __('dashboard.Choose..') }}</option>
                                    @foreach ($subject->semesters as $semester)
                                        <option value="{{ $semester->id }}">
                                            {{ $semester->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="units_unit">{{ __('dashboard.units') }}</label>
                                <select class="form-select" id="units_unit" required="" name="unit_id">
                                    <option value="">{{ __('dashboard.Choose..') }}</option>
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>
                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_ar">{{ __('dashboard.title_ar') }}</label>
                                <input class="form-control" id="subject_ar" type="text" required=""
                                    name="title_ar">
                                <div class="invalid-feedback">{{ __('dashboard.title_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_en">{{ __('dashboard.title_en') }}</label>
                                <input class="form-control" id="subject_en" type="text" required=""
                                    name="title_en">
                                <div class="invalid-feedback">{{ __('dashboard.title_en_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="content_ar">{{ __('dashboard.content_ar') }}</label>

                                <textarea name="content_ar" id="" cols="30" rows="5" class="form-control"></textarea>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="content_en">{{ __('dashboard.content_en') }}</label>

                                <textarea name="content_en" id="" cols="30" rows="5" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal addExam -->
    <div class="modal fade" id="addExam" tabindex="-1" aria-labelledby="edit-bookmarkLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addLesson-Label">{{ __('dashboard.addexam') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('exams.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">

                            <div class="col-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-2">
                                <label class="form-label" for="lesson_id">{{ __('dashboard.lessons') }}</label>
                                <select class="form-select" id="lesson_id" required="" name="lesson_id">
                                    <option value="">{{ __('dashboard.Choose..') }}</option>
                                    @foreach ($subject->semesters as $semester)
                                        <option value="{{ $semester->id }}">
                                            {{ $semester->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                            </div>


                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_ar">{{ __('dashboard.title_ar') }}</label>
                                <input class="form-control" id="subject_ar" type="text" required=""
                                    name="title_ar">
                                <div class="invalid-feedback">{{ __('dashboard.title_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_en">{{ __('dashboard.title_en') }}</label>
                                <input class="form-control" id="subject_en" type="text" required=""
                                    name="title_en">
                                <div class="invalid-feedback">{{ __('dashboard.title_en_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="description_ar">{{ __('dashboard.info_ar') }}</label>

                                <textarea name="description_ar" id="" cols="30" rows="5" class="form-control"></textarea>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="description_en">{{ __('dashboard.info_en') }}</label>

                                <textarea name="description_en" id="description_en" cols="30" rows="5" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Modal addQui_groups -->
    <div class="modal fade" id="addQui_group" tabindex="-1" aria-labelledby="edit-bookmarkLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSemester-Label">{{ __('dashboard.addQui_group') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('questionGroups.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <input type="hidden" name="subject_id" value="{{ $subject->id }}">

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="subject_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="subject_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>


                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="description_ar">{{ __('dashboard.info_ar') }}</label>
                                <textarea name="description_ar" id="" cols="30" rows="5" class="form-control"></textarea>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="description_en">{{ __('dashboard.info_en') }}</label>
                                <textarea name="description_en" id="description_en" cols="30" rows="5" class="form-control"></textarea>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Modal editQui_groups -->
    <div class="modal fade" id="editGroup" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.editQui_group') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="editGroupForm" class="needs-validation custom-input validation-forms" novalidate=""
                    method="POST" action="{{ route('questionGroups.update', ':id') }}">
                    @method('PUT')
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <input type="hidden" name="subject_id" value="{{ $subject->id }}"
                                id="group_subject_id">

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="group_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="subject_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="group_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>


                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="description_ar">{{ __('dashboard.info_ar') }}</label>
                                <textarea name="description_ar" id="group_description_ar" cols="30" rows="5" class="form-control"></textarea>
                            </div>

                            <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="description_en">{{ __('dashboard.info_en') }}</label>
                                <textarea name="description_en" id="group_description_en" cols="30" rows="5" class="form-control"></textarea>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.update') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <!-- flatpicker-->
    <script src="{{ asset('assets/js/flat-pickr/flatpickr.js') }}"></script>
    <script src="{{ asset('assets/js/flat-pickr/custom-flatpickr.js') }}"></script>


    <script>
        $(document).on('change', '.Edit_grade_id', function() {
            let grade_id = $(this).val();
            let modal = $(this).closest('.modal'); // Ensure correct modal is selected
            let classroomSelect = modal.find('.classroom_id'); // Find classroom dropdown in the modal

            if (grade_id) {
                $.ajax({
                    url: "{{ route('subjects.getClasses', '') }}/" + grade_id,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        classroomSelect.empty().append(
                            '<option value="">{{ __('dashboard.Choose..') }}</option>');
                        $.each(data, function(key, value) {
                            classroomSelect.append(
                                `<option value="${value.id}">${value.name}</option>`);
                        });
                    },
                    error: function(xhr) {
                        if (xhr.status === 404) {
                            classroomSelect.empty().append(
                                '<option value="">{{ __('dashboard.no_classes_found') }}</option>'
                            );
                        }
                    }
                });
            } else {
                classroomSelect.empty().append('<option value="">{{ __('dashboard.Choose..') }}</option>');
            }
        });

        // Handle Edit Form Submission for Multiple Modals
        $(document).on('submit', '.subjectEditForm', function(e) {
            e.preventDefault();

            let form = $(this);
            let modal = form.closest('.modal'); // Get the correct modal
            let subjectId = modal.find('.subject_id').val(); // Get the subject ID

            let formData = {
                name: {
                    ar: modal.find('.name_ar').val(),
                    en: modal.find('.name_en').val()
                },
                grade_id: modal.find('.Edit_grade_id').val(),
                classroom_id: modal.find('.classroom_id').val(),
                _token: $('input[name=_token]').val()
            };

            $.ajax({
                url: `/subjects_update/${subjectId}`,
                type: 'PUT',
                data: formData,
                success: function(response) {
                    modal.modal('hide'); // Close modal after success
                    location.reload(); // Refresh table or reload page
                    toastr.success(response.message);
                },
                error: function() {
                    toastr.error("{{ __('flasher::messages.error') }}");
                }
            });
        });


        // When the semester is selected
        $('#semester_unit').on('change', function() {

            var semesterId = $(this).val(); // Get the selected semester ID
            console.log(semesterId);
            // If a valid semester is selected
            if (semesterId) {
                // Make an AJAX request to fetch units for the selected semester
                $.ajax({
                    url: '/units-by-semester/' + semesterId, // The URL to fetch units
                    type: 'GET',
                    success: function(response) {
                        // Clear the existing units options
                        $('#units_unit').empty();

                        // Add a default option for units
                        $('#units_unit').append(
                            '<option value="">{{ __('dashboard.Choose..') }}</option>');

                        // Loop through the units returned and add them to the select box
                        $.each(response, function(index, unit) {
                            $('#units_unit').append('<option value="' + unit.id + '">' + unit
                                .name + '</option>');
                        });
                    },
                    error: function() {
                        alert('Error fetching units');
                    }
                });
            } else {
                // If no semester is selected, clear the units dropdown
                $('#units_unit').empty();
                $('#units_unit').append('<option value="">{{ __('dashboard.Choose..') }}</option>');
            }
        });

        $('input[type="checkbox"][id^="semester"]').on('click', function() {
            var semesterId = $(this).attr('id').replace('semester', ''); // Get the semester ID
            if ($(this).is(':checked')) {
                // Show the units if the semester is checked
                $('#semester' + semesterId + '-units').collapse('show');
            } else {
                // Hide the units if the semester is unchecked
                $('#semester' + semesterId + '-units').collapse('hide');
                // Also hide all lessons under the unit if the semester is unchecked
                $('#semester' + semesterId + '-units .collapse').collapse('hide');
            }
        });

        // When a unit checkbox is clicked
        $('input[type="checkbox"][id^="unit"]').on('click', function() {
            var unitId = $(this).attr('id').replace('unit', ''); // Get the unit ID
            if ($(this).is(':checked')) {
                // Show the lessons if the unit is checked
                $('#unit' + unitId + '-lessons').collapse('show');
            } else {
                // Hide the lessons if the unit is unchecked
                $('#unit' + unitId + '-lessons').collapse('hide');
            }
        });


        $(document).ready(function() {
            // Initialize DataTable
            var table = $('#exams-table').DataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                ajax: {
                    url: "{{ route('exams.data', $subject->id) }}",
                    data: function(d) {
                        // Send filter values and search term
                        d.semester = $('#semesterFilter').val();
                        d.unit = $('#unitFilter').val();

                    }
                },
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'title',
                        name: 'title',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'lesson',
                        name: 'lesson',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'unit',
                        name: 'unit',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'semester',
                        name: 'semester',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'min_time',
                        name: 'min_time',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'max_time',
                        name: 'max_time',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'average_time',
                        name: 'average_time',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            // Filter by Semester
            $('#semesterFilter').change(function() {
                table.draw();
            });

            // Filter by Unit
            $('#unitFilter').change(function() {
                table.draw();
            });


            // Delete Exam Action
            $('body').on('click', '.delete-exam', function() {
                var examId = $(this).data('id');
                if (confirm('Are you sure you want to delete this exam?')) {
                    $.ajax({
                        url: '/exams/' + examId,
                        method: 'DELETE',
                        success: function(response) {
                            alert('Exam deleted successfully');
                            table.draw(); // Refresh the DataTable
                        },
                        error: function(error) {
                            alert('Failed to delete exam');
                        }
                    });
                }
            });


            var groupTbl = $('#group-tbl').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('questionGroups.data', $subject->id) }}", // URL of your controller method
                    data: function(d) {
                        d._token = $('meta[name="csrf-token"]').attr('content'); // CSRF Token
                    }
                },
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'name',
                        name: 'name'
                    }, {
                        data: 'description',
                        name: 'description'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    } // Column for actions
                ]
            });

            $(document).on('click', '.editGroup-btn', function() {
                let groupId = $(this).data('id');
                let nameAr = $(this).data('name_ar');
                let nameEn = $(this).data('name_en');
                let descriptionAr = $(this).data('description_ar');
                let descriptionEn = $(this).data('description_en');

                // Populate modal fields
                $('#group_subject_id').val(groupId);
                $('#group_ar').val(nameAr);
                $('#group_en').val(nameEn);
                $('#group_description_ar').val(descriptionAr);
                $('#group_description_en').val(descriptionEn);

                // Set the form action to update the correct group
                var formAction = $('#editGroupForm').attr('action').replace(':id', groupId);
                $('#editGroupForm').attr('action', formAction);

                // Show modal
                $('#editGroup').modal('show');
            });

        });
    </script>
@endsection
