@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.unit_semester') }}
@endsection

@section('btn')
    <a href="{{ route('subjects.show', $subject->id) }}" class="btn btn-outline-danger"><i class="fas fa-door-open mx-2"></i>
        {{ __('dashboard.close') }}</a>
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
@endsection
@section('content')
    <div class="row">
        @foreach ($units as $unit)
            <a href="" data-bs-toggle="modal" data-bs-target="#edit-unit{{ $unit->id }}"
                class="col-xl-4 col-lg-4 col-md-6 col-sm-12 col-12">
                <div>
                    <div class="card shadow rounded-3">
                        <div class="card-header d-flex align-items-center">
                            <i class="fas fa-book-open fa-2x me-3 text-primary"></i>
                            <div class="card-title">
                                <h5>{{ $unit->name }}
                                </h5>
                            </div>
                        </div>
                        <div class="card-body text-center" style="height: 100px; max-height: 100px;">
                            <p>{{ $unit->info ?? 'No information available' }}
                            </p>
                        </div>
                        <div class="card-footer text-center text-muted bg-danger">
                            <small>{{ $unit->created_at->format('Y-m-d H:i') }}</small>
                        </div>
                    </div>
                </div>
            </a>




            <!-- Modal for Editing Unit -->
            <div class="modal fade" id="edit-unit{{ $unit->id }}" tabindex="-1"
                aria-labelledby="edit-unitLabel{{ $unit->id }}" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header ">
                            <h5 class="modal-title" id="edit-unitLabel{{ $unit->id }}">
                                {{ __('dashboard.editUnit') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="{{ route('units.update', $unit->id) }}" method="POST" class="needs-validation"
                            novalidate>
                            @method('PUT')
                            @csrf
                            <div class="modal-body">
                                <div class="row">
                                    <input type="hidden" name="unit_id" value="{{ $unit->id }}">

                                    <div class="col-12 mb-2">
                                        <label class="col-sm-12 col-form-label"
                                            for="semester">{{ __('dashboard.semester') }}</label>
                                        <select class="form-select" id="semester" required="" name="semester_id">

                                            @foreach ($subject->semesters as $semester)
                                                <option value="{{ $semester->id }}"
                                                    @if ($semester->id == $unit->semester_id) selected @endif>
                                                    {{ $semester->getTranslation('name', app()->getLocale()) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback">
                                            {{ __('dashboard.select_required') }}
                                        </div>
                                    </div>

                                    <!-- Name Fields -->
                                    <div class="col-12 mb-3">
                                        <label class="col-sm-12 col-form-label"
                                            for="unit_name_ar">{{ __('dashboard.name_ar') }}</label>
                                        <input class="form-control" id="unit_name_ar" type="text" name="name_ar"
                                            value="{{ $unit->getTranslation('name', 'ar') }}" required>
                                        <div class="invalid-feedback">
                                            {{ __('dashboard.name_ar_required') }}
                                        </div>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label for="unit_name_en">{{ __('dashboard.name_en') }}</label>
                                        <input class="form-control" id="unit_name_en" type="text" name="name_en"
                                            value="{{ $unit->getTranslation('name', 'en') }}" required>
                                        <div class="invalid-feedback">
                                            {{ __('dashboard.name_en_required') }}
                                        </div>
                                    </div>

                                    <!-- Info Fields -->
                                    <div class="col-12 mb-3">
                                        <label for="info_ar">{{ __('dashboard.info_ar') }}</label>
                                        <textarea name="info_ar" class="form-control" rows="3">{{ $unit->getTranslation('info', 'ar') }}</textarea>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label for="info_en">{{ __('dashboard.info_en') }}</label>
                                        <textarea name="info_en" class="form-control" rows="3">{{ $unit->getTranslation('info', 'en') }}</textarea>
                                    </div>

                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary"
                                    data-bs-dismiss="modal">{{ __('dashboard.close') }}</button>
                                <button type="submit" class="btn btn-primary">{{ __('dashboard.save') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection
@section('js')
@endsection
