@extends('layouts.master')
@section('title', 'طرق الدفع')

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between mb-3">
            <h2>طرق الدفع</h2>
            <button class="btn btn-primary" id="addMethod"><i class="fas fa-plus"></i> إضافة</button>
        </div>

        <table id="methodsTable" class="table table-bordered text-center align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>الاسم (عربي)</th>
                    <th>الاسم (إنجليزي)</th>
                    <th>الكود</th>
                    <th>الحالة</th>
                    <th>تاريخ الإنشاء</th>
                    <th>إجراء</th>
                </tr>
            </thead>
        </table>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="methodModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="methodForm">
                @csrf
                <input type="hidden" name="id" id="id">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">إضافة / تعديل طريقة الدفع</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">الاسم بالعربية</label>
                            <input type="text" class="form-control" name="name_ar" id="name_ar" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">الاسم بالإنجليزية</label>
                            <input type="text" class="form-control" name="name_en" id="name_en" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">الكود (اختياري)</label>
                            <input type="text" class="form-control" name="code" id="code">
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="active" id="active" value="1"
                                checked>
                            <label class="form-check-label" for="active">نشط</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">حفظ</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(function() {
            const table = $('#methodsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('payment-methods.index') }}',
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name_ar',
                        name: 'name_ar'
                    },
                    {
                        data: 'name_en',
                        name: 'name_en'
                    },
                    {
                        data: 'code',
                        name: 'code'
                    },
                    {
                        data: 'active',
                        name: 'active',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                order: [
                    [5, 'desc']
                ]
            });

            // فتح مودال الإضافة
            $('#addMethod').click(function() {
                $('#methodForm')[0].reset();
                $('#id').val('');
                $('#methodModal').modal('show');
            });

            // تعديل
            $(document).on('click', '.editMethod', function() {
                const id = $(this).data('id');
                $.get('/payment-methods/' + id + '/edit', function(data) {
                    $('#id').val(data.id);
                    $('#name_ar').val(data.name_ar);
                    $('#name_en').val(data.name_en);
                    $('#code').val(data.code);
                    $('#active').prop('checked', data.active);
                    $('#methodModal').modal('show');
                });
            });

            // حفظ
            $('#methodForm').submit(function(e) {
                e.preventDefault();
                $.ajax({
                    url: '{{ route('payment-methods.store') }}',
                    type: 'POST',
                    data: $(this).serialize(),
                    success: function(res) {
                        $('#methodModal').modal('hide');
                        table.ajax.reload();
                        alert(res.message);
                    },
                    error: function(xhr) {
                        alert('❌ حدث خطأ أثناء الحفظ');
                    }
                });
            });

            // حذف
            $(document).on('click', '.deleteMethod', function() {
                if (!confirm('هل تريد حذف هذه الطريقة؟')) return;
                const id = $(this).data('id');
                $.ajax({
                    url: '/payment-methods/' + id,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(res) {
                        table.ajax.reload();
                        alert(res.message);
                    },
                    error: function(xhr) {
                        alert(xhr.responseJSON?.message || 'حدث خطأ أثناء الحذف');
                    }
                });
            });
        });
    </script>
@endsection
