@extends('layouts.master') <!-- Extend -->

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.profile') }}
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12 col-12">
            <div class="card shadow-sm">

                <div class="card-body">
                    <!-- Form for Profile Update -->
                    <form action="{{ route('profile.update') }}" method="POST"
                        class="needs-validation custom-input validation-forms" novalidate="">
                        @csrf

                        <div class="row">

                            <!-- Name in Arabic Field -->
                            <div class="form-group col-md-6 mb-3">
                                <label for="name_ar" class="font-weight-bold">{{ __('dashboard.name_ar') }}</label>
                                <input type="text" class="form-control @error('name_ar') is-invalid @enderror"
                                    id="name_ar" name="name_ar"
                                    value="{{ old('name_ar', $profile->getTranslation('name', 'ar')) }}" required>
                                @error('name_ar')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <!-- Name in English Field -->
                            <div class="form-group col-md-6 mb-3">
                                <label for="name_en" class="font-weight-bold">{{ __('dashboard.name_en') }}</label>
                                <input type="text" class="form-control @error('name_en') is-invalid @enderror"
                                    id="name_en" name="name_en"
                                    value="{{ old('name_en', $profile->getTranslation('name', 'en')) }}" required>
                                @error('name_en')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <!-- Email Field -->
                            <div class="form-group col-md-12 mb-3">
                                <label for="email" class="font-weight-bold">{{ __('messages.username') }}</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror"
                                    id="email" name="email" value="{{ old('email', $profile->email) }}" required
                                    >
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <!-- New Password Field -->
                            <div class="form-group col-md-6 mb-3">
                                <label for="password" class="font-weight-bold">{{ __('dashboard.newPassword') }}
                                    ({{ __('dashboard.optional') }})</label>
                                <input type="password" class="form-control @error('password') is-invalid @enderror"
                                    id="password" name="password" >
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <!-- Password Confirmation Field -->
                            <div class="form-group col-md-6 mb-3">
                                <label for="password_confirmation"
                                    class="font-weight-bold">{{ __('dashboard.password_conformid') }}</label>
                                <input type="password" class="form-control" id="password_confirmation"
                                    name="password_confirmation" >
                            </div>

                        </div>

                        <!-- Submit Button -->
                        <div class="text-end">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="fas fa-save mr-1 mx-2"></i> {{ __('dashboard.update') }}
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection <!-- End Content -->

@section('js')
@endsection <!-- End JS -->
