@extends('layouts.master')
@section('title', 'تعديل فاتورة خدمات')

@section('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">

    <style>
        body {
            background: #08131f;
        }

        .card-flat {
            background: #0f2233;
            border-radius: 14px;
            border: 1px solid #1e3b4d;
            padding: 16px 18px;
            color: #eaf4ff;
            position: relative;
        }

        .section-title {
            font-weight: 700;
            color: #a7d1ff;
            font-size: .9rem;
        }

        .form-control,
        .form-select {
            background: #102536;
            border: 1px solid #24465f;
            color: #eaf4ff;
        }

        .form-control:focus,
        .form-select:focus {
            box-shadow: none;
            border-color: #0d6efd;
        }

        .table-invoice th,
        .table-invoice td {
            vertical-align: middle;
            font-size: 0.85rem;
            padding: .35rem .5rem;
        }

        .table-invoice th {
            background: #13283a;
            color: #a7d1ff;
            border-color: #1e3b4d !important;
        }

        .table-invoice td {
            border-color: #1e3b4d !important;
        }

        #itemsLock {
            background: rgba(0, 0, 0, 0.55);
            z-index: 5;
        }

        #itemsLock .lock-message {
            background: rgba(15, 34, 51, 0.95);
            border-radius: 12px;
            padding: 16px 20px;
            border: 1px dashed #ffc107;
        }

        .badge-type {
            font-size: 0.7rem;
            border-radius: 999px;
            padding: 0.15rem 0.55rem;
        }

        .summary-box {
            background: #0f2233;
            border-radius: 14px;
            border: 1px solid #1e3b4d;
            padding: 14px 16px;
        }

        .summary-box .section-title {
            font-size: .8rem;
        }

        .summary-value {
            font-size: 1.1rem;
            font-weight: 700;
        }

        .calc-box {
            background: #0b1b29;
            padding: 10px;
            text-align: center;
            border-radius: 10px;
            border: 1px solid #12344b;
            font-size: 1rem;
            min-height: 40px;
        }

        .table-darkish {
            background: #0f2233;
        }

        .table-darkish th,
        .table-darkish td {
            border-color: #1e3b4d !important;
        }
    </style>
@endsection

@section('content')
    <form action="{{ route('service-invoices.update', $invoice->id) }}" method="POST" id="invoiceForm">
        @csrf
        @method('PUT')

        <div class="container-fluid">

            {{-- ===== عنوان الصفحة + زر الحفظ / السداد ===== --}}
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h3 class="fw-bold text-light">
                    <i class="fas fa-file-medical me-2 text-info"></i> تعديل فاتورة خدمات
                    <span class="text-warning ms-2">#{{ str_pad($invoice->document_no, 6, '0', STR_PAD_LEFT) }}</span>
                </h3>

                <div class="text-center mt-4 d-flex gap-2">
                    {{-- فتح مودال السداد بالحجم الكامل --}}
                    <button type="button" id="openPaymentBtn" class="btn btn-primary" data-bs-toggle="modal"
                        data-bs-target="#paymentFullModal" disabled>
                        <i class="fas fa-credit-card me-2"></i> تعديل الدفع
                    </button>

                    {{-- حفظ الفاتورة (ممنوع قبل تأكيد الدفع الكامل) --}}
                    <button type="submit" class="btn btn-success px-4" id="saveInvoiceBtn" disabled>
                        <i class="fas fa-save me-1"></i> حفظ التعديلات
                    </button>
                </div>
            </div>

            {{-- ===== رأس الفاتورة ===== --}}
            <div class="card-flat mb-3">
                <div class="row g-3">

                    {{-- رقم الوثيقة --}}
                    <div class="col-md-2">
                        <div class="section-title mb-1">رقم الوثيقة</div>
                        <div class="form-control text-warning fw-bold border-0 py-2">
                            {{ str_pad($invoice->document_no, 6, '0', STR_PAD_LEFT) }}
                        </div>
                        <input type="hidden" name="document_no"
                            value="{{ str_pad($invoice->document_no, 6, '0', STR_PAD_LEFT) }}">
                    </div>

                    {{-- تاريخ الفاتورة ميلادي --}}
                    <div class="col-md-2">
                        <label class="section-title mb-1">تاريخ الفاتورة (ميلادي)</label>
                        <input type="date" name="greg_date" id="greg_date" class="form-control py-2"
                            value="{{ $invoice->greg_date instanceof \Carbon\Carbon ? $invoice->greg_date->format('Y-m-d') : $invoice->greg_date }}"
                            required>
                    </div>

                    {{-- تاريخ الفاتورة هجري --}}
                    <div class="col-md-2">
                        <label class="section-title mb-1">التاريخ الهجري</label>
                        <input type="text" name="hijri_date" id="hijri_date"
                            class="form-control bg-dark text-center py-2" value="{{ $invoice->hijri_date }}" readonly>
                    </div>

                    {{-- مقدم الخدمة --}}
                    <div class="col-md-3 mt-3">
                        <label class="section-title mb-1">مقدم الخدمه</label>
                        <select name="service_user_id" id="service_user_id" class="form-select select2" required>
                            <option value="">اختر مقدم الخدمه</option>
                            @foreach ($providers as $u)
                                <option value="{{ $u->id }}"
                                    {{ $invoice->service_user_id == $u->id ? 'selected' : '' }}>
                                    {{ $u->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- مسؤل المبيعات --}}
                    <div class="col-md-3 mt-3">
                        <label class="section-title mb-1">مسؤل المبيعات</label>
                        <select name="provider_user_id" id="provider_user_id" class="form-select select2" required>
                            <option value="">اختر مسؤل المبيعات</option>
                            @foreach ($providers as $u)
                                <option value="{{ $u->id }}"
                                    {{ $invoice->provider_user_id == $u->id ? 'selected' : '' }}>
                                    {{ $u->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- الفرع --}}
                    <div class="col-md-6">
                        <label class="section-title mb-1">الفرع</label>
                        <select name="branch_id" id="branch_id" class="form-select select2" required>
                            <option value="">اختر الفرع</option>
                            <option value="0" {{ $invoice->branch_id === null ? 'selected' : '' }}>كل الفروع</option>
                            @foreach ($branches as $b)
                                <option value="{{ $b->id }}" {{ $invoice->branch_id == $b->id ? 'selected' : '' }}>
                                    {{ $b->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- العضو --}}
                    <div class="col-md-6 mt-3">
                        <label class="section-title mb-1">اسم العضو</label>
                        <select name="member_id" id="member_id" class="form-select select2" required>
                            {{-- هنحمّل الأعضاء بالـ AJAX حسب الفرع، لكن مبدئياً نظهر العضو الحالي --}}
                            @if ($invoice->member)
                                <option value="{{ $invoice->member_id }}" selected>
                                    {{ $invoice->member->name }}
                                </option>
                            @else
                                <option value="">اختر العضو</option>
                            @endif
                        </select>
                    </div>

                    {{-- ملاحظات --}}
                    <div class="col-md-12 mt-3">
                        <label class="section-title mb-1">ملاحظات</label>
                        <textarea name="notes" rows="2" class="form-control" placeholder="ملاحظات إضافية (اختياري)">{{ $invoice->notes }}</textarea>
                    </div>
                </div>
            </div>

            {{-- كل ما بعد الرأس قابل للقفل بالمنطق (lockable) --}}
            <div class="lockable">

                {{-- ===== مكوّن نوع البند + اختيار الخدمة/العرض ===== --}}
                <div class="card-flat mb-3 p-3" style="border-radius: 14px;">

                    <div class="row gy-3">

                        {{-- نوع البند --}}
                        <div class="col-md-1">
                            <label class="section-title mb-1">نوع البند</label>

                            <div class="d-flex flex-column">
                                <div>
                                    <input type="radio" class="btn-check" name="current_type" id="type_service"
                                        value="service" checked>
                                    <label class="btn btn-outline-info w-100 py-1 small" for="type_service">
                                        <i class="fas fa-concierge-bell me-1"></i> خدمة
                                    </label>
                                </div>
                                <div>
                                    <input type="radio" class="btn-check" name="current_type" id="type_offer"
                                        value="offer">
                                    <label class="btn btn-outline-warning w-100 py-1 small" for="type_offer">
                                        <i class="fas fa-gift me-1"></i> عرض
                                    </label>
                                </div>
                            </div>
                        </div>

                        {{-- اختيار الخدمة أو العرض --}}
                        <div class="col-md-3">

                            {{-- خدمات مباشرة --}}
                            <div class="service-panel">
                                <label class="section-title mb-1">الخدمة</label>
                                <select id="current_service_id" class="form-select select2 form-select-sm">
                                    <option value="">اختر الخدمة</option>
                                    @foreach ($services as $s)
                                        @php
                                            $sName = is_array($s->name)
                                                ? $s->name['ar'] ?? ($s->name['en'] ?? reset($s->name))
                                                : $s->name;
                                        @endphp
                                        <option value="{{ $s->id }}" data-price="{{ $s->price }}">
                                            {{ $sName }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- عروض --}}
                            <div class="offer-panel d-none">
                                <label class="section-title mb-1">العرض</label>
                                <select id="current_offer_id" class="form-select select2 form-select-sm mb-2">
                                    <option value="">اختر العرض</option>
                                    @foreach ($offers as $o)
                                        @php
                                            $title = is_array($o->name)
                                                ? $o->name['ar'] ?? ($o->name['en'] ?? reset($o->name))
                                                : $o->name;
                                        @endphp
                                        <option value="{{ $o->id }}">{{ $title }}</option>
                                    @endforeach
                                </select>

                                <select id="current_offer_service_id" class="form-select select2 form-select-sm">
                                    <option value="">اختر خدمة من العرض</option>
                                </select>
                            </div>
                        </div>

                        {{-- السعر --}}
                        <div class="col-md-2">
                            <label class="section-title mb-1">السعر</label>
                            <input type="number" id="current_price" class="form-control text-center calc-box"
                                step="0.01" value="0">
                        </div>

                        {{-- الخصم --}}
                        <div class="col-md-1">
                            <label class="section-title mb-1">الخصم</label>
                            <input type="number" id="current_discount" class="calc-box form-control text-center"
                                step="0.01" value="0">
                        </div>

                        {{-- الضريبة --}}
                        <div class="col-md-2">
                            <label class="section-title mb-1">الضريبة</label>
                            <div id="preview_tax" class="calc-box text-warning fw-bold">0.00</div>
                        </div>

                        {{-- الإجمالي --}}
                        <div class="col-md-2">
                            <label class="section-title mb-1">الإجمالي</label>
                            <div id="preview_total" class="calc-box text-success fw-bold">0.00</div>
                        </div>

                        {{-- زر الإضافة --}}
                        <div class="col-md-1 text-center mt-4">
                            <button type="button" id="addItemBtn" class="btn btn-success text-center w-100">
                                <i class="fas fa-plus-circle"></i>
                            </button>
                        </div>

                    </div>
                </div>

                {{-- ===== جدول البنود ===== --}}
                <div class="card-flat mb-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div class="section-title mb-0">بنود الفاتورة</div>
                    </div>

                    {{-- طبقة قفل البنود حتى تعبئة الحقول العليا --}}
                    <div id="itemsLock"
                        class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center d-none">
                        <div class="lock-message text-center">
                            <div class="mb-2">
                                <i class="fas fa-lock fa-lg text-warning mb-2"></i>
                            </div>
                            <div class="fw-bold text-warning mb-1">
                                يرجى اختيار الفرع، العضو، مسؤل المبيعات وتاريخ الفاتورة أولاً
                            </div>
                            <div class="small text-light">
                                بعد إكمال البيانات بالأعلى يمكنك إضافة بنود الفاتورة.
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-dark table-invoice align-middle mb-0 text-center" id="itemsTable">
                            <thead>
                                <tr>
                                    <th style="width: 30%;">البند</th>
                                    <th style="width: 15%;">السعر</th>
                                    <th style="width: 15%;">الخصم</th>
                                    <th style="width: 15%;">الصافي</th>
                                    <th style="width: 15%;">الضريبة</th>
                                    <th style="width: 15%;">الإجمالي</th>
                                    <th style="width: 5%;"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($invoice->items as $idx => $i)
                                    @php
                                        $type = $i->type ?? 'service';
                                        $badgeClass = $type === 'offer' ? 'bg-warning text-dark' : 'bg-info text-dark';

                                        // اسم الخدمة / العرض
                                        if ($type === 'service') {
                                            $s = $i->service ?? null;
                                            if ($s) {
                                                $sName = is_array($s->name)
                                                    ? $s->name['ar'] ?? ($s->name['en'] ?? reset($s->name))
                                                    : $s->name;
                                                $desc = $sName;
                                            } else {
                                                $desc = $i->description;
                                            }
                                        } else {
                                            $offer = $i->offer ?? null;
                                            $svc = $i->offerService ?? ($i->service ?? null);

                                            $offerName = $offer
                                                ? (is_array($offer->name)
                                                    ? $offer->name['ar'] ?? ($offer->name['en'] ?? reset($offer->name))
                                                    : $offer->name)
                                                : 'عرض';

                                            $svcName = $svc
                                                ? (is_array($svc->name)
                                                    ? $svc->name['ar'] ?? ($svc->name['en'] ?? reset($svc->name))
                                                    : $svc->name)
                                                : 'خدمة';

                                            $desc = $offerName . ' - ' . $svcName;
                                        }

                                        $qty = $i->qty ?? 1;
                                        $rowPrice = $qty * $i->price;
                                        $taxable = max(0, $rowPrice - $i->discount);
                                    @endphp
                                    <tr data-index="{{ $idx }}">
                                        <td>
                                            <span class="badge badge-type {{ $badgeClass }}">
                                                {{ $type === 'offer' ? 'عرض' : 'خدمة' }}
                                            </span>
                                            <div class="small fw-bold mt-1">{{ $desc }}</div>

                                            <input type="hidden" name="items[{{ $idx }}][type]"
                                                value="{{ $type }}">
                                            <input type="hidden" name="items[{{ $idx }}][service_id]"
                                                value="{{ $i->service_id }}">
                                            <input type="hidden" name="items[{{ $idx }}][offer_id]"
                                                value="{{ $i->offer_id }}">
                                            <input type="hidden" name="items[{{ $idx }}][offer_service_id]"
                                                value="{{ $i->offer_service_id }}">
                                        </td>

                                        {{-- السعر --}}
                                        <td>
                                            <input type="number" step="0.01"
                                                class="form-control text-center price-input"
                                                name="items[{{ $idx }}][price]"
                                                value="{{ number_format($i->price, 2, '.', '') }}">
                                        </td>

                                        {{-- الخصم --}}
                                        <td>
                                            <input type="number" step="0.01"
                                                class="form-control text-center disc-input"
                                                name="items[{{ $idx }}][discount]"
                                                value="{{ number_format($i->discount, 2, '.', '') }}">
                                        </td>

                                        {{-- الصافي قبل الضريبة --}}
                                        <td class="text-info fw-bold after-discount-cell">
                                            {{ number_format($taxable, 2, '.', '') }}
                                        </td>

                                        {{-- الضريبة --}}
                                        <td class="text-warning fw-bold tax-cell">
                                            {{ number_format($i->tax, 2, '.', '') }}
                                        </td>

                                        {{-- الإجمالي --}}
                                        <td class="text-success fw-bold total-cell">
                                            {{ number_format($i->total, 2, '.', '') }}
                                        </td>

                                        {{-- حذف --}}
                                        <td>
                                            <button type="button" class="btn btn-sm btn-danger del-row">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                {{-- ===== ملخص الإجماليات ===== --}}
                <div class="row g-3 mb-4 text-center">

                    {{-- إجمالي الأسعار قبل الخصومات --}}
                    <div class="col-md-2">
                        <div class="summary-box">
                            <div class="section-title mb-2">إجمالي الأسعار</div>
                            <div id="sum_price" class="summary-value">0.00</div>
                        </div>
                    </div>

                    {{-- الخصم الإضافي --}}
                    <div class="col-md-2">
                        <div class="summary-box">
                            <div class="section-title">خصم إضافي</div>
                            <input type="number" name="extra_discount" id="extra_discount"
                                class="form-control text-center border-0 fw-bold text-danger"
                                value="{{ $extraDiscount ?? 0 }}" step="0.01" min="0">

                        </div>
                    </div>

                    {{-- إجمالي الخصومات (العادية + الإضافي) --}}
                    <div class="col-md-2">
                        <div class="summary-box">
                            <div class="section-title mb-2">إجمالي الخصومات</div>
                            <div id="sum_discount" class="summary-value text-danger">0.00</div>
                        </div>
                    </div>

                    {{-- صافى المبلغ قبل الضريبة بعد كل الخصومات --}}
                    <div class="col-md-2">
                        <div class="summary-box">
                            <div class="section-title mb-2">صافى المبلغ</div>
                            <div id="sum_after_discount" class="summary-value text-info">0.00</div>
                        </div>
                    </div>

                    {{-- إجمالي الضريبة --}}
                    <div class="col-md-2">
                        <div class="summary-box">
                            <div class="section-title mb-2">إجمالي الضريبة</div>
                            <div id="sum_tax" class="summary-value text-warning">0.00</div>
                        </div>
                    </div>

                    {{-- الصافي النهائي --}}
                    <div class="col-md-2">
                        <div class="summary-box">
                            <div class="section-title mb-2">الصافي المستحق</div>
                            <div id="sum_net" class="summary-value text-success">0.00</div>
                        </div>
                    </div>

                </div>

            </div> {{-- /lockable --}}

        </div>
    </form>

    {{-- 💳 مودال الدفع بالحجم الكامل --}}
    <div class="modal fade" id="paymentFullModal" tabindex="-1" aria-labelledby="paymentFullModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content bg-dark text-light">
                <div class="modal-header ">
                    <h5 class="modal-title">
                        <i class="fas fa-credit-card me-2 text-success"></i> إدارة طرق الدفع
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="container-fluid">

                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <button type="button" class="btn btn-outline-success" id="addPaymentBtn">
                                <i class="fas fa-plus"></i> إضافة طريقة دفع
                            </button>

                            <div class="fw-bold">
                                💰 المدفوع: <span id="paid_sum">0.00</span>
                                &nbsp;—&nbsp;
                                💳 المتبقي: <span id="remain_sum">0.00</span>
                            </div>
                        </div>

                        <table class="table table-darkish table-bordered text-center" id="paymentsTable">
                            <thead>
                                <tr>
                                    <th style="width: 40%;">طريقة الدفع</th>
                                    <th style="width: 40%;">المبلغ</th>
                                    <th style="width: 20%;">إجراء</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>

                        <div class="alert alert-secondary mt-4">
                            <strong>ملحوظة:</strong> يجب أن يساوي مجموع المبالغ
                            <span class="text-success fw-bold">الصافي المستحق بعد الضريبة</span>
                            لحفظ الفاتورة. لا يُسمح بحفظ الفاتورة عند وجود مبلغ متبقٍّ.
                        </div>
                    </div>
                </div>

                <div class="modal-footer ">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-arrow-right"></i> رجوع
                    </button>
                    <button type="button" class="btn btn-success" id="confirmPaymentsBtn">
                        <i class="fas fa-check"></i> حفظ الدفع
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/min/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment-hijri@2.1.2/moment-hijri.min.js"></script>

    <script>
        const toNum = (v) => Number(parseFloat(v || 0).toFixed(2)) || 0;
        const money = (v) => toNum(v).toFixed(2);

        // مدفوعات الفاتورة الحالية من الداتابيز
        const existingPayments = @php
            $p = is_array($invoice->payment_methods) ? $invoice->payment_methods : json_decode($invoice->payment_methods ?? '[]', true);
            echo json_encode($p ?: []);
        @endphp;

        let paymentConfirmed = false; // منع الحفظ قبل تأكيد الدفع الكامل

        $(document).ready(function() {
            $('.select2').select2({
                width: '100%'
            });

            // ================== التاريخ الهجري ==================
            function updateHijri() {
                const g = $('#greg_date').val();
                if (!g) return;
                $('#hijri_date').val(moment(g, 'YYYY-MM-DD').format('iD-iM-iYYYY'));
            }
            updateHijri();
            $('#greg_date').on('change', updateHijri);

            // ================== تحميل الأعضاء حسب الفرع ==================
            function loadMembersForBranch(branchId, selectedMemberId = null) {
                const $member = $('#member_id');
                $member.prop('disabled', true)
                    .empty()
                    .append('<option value="">جاري التحميل...</option>')
                    .trigger('change');

                // لو اختار "كل الفروع" → رجّع جميع الأعضاء
                if (branchId === "0") {
                    $.get("{{ url('/get-all-members') }}", function(rows) {
                        $member.empty().append('<option value="">اختر العضو</option>');
                        rows.forEach(m => {
                            $member.append(`<option value="${m.id}">${m.name}</option>`);
                        });
                        if (selectedMemberId) {
                            $member.val(selectedMemberId);
                        }
                        $member.prop('disabled', false).trigger('change');
                    });
                    return;
                }

                if (!branchId) {
                    $member.empty()
                        .append('<option value="">اختر الفرع أولاً</option>')
                        .prop('disabled', true)
                        .trigger('change');
                    return;
                }

                $.get("{{ url('/service-invoices/get-members') }}/" + branchId, function(rows) {
                    $member.empty().append('<option value="">اختر العضو</option>');
                    rows.forEach(m => {
                        $member.append(`<option value="${m.id}">${m.name}</option>`);
                    });
                    if (selectedMemberId) {
                        $member.val(selectedMemberId);
                    }
                    $member.prop('disabled', false).trigger('change');
                });
            }

            // تحميل الأعضاء مبدئياً حسب الفرع الحالي
            const initialBranchId = $('#branch_id').val();
            const initialMemberId = '{{ $invoice->member_id }}';
            if (initialBranchId) {
                loadMembersForBranch(initialBranchId, initialMemberId);
            }

            // ================== تحقق من الهيدر لقفل/فتح البنود ==================
            function isHeaderValid() {
                const branch = $('#branch_id').val();
                const member = $('#member_id').val();
                const provider = $('#provider_user_id').val();
                const dateG = $('#greg_date').val();
                return Boolean(branch && member && provider && dateG);
            }

            function lockAllSections() {
                $(".lockable").css({
                    "pointer-events": "none",
                    "opacity": "0.4"
                });
                $("#openPaymentBtn").prop("disabled", true);
            }

            function unlockAllSections() {
                $(".lockable").css({
                    "pointer-events": "auto",
                    "opacity": "1"
                });
                togglePayButton();
            }

            function validateHeaderAndToggleLock() {
                if (isHeaderValid()) {
                    $('#itemsLock').addClass('d-none');
                    $('#addItemBtn').prop('disabled', false);
                    unlockAllSections();
                } else {
                    $('#itemsLock').removeClass('d-none');
                    $('#addItemBtn').prop('disabled', true);
                    lockAllSections();
                }
            }

            $('#branch_id').on('change', function() {
                const id = $(this).val();
                loadMembersForBranch(id, null);
                validateHeaderAndToggleLock();
            });

            $('#member_id, #provider_user_id, #greg_date').on('change input', function() {
                validateHeaderAndToggleLock();
            });

            // بداية: هنفحص الهيدر، لو مكتمل نفتح البنود
            validateHeaderAndToggleLock();

            // ================== منطق اختيار نوع البند ==================
            function resetCurrentInputs(clearTypeOnly = false) {
                if (!clearTypeOnly) {
                    $('#current_service_id').val(null).trigger('change');
                    $('#current_offer_id').val(null).trigger('change');
                    $('#current_offer_service_id')
                        .empty()
                        .append('<option value="">اختر خدمة من العرض</option>')
                        .trigger('change');

                    $('#current_price').val(0);
                    $('#current_discount').val(0);
                    updatePreview();
                }
            }

            $('input[name="current_type"]').on('change', function() {
                const type = $('input[name="current_type"]:checked').val();
                if (type === 'service') {
                    $('.service-panel').removeClass('d-none');
                    $('.offer-panel').addClass('d-none');
                } else {
                    $('.service-panel').addClass('d-none');
                    $('.offer-panel').removeClass('d-none');
                }
                resetCurrentInputs();
            });

            // خدمات مباشرة => تحميل السعر
            $('#current_service_id').on('change', function() {
                const price = $(this).find(':selected').data('price') || 0;
                $('#current_price').val(money(price));
                updatePreview();
            });

            // عرض => تحميل خدمات العرض
            $('#current_offer_id').on('change', function() {
                const offerId = $(this).val();
                const $svcSel = $('#current_offer_service_id');

                $svcSel.empty().append('<option value="">اختر خدمة من العرض</option>');

                if (!offerId) {
                    updatePreview();
                    return;
                }

                $.get("{{ url('/service-invoices/get-offer-services') }}/" + offerId, function(items) {
                    (items || []).forEach(i => {
                        $svcSel.append(
                            `<option value="${i.id}" data-price="${i.price ?? 0}">
                                ${i.name}
                             </option>`
                        );
                    });
                    $svcSel.trigger('change');
                }).fail(function() {
                    $svcSel.empty()
                        .append('<option value="">تعذر تحميل خدمات العرض</option>')
                        .trigger('change');
                });
            });

            // خدمة من العرض => سعر
            $('#current_offer_service_id').on('change', function() {
                const price = $(this).find(':selected').data('price') || 0;
                $('#current_price').val(money(price));
                updatePreview();
            });

            // أي تغيير في السعر أو الخصم
            $('#current_price, #current_discount').on('input', function() {
                updatePreview();
            });

            // معاينة بند واحد (ضريبة + إجمالي)
            function updatePreview() {
                let qty = 1;
                let price = toNum($('#current_price').val());
                let disc = toNum($('#current_discount').val());

                const rowPrice = qty * price;
                if (disc > rowPrice) {
                    disc = rowPrice;
                    $('#current_discount').val(money(disc));
                }

                const taxable = Math.max(0, rowPrice - disc);
                const tax = taxable * 0.15;
                const total = taxable + tax;

                $('#preview_tax').text(money(tax));
                $('#preview_total').text(money(total));
            }
            updatePreview();

            // ================== إضافة البند إلى الجدول ==================
            let rowIndex = {{ $invoice->items->count() }};

            $('#addItemBtn').on('click', function() {
                if (!isHeaderValid()) {
                    alert('⚠️ يرجى تعبئة الفرع، العضو، مسؤل المبيعات وتاريخ الفاتورة أولاً.');
                    return;
                }

                const type = $('input[name="current_type"]:checked').val();
                let desc = '';
                let serviceId = null;
                let offerId = null;
                let offerServiceId = null;

                if (type === 'service') {
                    serviceId = $('#current_service_id').val();
                    const serviceText = $('#current_service_id').find(':selected').text() || '';
                    if (!serviceId) {
                        alert('⚠️ يرجى اختيار الخدمة.');
                        return;
                    }
                    desc = serviceText.trim();
                } else {
                    offerId = $('#current_offer_id').val();
                    offerServiceId = $('#current_offer_service_id').val();
                    const offerText = $('#current_offer_id').find(':selected').text() || '';
                    const svcText = $('#current_offer_service_id').find(':selected').text() || '';

                    if (!offerId) {
                        alert('⚠️ يرجى اختيار العرض.');
                        return;
                    }
                    if (!offerServiceId) {
                        alert('⚠️ يرجى اختيار خدمة من العرض.');
                        return;
                    }

                    desc = (offerText.trim() || 'عرض') + ' - ' + (svcText.trim() || 'خدمة');
                }

                let qty = 1;
                let price = toNum($('#current_price').val());
                let disc = toNum($('#current_discount').val());

                const rowPrice = qty * price;
                if (disc > rowPrice) disc = rowPrice;

                const taxable = Math.max(0, rowPrice - disc);
                const tax = taxable * 0.15;
                const total = taxable + tax;

                const typeLabel = (type === 'service') ? 'خدمة' : 'عرض';
                const typeBadgeClass = (type === 'service') ? 'bg-info text-dark' : 'bg-warning text-dark';

                const rowHtml = `
                    <tr data-index="${rowIndex}">
                        <td>
                            <span class="badge badge-type ${typeBadgeClass}">${typeLabel}</span>
                            <div class="small fw-bold mt-1">${desc}</div>

                            <input type="hidden" name="items[${rowIndex}][type]" value="${type}">
                            <input type="hidden" name="items[${rowIndex}][service_id]" value="${serviceId ?? ''}">
                            <input type="hidden" name="items[${rowIndex}][offer_id]" value="${offerId ?? ''}">
                            <input type="hidden" name="items[${rowIndex}][offer_service_id]" value="${offerServiceId ?? ''}">
                        </td>

                        <!-- السعر -->
                        <td>
                            <input type="number" step="0.01"
                                   class="form-control text-center price-input"
                                   name="items[${rowIndex}][price]"
                                   value="${money(price)}">
                        </td>

                        <!-- الخصم -->
                        <td>
                            <input type="number" step="0.01"
                                   class="form-control text-center disc-input"
                                   name="items[${rowIndex}][discount]"
                                   value="${money(disc)}">
                        </td>

                        <!-- الصافي قبل الضريبة -->
                        <td class="text-info fw-bold after-discount-cell">
                            ${money(taxable)}
                        </td>

                        <!-- الضريبة -->
                        <td class="text-warning fw-bold tax-cell">
                            ${money(tax)}
                        </td>

                        <!-- الإجمالي -->
                        <td class="text-success fw-bold total-cell">
                            ${money(total)}
                        </td>

                        <!-- زر الحذف -->
                        <td>
                            <button type="button" class="btn btn-sm btn-danger del-row">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>`;

                $('#itemsTable tbody').append(rowHtml);
                rowIndex++;
                recalcAll();
                togglePayButton();
            });

            // ================== حسابات الجدول ==================
            function recalcRow($row) {
                let qty = 1; // الكمية ثابتة = 1
                let price = toNum($row.find('.price-input').val());
                let disc = toNum($row.find('.disc-input').val());

                let rowPrice = qty * price;

                if (disc > rowPrice) {
                    disc = rowPrice;
                    $row.find('.disc-input').val(money(disc));
                }

                let taxable = rowPrice - disc; // الصافي قبل الضريبة
                let tax = taxable * 0.15;
                let total = taxable + tax;

                // تحديث الأعمدة الخاصة بالصف الواحد
                $row.find('.after-discount-cell').text(money(taxable));
                $row.find('.tax-cell').text(money(tax));
                $row.find('.total-cell').text(money(total));
            }

            function recalcAll() {
                let sumPrice = 0; // إجمالي السعر قبل الخصومات
                let sumDisc = 0; // خصومات الصفوف فقط
                let sumTax = 0; // إجمالي الضريبة بدون خصم إضافي
                let sumNet = 0; // الصافي النهائي بدون خصم إضافي

                $('#itemsTable tbody tr').each(function() {
                    let qty = 1;
                    let price = toNum($(this).find('.price-input').val());
                    let disc = toNum($(this).find('.disc-input').val());

                    let rowPrice = qty * price;
                    if (disc > rowPrice) disc = rowPrice;

                    let taxable = rowPrice - disc;
                    let tax = taxable * 0.15;
                    let total = taxable + tax;

                    // تحديث الصف
                    $(this).find('.after-discount-cell').text(money(taxable));
                    $(this).find('.tax-cell').text(money(tax));
                    $(this).find('.total-cell').text(money(total));

                    sumPrice += rowPrice;
                    sumDisc += disc;
                    sumTax += tax;
                    sumNet += total;
                });

                // ===== الخصم الإضافي =====
                let extraDisc = toNum($('#extra_discount').val());
                if (extraDisc < 0) extraDisc = 0;

                // لا يتجاوز الصافي قبل الضريبة
                let maxExtra = sumPrice - sumDisc;
                if (extraDisc > maxExtra) {
                    extraDisc = maxExtra;
                    $('#extra_discount').val(money(extraDisc));
                }

                // صافى المبلغ قبل الضريبة (بعد جميع الخصومات)
                let afterDiscount = maxExtra - extraDisc;

                // الضريبة بعد الخصم الإضافي
                let taxAfterExtra = afterDiscount * 0.15;

                // الصافي النهائي
                let finalNet = afterDiscount + taxAfterExtra;

                // ====== تحديث الواجهة ======
                $('#sum_price').text(money(sumPrice));
                $('#sum_discount').text(money(sumDisc + extraDisc));
                $('#sum_after_discount').text(money(afterDiscount));
                $('#sum_tax').text(money(taxAfterExtra));
                $('#sum_net').text(money(finalNet));

                togglePayButton();
            }

            // تشغيل أولى للحسابات بناءً على بيانات الداتابيز
            recalcAll();

            // === الأحداث على الصفوف ===
            $(document).on('input', '.price-input, .disc-input', function() {
                recalcRow($(this).closest('tr'));
                recalcAll();
            });

            $(document).on('click', '.del-row', function() {
                $(this).closest('tr').remove();
                recalcAll();
            });

            $('#extra_discount').on('input', function() {
                setTimeout(() => {
                    recalcAll();
                }, 300);
            });

            // ================== منطق تفعيل زر السداد ==================
            function togglePayButton() {
                const rows = $('#itemsTable tbody tr').length;
                const net = toNum($('#sum_net').text());
                const canPay = (rows > 0 && net > 0 && isHeaderValid());
                $('#openPaymentBtn').prop('disabled', !canPay);
            }

            togglePayButton();

            // ================== منطق المودال الكامل للدفع ==================
            function canOpenPayment() {
                const branch = $("#branch_id").val();
                const member = $("#member_id").val();
                const provider = $("#provider_user_id").val();
                const rows = $('#itemsTable tbody tr').length;
                const total = toNum($("#sum_net").text());

                if (!branch) return {
                    ok: false,
                    msg: "يجب اختيار الفرع أولاً"
                };
                if (!member) return {
                    ok: false,
                    msg: "يجب اختيار العضو"
                };
                if (!provider) return {
                    ok: false,
                    msg: "يجب اختيار مسؤل المبيعات"
                };
                if (rows === 0) return {
                    ok: false,
                    msg: "يجب إضافة بنود للفاتورة أولاً"
                };
                if (total <= 0) return {
                    ok: false,
                    msg: "لا يوجد مبلغ مستحق — تحقق من البنود والمبالغ"
                };

                return {
                    ok: true
                };
            }

            // عند فتح المودال
            $('#paymentFullModal').on('show.bs.modal', function(e) {
                const check = canOpenPayment();
                if (!check.ok) {
                    e.preventDefault();
                    alert("⚠️ " + check.msg);
                    return false;
                }

                // إعادة ضبط جدول المدفوعات
                $('#paymentsTable tbody').empty();

                const net = toNum($('#sum_net').text());
                let totalPaid = 0;

                // تحميل المدفوعات القديمة
                if (existingPayments && Array.isArray(existingPayments) && existingPayments.length > 0) {
                    existingPayments.forEach(p => {
                        const amount = toNum(p.amount);
                        const method = p.method || '';

                        if (amount <= 0) return;

                        const row = `
                            <tr>
                                <td>
                                    <select class="form-select payment-method">
                                        <option value="">اختر طريقة الدفع</option>
                                        <option value="cash" ${method === 'cash' ? 'selected' : ''}>كاش</option>
                                        <option value="bank" ${method === 'bank' ? 'selected' : ''}>تحويل بنكي</option>
                                        <option value="card" ${method === 'card' ? 'selected' : ''}>بطاقة</option>
                                        <option value="wallet" ${method === 'wallet' ? 'selected' : ''}>محفظة</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="number" class="form-control text-center payment-amount"
                                           step="0.01" min="0" value="${money(amount)}">
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-danger del-payment-row">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        `;
                        $('#paymentsTable tbody').append(row);
                        totalPaid += amount;
                    });
                }

                $('#paid_sum').text(money(totalPaid));
                const remaining = Math.max(0, net - totalPaid);
                $('#remain_sum').text(money(remaining));
            });

            // إضافة صف دفع جديد
            $('#addPaymentBtn').on('click', function() {
                const row = `
                    <tr>
                        <td>
                            <select class="form-select payment-method">
                                <option value="">اختر طريقة الدفع</option>
                                <option value="cash">كاش</option>
                                <option value="bank">تحويل بنكي</option>
                                <option value="card">بطاقة</option>
                                <option value="wallet">محفظة</option>
                            </select>
                        </td>
                        <td>
                            <input type="number" class="form-control text-center payment-amount"
                                   step="0.01" min="0" placeholder="المبلغ">
                        </td>
                        <td>
                            <button type="button" class="btn btn-sm btn-danger del-payment-row">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
                $('#paymentsTable tbody').append(row);
            });

            // حذف دفعة
            $(document).on('click', '.del-payment-row', function() {
                $(this).closest('tr').remove();
                recalcPaymentsSummary();
            });

            // إعادة حساب إجمالي المدفوع والمتبقي
            function recalcPaymentsSummary() {
                const net = toNum($('#sum_net').text());
                let totalPaid = 0;

                $('#paymentsTable tbody tr').each(function() {
                    const amount = toNum($(this).find('.payment-amount').val());
                    if (amount > 0) {
                        totalPaid += amount;
                    }
                });

                $('#paid_sum').text(money(totalPaid));
                const remaining = Math.max(0, net - totalPaid);
                $('#remain_sum').text(money(remaining));
            }

            $(document).on('input', '.payment-amount', function() {
                recalcPaymentsSummary();
            });

            // تأكيد الدفع الكامل
            $('#confirmPaymentsBtn').on('click', function() {
                const net = toNum($('#sum_net').text());
                if (net <= 0) {
                    alert('⚠️ لا يوجد صافي مستحق للحفظ.');
                    return;
                }

                let totalPaid = 0;
                const rowsData = [];

                let invalidRow = false;
                $('#paymentsTable tbody tr').each(function() {
                    const method = $(this).find('.payment-method').val();
                    const amount = toNum($(this).find('.payment-amount').val());

                    if (amount > 0) {
                        if (!method) {
                            invalidRow = true;
                            return false;
                        }
                        rowsData.push({
                            method,
                            amount
                        });
                        totalPaid += amount;
                    }
                });

                if (invalidRow) {
                    alert('⚠️ يوجد مبلغ بدون اختيار طريقة دفع.');
                    return;
                }

                if (rowsData.length === 0 || totalPaid <= 0) {
                    alert('⚠️ لم يتم إدخال أي دفعات صحيحة.');
                    return;
                }

                const diff = Math.abs(totalPaid - net);
                if (diff > 0.01) {
                    alert('⚠️ يجب أن يساوي مجموع المدفوع الصافي المستحق بالضبط. المتبقي الحالي: ' +
                        money(net - totalPaid));
                    return;
                }

                // مسح الحقول المخفية القديمة
                $('.payment-hidden-row').remove();

                // إنشاء الحقول المخفية للدفعات
                const $form = $('#invoiceForm');
                rowsData.forEach((row, idx) => {
                    $form.append(
                        `<input type="hidden" class="payment-hidden-row"
                                name="payments[${idx}][method]" value="${row.method}">`
                    );
                    $form.append(
                        `<input type="hidden" class="payment-hidden-row"
                                name="payments[${idx}][amount]" value="${money(row.amount)}">`
                    );
                });

                // تم تأكيد الدفع بالكامل
                paymentConfirmed = true;
                $('#saveInvoiceBtn').prop('disabled', false);
                $('#paymentFullModal').modal('hide');

                alert('✅ تم حفظ بيانات السداد بنجاح. يمكنك الآن حفظ الفاتورة.');
            });

            // منع حفظ الفاتورة قبل تأكيد الدفع بالكامل
            $('#invoiceForm').on('submit', function(e) {
                if (!paymentConfirmed) {
                    e.preventDefault();
                    alert('⚠️ لا يمكن حفظ الفاتورة قبل تأكيد سداد المبلغ بالكامل من خلال إدارة طرق الدفع.');
                }
            });
        });
    </script>
@endsection
