@extends('layouts.master')
@section('title', 'عرض فاتورة خدمات')

@section('content')
    <div class="container-fluid">

        {{-- HEADER --}}
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3 class="fw-bold text-light">
                <i class="fas fa-file-invoice me-2 text-info"></i>
                عرض فاتورة رقم {{ $invoice->document_no }}
            </h3>

            <div>
                <a href="{{ route('service-invoices.print', $invoice->id) }}" class="btn btn-warning" target="_blank">
                    <i class="fas fa-print"></i> طباعة
                </a>

                <a href="{{ route('service-invoices.edit', $invoice->id) }}" class="btn btn-primary">
                    <i class="fas fa-edit"></i> تعديل
                </a>
            </div>
        </div>

        {{-- BASIC INFO --}}
        <div class="card-flat mb-3">
            <h5 class="mb-3 section-title">تفاصيل الفاتورة</h5>

            <div class="row g-3">

                <div class="col-md-4">الفرع:
                    <strong>{{ $invoice->branch->name ?? '—' }}</strong>
                </div>

                <div class="col-md-4">العضو:
                    <strong>{{ $invoice->member->name ?? '—' }}</strong>
                </div>

                <div class="col-md-4">مقدم الخدمة:
                    <strong>{{ $invoice->provider->name ?? '—' }}</strong>
                </div>

                <div class="col-md-4">
                    تاريخ ميلادي:
                    <strong>{{ \Carbon\Carbon::parse($invoice->greg_date)->format('Y-m-d') }}</strong>
                </div>

                <div class="col-md-4">
                    تاريخ هجري:
                    <strong>{{ $invoice->hijri_date }}</strong>
                </div>

                <div class="col-md-12 mt-3">
                    <strong>ملاحظات:</strong> {{ $invoice->notes ?: '—' }}
                </div>
            </div>
        </div>

        {{-- ITEMS TABLE --}}
        <div class="card-flat mb-3">
            <h5 class="section-title mb-2">البنود</h5>

            <table class="table table-dark table-bordered text-center align-middle">
                <thead>
                    <tr>
                        <th>الوصف</th>
                        <th>الكمية</th>
                        <th>السعر</th>
                        <th>الخصم</th>
                        <th>الصافي</th>
                        <th>الضريبة (15%)</th>
                        <th>الإجمالي</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($invoice->items as $item)
                        @php
                            $net = $item->price - $item->discount;
                        @endphp

                        <tr>
                            {{-- ★★★ هنا تعديل الوصف --}}
                            <td>{{ $item->description }}</td>

                            <td>{{ $item->qty }}</td>
                            <td>{{ number_format($item->price, 2) }}</td>
                            <td>{{ number_format($item->discount, 2) }}</td>

                            <td class="text-info fw-bold">
                                {{ number_format($net, 2) }}
                            </td>

                            <td>{{ number_format($item->tax, 2) }}</td>

                            <td class="text-success fw-bold">
                                {{ number_format($item->total, 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>


        {{-- PAYMENT METHODS --}}
        @php
            $payments = is_array($invoice->payment_methods)
                ? $invoice->payment_methods
                : json_decode($invoice->payment_methods, true);
        @endphp

        @if (!empty($payments))
            <div class="card-flat mb-3">
                <h5 class="section-title mb-2">تفاصيل الدفع</h5>

                <table class="table table-dark table-bordered text-center align-middle">
                    <thead>
                        <tr>
                            <th>طريقة الدفع</th>
                            <th>المبلغ</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($payments as $p)
                            <tr>
                                <td>
                                    @switch($p['method'])
                                        @case('cash')
                                            كاش
                                        @break

                                        @case('bank')
                                            تحويل بنكي
                                        @break

                                        @case('card')
                                            بطاقة
                                        @break

                                        @case('wallet')
                                            محفظة
                                        @break

                                        @default
                                            —
                                    @endswitch
                                </td>
                                <td>{{ number_format($p['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif


        {{-- TOTALS --}}
        <div class="row g-3">

            <div class="col-md-3">
                <div class="card-flat">
                    إجمالي الأسعار:
                    <strong>{{ number_format($invoice->total_price, 2) }}</strong>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card-flat">
                    إجمالي الخصومات:
                    <strong class="text-danger">{{ number_format($invoice->total_discount, 2) }}</strong>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card-flat">
                    إجمالي الضريبة:
                    <strong class="text-warning">{{ number_format($invoice->total_tax, 2) }}</strong>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card-flat">
                    الصافي المستحق:
                    <strong class="text-success">{{ number_format($invoice->total_net, 2) }}</strong>
                </div>
            </div>

        </div>

    </div>
@endsection
