{{-- resources/views/admin/services/show.blade.php --}}
@extends('layouts.master')

@section('title', 'عرض خدمة')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('css')
    <style>
        .hero {
            background: linear-gradient(135deg, #0ea5b6 0%, #1e293b 60%, #0b1220 100%);
            border-radius: 18px;
            padding: 20px 20px 16px;
            color: #fff;
            position: relative;
            overflow: hidden;
        }

        .hero .title {
            font-size: 1.35rem;
            font-weight: 800;
        }

        .chip {
            display: inline-flex;
            align-items: center;
            gap: .35rem;
            padding: .25rem .6rem;
            border-radius: 999px;
            background: rgba(255, 255, 255, .09);
            color: #fff;
            border: 1px solid rgba(255, 255, 255, .15);
            font-size: .85rem;
        }

        .meta-card {
            background: #0f1e2b;
            border: 1px solid rgba(255, 255, 255, .08);
            border-radius: 14px;
            padding: 14px;
            height: 100%;
        }

        .meta-title {
            font-size: .95rem;
            opacity: .85;
            margin-bottom: .35rem
        }

        .meta-value {
            font-size: 1.1rem;
            font-weight: 700
        }

        .section-title {
            font-weight: 800;
            margin-bottom: 10px;
        }

        .badge-day {
            background: #0ea5b6;
            border: none;
        }

        .chip-branch {
            background: rgba(255, 255, 255, .06);
            color: #e5e7eb;
            border: 1px solid rgba(255, 255, 255, .1);
            padding: .35rem .6rem;
            border-radius: 999px;
            display: inline-flex;
            align-items: center;
            gap: .4rem;
        }

        .settings-card {
            background: #0f1e2b;
            border: 1px solid rgba(255, 255, 255, .08);
            border-radius: 14px;
            padding: 14px;
            height: 100%;
        }

        .settings-card .icon {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #102231;
            color: #0ea5b6;
            margin-inline-end: 8px;
        }

        .list-unstyled li+li {
            margin-top: .3rem
        }

        .muted {
            color: #94a3b8
        }

        .actions {
            position: absolute;
            inset-inline-end: 12px;
            top: 12px
        }
    </style>
@endsection

@section('content')
    @php
        $unitMap = ['days' => 'يوم', 'months' => 'شهر', 'years' => 'سنة'];
        $dayMap = [
            'sat' => 'السبت',
            'sun' => 'الأحد',
            'mon' => 'الإثنين',
            'tue' => 'الثلاثاء',
            'wed' => 'الأربعاء',
            'thu' => 'الخميس',
            'fri' => 'الجمعة',
        ];

        $fmtTime = function ($t) {
            if (!$t) {
                return '—';
            }
            $p = explode(':', $t);
            return sprintf('%02d:%02d', (int) ($p[0] ?? 0), (int) ($p[1] ?? 0));
        };
        $durText = $service->duration_value . ' ' . ($unitMap[$service->duration_unit] ?? $service->duration_unit);

        $settings = $service->settings ?? [];
        $on = function ($arr) {
            return is_array($arr) &&
                ((isset($arr['enabled']) && (string) $arr['enabled'] === '1') || $arr['enabled'] === true);
        };

        $pause = $settings['pause'] ?? null;
        $transfer = $settings['transfer'] ?? null;
        $renew = $settings['renew'] ?? null;
        $refund = $settings['refund'] ?? null;
        $days = $settings['days'] ?? null;
    @endphp

    <div class="hero mb-3">
        <div class="actions d-flex gap-2">
            <a href="{{ route('services.edit', $service) }}" class="btn btn-warning btn-sm"><i class="fas fa-edit me-1"></i>
                تعديل</a>
            <a href="{{ route('services.index') }}" class="btn btn-secondary btn-sm">رجوع</a>
        </div>

        <div class="title mb-2">{{ $service->getTranslation('name', app()->getLocale()) }}</div>
        <div class="d-flex flex-wrap gap-2">
            <span class="chip"><i class="fas fa-stream"></i>
                {{ $service->type?->getTranslation('name', app()->getLocale()) ?? '—' }}</span>
            <span class="chip"><i class="fas fa-layer-group"></i>
                {{ $service->category?->getTranslation('name', app()->getLocale()) ?? '—' }}</span>
            <span class="chip">{!! $service->active ? '<i class="fas fa-check-circle"></i> نشط' : '<i class="fas fa-minus-circle"></i> غير نشط' !!}</span>
        </div>
    </div>

    <div class="row g-3">
        {{-- كروت سريعة --}}
        <div class="col-md-3">
            <div class="meta-card">
                <div class="meta-title"><i class="fas fa-tags me-1 text-info"></i> السعر</div>
                <div class="meta-value">{{ number_format((float) $service->price, 2) }}</div>
                @if ($service->discount_price)
                    <div class="muted">خصم: {{ number_format((float) $service->discount_price, 2) }}</div>
                @endif
            </div>
        </div>
        <div class="col-md-3">
            <div class="meta-card">
                <div class="meta-title"><i class="far fa-clock me-1 text-info"></i> المدة</div>
                <div class="meta-value">{{ $durText }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="meta-card">
                <div class="meta-title"><i class="fas fa-hourglass-start me-1 text-info"></i> وقت البدء</div>
                <div class="meta-value">{{ $fmtTime($service->start_time) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="meta-card">
                <div class="meta-title"><i class="fas fa-hourglass-end me-1 text-info"></i> وقت الانتهاء</div>
                <div class="meta-value">{{ $fmtTime($service->end_time) }}</div>
            </div>
        </div>

        {{-- الفروع المقدِّمة / المباعة --}}
        <div class="col-lg-6">
            <div class="meta-card h-100">
                <div class="section-title"><i class="fas fa-store me-2 text-info"></i> الفروع المقدِّمة</div>
                @if ($service->providedBranches->count())
                    <div class="d-flex flex-wrap gap-2">
                        @foreach ($service->providedBranches as $b)
                            <span class="chip-branch"><i
                                    class="fas fa-store-alt"></i>{{ $b->getTranslation('name', app()->getLocale()) }}</span>
                        @endforeach
                    </div>
                @else
                    <div class="muted">لا توجد فروع مقدِّمة.</div>
                @endif
            </div>
        </div>
        <div class="col-lg-6">
            <div class="meta-card h-100">
                <div class="section-title"><i class="fas fa-cash-register me-2 text-info"></i> الفروع المباعة</div>
                @if ($service->soldBranches->count())
                    <div class="d-flex flex-wrap gap-2">
                        @foreach ($service->soldBranches as $b)
                            <span class="chip-branch"><i
                                    class="fas fa-store"></i>{{ $b->getTranslation('name', app()->getLocale()) }}</span>
                        @endforeach
                    </div>
                @else
                    <div class="muted">لا توجد فروع مباعة.</div>
                @endif
            </div>
        </div>

        {{-- الملاحظات --}}
        <div class="col-12">
            <div class="meta-card">
                <div class="section-title"><i class="fas fa-sticky-note me-2 text-info"></i> الملاحظات</div>
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="muted mb-1">العربية:</div>
                        <div>{{ $service->getTranslation('notes', 'ar') ?: '—' }}</div>
                    </div>
                    <div class="col-md-6">
                        <div class="muted mb-1">English:</div>
                        <div>{{ $service->getTranslation('notes', 'en') ?: '—' }}</div>
                    </div>
                </div>
            </div>
        </div>

        {{-- الإعدادات --}}
        <div class="col-12">
            <div class="section-title"><i class="fas fa-sliders-h me-2 text-info"></i> الإعدادات</div>
        </div>

        {{-- إيقاف --}}
        <div class="col-xl-4 col-md-6">
            <div class="settings-card h-100">
                <div class="d-flex align-items-center mb-2">
                    <div class="icon"><i class="fas fa-pause-circle"></i></div>
                    <div class="fw-bold">إمكانية الإيقاف</div>
                    <div class="ms-auto">{!! $on($pause)
                        ? '<span class="badge bg-success">مفعّل</span>'
                        : '<span class="badge bg-secondary">غير مفعّل</span>' !!}</div>
                </div>
                @if ($on($pause))
                    <ul class="list-unstyled mb-0">
                        <li>عدد المرات: <b>{{ $pause['max_times'] ?? '—' }}</b></li>
                        <li>أقصى مدة: <b>{{ $pause['max_duration_value'] ?? '—' }}</b>
                            {{ $unitMap[$pause['max_duration_unit'] ?? 'days'] ?? 'يوم' }}</li>
                    </ul>
                @else
                    <div class="muted">غير مفعّل.</div>
                @endif
            </div>
        </div>

        {{-- تنازل --}}
        <div class="col-xl-4 col-md-6">
            <div class="settings-card h-100">
                <div class="d-flex align-items-center mb-2">
                    <div class="icon"><i class="fas fa-people-arrows"></i></div>
                    <div class="fw-bold">إمكانية التنازل</div>
                    <div class="ms-auto">{!! $on($transfer)
                        ? '<span class="badge bg-success">مفعّل</span>'
                        : '<span class="badge bg-secondary">غير مفعّل</span>' !!}</div>
                </div>
                @if ($on($transfer))
                    <ul class="list-unstyled mb-0">
                        <li>أقل مدة: <b>{{ $transfer['min_duration_value'] ?? '—' }}</b>
                            {{ $unitMap[$transfer['min_duration_unit'] ?? 'days'] ?? 'يوم' }}</li>
                        <li>رسوم التنازل:
                            <b>{{ isset($transfer['fee']) ? number_format((float) $transfer['fee'], 2) : '—' }}</b></li>
                    </ul>
                @else
                    <div class="muted">غير مفعّل.</div>
                @endif
            </div>
        </div>

        {{-- تجديد --}}
        <div class="col-xl-4 col-md-6">
            <div class="settings-card h-100">
                <div class="d-flex align-items-center mb-2">
                    <div class="icon"><i class="fas fa-redo-alt"></i></div>
                    <div class="fw-bold">إمكانية التجديد</div>
                    <div class="ms-auto">{!! $on($renew)
                        ? '<span class="badge bg-success">مفعّل</span>'
                        : '<span class="badge bg-secondary">غير مفعّل</span>' !!}</div>
                </div>
                @if ($on($renew))
                    <ul class="list-unstyled mb-0">
                        <li>خدمة التجديد:
                            <b>
                                @php
                                    $renewService = isset($renew['with_service_id'])
                                        ? \App\Models\Service::find($renew['with_service_id'])
                                        : null;
                                @endphp
                                {{ $renewService?->getTranslation('name', app()->getLocale()) ?? '—' }}
                            </b>
                        </li>
                        <li>مدة إضافية: <b>{{ $renew['extra_duration_value'] ?? '—' }}</b>
                            {{ $unitMap[$renew['extra_duration_unit'] ?? 'days'] ?? 'يوم' }}</li>
                        <li>أقصى مدة: <b>{{ $renew['max_duration_value'] ?? '—' }}</b>
                            {{ $unitMap[$renew['max_duration_unit'] ?? 'days'] ?? 'يوم' }}</li>
                    </ul>
                @else
                    <div class="muted">غير مفعّل.</div>
                @endif
            </div>
        </div>

        {{-- استرجاع --}}
        <div class="col-xl-6 col-md-6">
            <div class="settings-card h-100">
                <div class="d-flex align-items-center mb-2">
                    <div class="icon"><i class="fas fa-undo-alt"></i></div>
                    <div class="fw-bold">إمكانية الاسترجاع</div>
                    <div class="ms-auto">{!! $on($refund)
                        ? '<span class="badge bg-success">مفعّل</span>'
                        : '<span class="badge bg-secondary">غير مفعّل</span>' !!}</div>
                </div>
                @if ($on($refund))
                    @php
                        $methodMap = ['money' => 'مالي', 'points' => 'نقاط', 'exchange' => 'استبدال بخدمة'];
                    @endphp
                    <ul class="list-unstyled mb-0">
                        <li>الطريقة: <b>{{ $methodMap[$refund['method'] ?? 'money'] ?? '—' }}</b></li>
                        @if (($refund['method'] ?? null) === 'exchange')
                            @php $exS = isset($refund['exchange_service_id']) ? \App\Models\Service::find($refund['exchange_service_id']) : null; @endphp
                            <li>الخدمة البديلة: <b>{{ $exS?->getTranslation('name', app()->getLocale()) ?? '—' }}</b></li>
                        @endif
                    </ul>
                @else
                    <div class="muted">غير مفعّل.</div>
                @endif
            </div>
        </div>

        {{-- أيام محددة --}}
        <div class="col-xl-6 col-md-6">
            <div class="settings-card h-100">
                <div class="d-flex align-items-center mb-2">
                    <div class="icon"><i class="fas fa-calendar-week"></i></div>
                    <div class="fw-bold">الخدمة محددة بأيام</div>
                    <div class="ms-auto">{!! $on($days)
                        ? '<span class="badge bg-success">مفعّل</span>'
                        : '<span class="badge bg-secondary">غير مفعّل</span>' !!}</div>
                </div>
                @if ($on($days) && !empty($days['values']))
                    <div class="d-flex flex-wrap gap-2">
                        @foreach ($days['values'] as $d)
                            <span class="badge badge-day">{{ $dayMap[$d] ?? $d }}</span>
                        @endforeach
                    </div>
                @else
                    <div class="muted">غير مفعّل.</div>
                @endif
            </div>
        </div>

    </div>
@endsection
