@extends('layouts.master')

@section('title', 'أنواع الخدمات')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        #st-table th,
        #st-table td {
            text-align: center;
            vertical-align: middle;
        }

        .dataTables_processing {
            background: none !important;
            color: teal !important;
            font-weight: bold;
        }

        #st-table td .btn {
            width: auto !important;
            padding: .25rem .5rem !important;
        }

        /* Glassy modals */
        .glass {
            background: rgba(255, 255, 255, .06);
            border: 1px solid rgba(255, 255, 255, .08);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 14px;
        }

        .modal .form-label {
            font-weight: 600;
        }

        .is-invalid+.invalid-feedback {
            display: block;
        }
    </style>
@endsection

@section('btn')
    <button class="btn btn-outline-success open-create" type="button">
        <i class="fas fa-plus-circle mx-2"></i> إضافة نوع خدمة
    </button>
@endsection

@section('content')
    <div class="row">
        <div class="col-xl-12">
            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="st-table" style="width:100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>الاسم</th>
                            <th>الحالة</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    {{-- ============ Modal: Create / Edit ============ --}}
    <div class="modal fade" id="typeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-fullscreen-md-down">
            <div class="modal-content glass">
                <div class="modal-header">
                    <h5 class="modal-title" id="typeModalTitle">إضافة نوع خدمة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>

                <form id="typeForm">
                    @csrf
                    <input type="hidden" id="record_id" name="record_id" value="">
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">الاسم (en) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name[en]" id="name_en" required>
                                <div class="invalid-feedback"></div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">الاسم (ar) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name[ar]" id="name_ar" required>
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">الوصف (en)</label>
                                <textarea class="form-control" name="description[en]" id="desc_en" rows="3"></textarea>
                                <div class="invalid-feedback"></div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">الوصف (ar)</label>
                                <textarea class="form-control" name="description[ar]" id="desc_ar" rows="3"></textarea>
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">الحالة <span class="text-danger">*</span></label>
                                <select class="form-select" name="active" id="active" required>
                                    <option value="1">نشط</option>
                                    <option value="0">غير نشط</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إغلاق</button>
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-save me-2"></i><span id="saveBtnText">حفظ</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- ============ Modal: Show ============ --}}
    <div class="modal fade" id="showModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-fullscreen-md-down">
            <div class="modal-content glass">
                <div class="modal-header">
                    <h5 class="modal-title">عرض نوع خدمة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="fw-bold mb-1">الاسم (ar)</div>
                            <div id="show_name_ar">—</div>
                        </div>
                        <div class="col-md-6">
                            <div class="fw-bold mb-1">الاسم (en)</div>
                            <div id="show_name_en">—</div>
                        </div>
                        <div class="col-md-6">
                            <div class="fw-bold mb-1">الوصف (ar)</div>
                            <div id="show_desc_ar">—</div>
                        </div>
                        <div class="col-md-6">
                            <div class="fw-bold mb-1">الوصف (en)</div>
                            <div id="show_desc_en">—</div>
                        </div>
                        <div class="col-md-4">
                            <div class="fw-bold mb-1">الحالة</div>
                            <div id="show_active">—</div>
                        </div>
                        <div class="col-md-4">
                            <div class="fw-bold mb-1">أُنشئ في</div>
                            <div id="show_created_at">—</div>
                        </div>
                        <div class="col-md-4">
                            <div class="fw-bold mb-1">آخر تحديث</div>
                            <div id="show_updated_at">—</div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إغلاق</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {

            // ====== Routes base ======
            window.ST_ROUTES = {
                index: "{{ route('service-types.index') }}", // DataTables source
                store: "{{ route('service-types.store') }}",
                base: "{{ url('service-types') }}", // show/update => /service-types/{id}
                token: "{{ csrf_token() }}"
            };

            // ====== DataTable ======
            const table = $('#st-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: ST_ROUTES.index,
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'translated_name',
                        name: 'name'
                    },
                    {
                        data: 'active_badge',
                        name: 'active',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                order: [
                    [0, 'asc']
                ]
            });

            // ====== Helpers ======
            const typeModal = new bootstrap.Modal(document.getElementById('typeModal'));
            const showModal = new bootstrap.Modal(document.getElementById('showModal'));

            function clearErrors(form) {
                form.querySelectorAll('.is-invalid').forEach(el => {
                    el.classList.remove('is-invalid');
                });
                form.querySelectorAll('.invalid-feedback').forEach(el => {
                    el.textContent = '';
                });
            }

            function setErrors(form, errors) {
                Object.entries(errors || {}).forEach(([name, msgs]) => {
                    // name مثل: "name.en" أو "description.ar"
                    const selector = `[name="${name}"]`;
                    const input = form.querySelector(selector);
                    if (input) {
                        input.classList.add('is-invalid');
                        const fb = input.nextElementSibling;
                        if (fb && fb.classList.contains('invalid-feedback')) {
                            fb.textContent = Array.isArray(msgs) ? msgs[0] : msgs;
                        }
                    }
                });
            }

            function resetFormForCreate() {
                const form = document.getElementById('typeForm');
                form.reset();
                document.getElementById('record_id').value = '';
                document.getElementById('typeModalTitle').textContent = 'إضافة نوع خدمة';
                document.getElementById('saveBtnText').textContent = 'حفظ';
                clearErrors(form);
                form.setAttribute('data-mode', 'create');
            }

            function fillFormForEdit(row) {
                const form = document.getElementById('typeForm');
                clearErrors(form);
                document.getElementById('record_id').value = row.id;
                document.getElementById('name_en').value = row.name?.en ?? '';
                document.getElementById('name_ar').value = row.name?.ar ?? '';
                document.getElementById('desc_en').value = row.description?.en ?? '';
                document.getElementById('desc_ar').value = row.description?.ar ?? '';
                document.getElementById('active').value = row.active ? 1 : 0;
                document.getElementById('typeModalTitle').textContent = 'تعديل نوع خدمة';
                document.getElementById('saveBtnText').textContent = 'تحديث';
                form.setAttribute('data-mode', 'edit');
            }

            function fillShowModal(row) {
                document.getElementById('show_name_ar').textContent = row.name?.ar ?? '—';
                document.getElementById('show_name_en').textContent = row.name?.en ?? '—';
                document.getElementById('show_desc_ar').textContent = row.description?.ar ?? '—';
                document.getElementById('show_desc_en').textContent = row.description?.en ?? '—';
                document.getElementById('show_active').innerHTML = row.active ?
                    '<span class="badge bg-success">نشط</span>' :
                    '<span class="badge bg-secondary">غير نشط</span>';
                document.getElementById('show_created_at').textContent = row.created_at ?? '—';
                document.getElementById('show_updated_at').textContent = row.updated_at ?? '—';
            }

            function extractIdFromUrl(url) {
                const m = url.match(/service-types\/(\d+)/);
                return m ? m[1] : null;
            }

            async function fetchJSON(url) {
                const res = await fetch(url, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                });
                if (!res.ok) throw new Error('Request failed');
                return await res.json();
            }

            // ====== Open Create ======
            document.querySelector('.open-create')?.addEventListener('click', () => {
                resetFormForCreate();
                typeModal.show();
            });

            // ====== Row: Show (intercept the eye button link) ======
            $('#st-table').on('click', 'a.btn-primary, a[title="عرض"]', async function(e) {
                e.preventDefault();
                const href = this.getAttribute('href') || '';
                const id = extractIdFromUrl(href);
                if (!id) return;
                try {
                    const row = await fetchJSON(`${ST_ROUTES.base}/${id}`);
                    fillShowModal(row);
                    showModal.show();
                } catch (err) {
                    toastr.error('تعذر جلب البيانات');
                }
            });

            // ====== Row: Edit (intercept the edit button link) ======
            $('#st-table').on('click', 'a.btn-warning, a[title="تعديل"]', async function(e) {
                e.preventDefault();
                const href = this.getAttribute('href') || '';
                const id = extractIdFromUrl(href);
                if (!id) return;
                try {
                    const row = await fetchJSON(`${ST_ROUTES.base}/${id}`);
                    fillFormForEdit(row);
                    typeModal.show();
                } catch (err) {
                    toastr.error('تعذر جلب البيانات');
                }
            });

            // ====== Submit (Create / Update) via AJAX ======
            document.getElementById('typeForm').addEventListener('submit', async function(e) {
                e.preventDefault();
                clearErrors(this);

                const mode = this.getAttribute('data-mode') || 'create';
                const id = document.getElementById('record_id').value;
                const formData = new URLSearchParams(new FormData(this)); // يدعم name[ar]...

                // تحديد المسار والطريقة
                let url = ST_ROUTES.store;
                let method = 'POST';
                if (mode === 'edit' && id) {
                    url = `${ST_ROUTES.base}/${id}`;
                    formData.append('_method', 'PUT');
                }

                try {
                    const res = await fetch(url, {
                        method: 'POST', // Laravel يقبل _method=PUT
                        headers: {
                            'X-CSRF-TOKEN': ST_ROUTES.token,
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json',
                            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                        },
                        body: formData.toString()
                    });

                    if (res.status === 422) {
                        const data = await res.json();
                        setErrors(this, data.errors || {});
                        toastr.error('من فضلك صحّح الأخطاء');
                        return;
                    }
                    if (!res.ok) throw new Error('Request failed');

                    const data = await res.json().catch(() => ({}));
                    toastr.success(data.message || (mode === 'edit' ? 'تم التحديث بنجاح' :
                        'تمت الإضافة بنجاح'));
                    typeModal.hide();
                    $('#st-table').DataTable().ajax.reload(null, false);
                } catch (err) {
                    toastr.error('حدث خطأ غير متوقع');
                }
            });

        });
    </script>
@endsection
