@extends('layouts.master')

@section('title', __('إعدادات الشركة'))

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        .form-section {
            background: #0f1e2b;
            padding: 16px;
            border-radius: 8px;
            margin-bottom: 16px;
        }

        .phone-row .remove-phone {
            min-width: 42px;
        }

        .logo-preview {
            max-height: 70px;
            border-radius: 6px
        }
    </style>

    <style>
        .logo-uploader {
            border: 1px dashed var(--bs-border-color);
            border-radius: 12px;
            padding: 12px;
            background: rgba(255, 255, 255, .02)
        }

        .logo-uploader.dragover {
            border-color: #0ea5b6;
            background: rgba(14, 165, 182, .08)
        }

        .logo-preview {
            aspect-ratio: 3/1;
            /* تغييرها لـ 1/1 لو شعارك مربع */
          
            border-radius: 10px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logo-preview img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            padding: 8px;
            filter: drop-shadow(0 2px 6px rgba(0, 0, 0, .15))
        }

        .logo-placeholder {
            text-align: center;
            padding: 22px
        }

        .logo-placeholder small {
            display: block;
            opacity: .8
        }

        .color-field {
            display: flex;
            align-items: center;
            gap: .5rem
        }

        .color-field .color-hex {
            font-size: .85rem;
            opacity: .85;
            direction: ltr
        }
    </style>

@endsection

@section('content')
    <div class="container-fluid">
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $err)
                        <li>{{ $err }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form id="companyForm" action="{{ route('settings.company.update') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="row g-3">
                {{-- الاسم --}}
                <div class="col-12 form-section">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">الاسم (ar) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name[ar]"
                                value="{{ old('name.ar', $setting?->getTranslation('name', 'ar')) }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">الاسم (en) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name[en]"
                                value="{{ old('name.en', $setting?->getTranslation('name', 'en')) }}" required>
                        </div>
                    </div>
                </div>

                <div class="col-12 form-section">
                    <div class="row g-3 align-items-stretch">
                        {{-- الشعار --}}
                        <div class="col-md-6">
                            <label class="form-label">الشعار</label>

                            <div class="logo-uploader" id="logoDropZone">
                                <div class="logo-preview" id="logoPreview">
                                    @if ($setting?->logo_path)
                                        <img src="{{ asset($setting->logo_path) }}" alt="logo">
                                    @else
                                        <div class="logo-placeholder text-muted">
                                            <i class="fas fa-image fa-2x mb-2"></i>
                                            <div>اسحب الشعار هنا أو اضغط لاختياره</div>
                                            <small>PNG / JPG / WEBP حتى 2MB</small>
                                        </div>
                                    @endif
                                </div>

                                <div class="d-flex gap-2 mt-2">
                                    <label class="btn btn-outline-primary btn-sm mb-0">
                                        <i class="fas fa-upload me-1"></i> اختيار ملف
                                        <input type="file" class="d-none" id="logoInput" name="logo" accept="image/*">
                                    </label>

                                    <button type="button" class="btn btn-outline-danger btn-sm" id="logoClear">
                                        <i class="fas fa-times me-1"></i> إزالة المعاينة
                                    </button>
                                </div>
                            </div>
                        </div>

                        {{-- اللون الرئيسي --}}
                        <div class="col-md-3">
                            <label class="form-label">اللون الرئيسي <span class="text-danger">*</span></label>
                            <div class="color-field">
                                <input type="color" class="form-control form-control-color" name="primary_color"
                                    value="{{ old('primary_color', $setting->primary_color ?? '#0ea5b6') }}" required>
                                <span class="color-hex">
                                    {{ old('primary_color', $setting->primary_color ?? '#0ea5b6') }}
                                </span>
                            </div>
                        </div>

                        {{-- اللون الثانوي --}}
                        <div class="col-md-3">
                            <label class="form-label">اللون الثانوي <span class="text-danger">*</span></label>
                            <div class="color-field">
                                <input type="color" class="form-control form-control-color" name="secondary_color"
                                    value="{{ old('secondary_color', $setting->secondary_color ?? '#1e293b') }}" required>
                                <span class="color-hex">
                                    {{ old('secondary_color', $setting->secondary_color ?? '#1e293b') }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>


                {{-- البريد + الفرع الرئيسي --}}
                <div class="col-12 form-section">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">البريد الإلكتروني</label>
                            <input type="email" class="form-control" name="email"
                                value="{{ old('email', $setting->email ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">الدولة <span class="text-danger">*</span></label>
                            <select name="country_id" class="form-select" required>
                                <option value="">— اختر الدولة —</option>
                                @foreach ($countries as $country)
                                    @php
                                        // لو Country يستخدم Spatie Translatable
                                        if (method_exists($country, 'getTranslation')) {
                                            $label = $country->getTranslation('name', app()->getLocale());
                                        } elseif (is_array($country->name)) {
                                            // تخزين JSON بدائي بدون HasTranslations
                                            $label =
                                                $country->name[app()->getLocale()] ??
                                                ($country->name['en'] ?? reset($country->name));
                                        } else {
                                            // اسم نصي عادي
                                            $label = $country->name;
                                        }
                                    @endphp
                                    <option value="{{ $country->id }}" @selected(old('country_id', $setting->country_id ?? null) == $country->id)>
                                        {{ $label }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        @isset($branches)
                            <div class="col-md-6">
                                <label class="form-label">الفرع الرئيسي</label>
                                <select class="form-select" name="main_branch_id">
                                    <option value="">— اختر —</option>
                                    @foreach ($branches as $b)
                                        <option value="{{ $b->id }}" @selected(old('main_branch_id', $setting->main_branch_id ?? null) == $b->id)>
                                            {{ $b->getTranslation('name', app()->getLocale()) }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endisset
                    </div>
                </div>

                {{-- هواتف الشركة (Repeater) --}}
                <div class="col-12 form-section">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <label class="form-label mb-0">أرقام الهواتف</label>
                        <button type="button" class="btn btn-info btn-sm" id="addPhone"><i
                                class="fas fa-plus"></i></button>
                    </div>

                    <div id="phonesWrapper">
                        @php
                            $phones = old('phones', $setting->phones ?? []);
                        @endphp
                        @forelse($phones as $i => $p)
                            <div class="row g-2 phone-row align-items-end mb-2">
                                <div class="col-md-3">
                                    <label class="form-label">مسمّى (ar)</label>
                                    <input type="text" class="form-control"
                                        name="phones[{{ $i }}][label][ar]"
                                        value="{{ $p['label']['ar'] ?? '' }}" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Label (en)</label>
                                    <input type="text" class="form-control"
                                        name="phones[{{ $i }}][label][en]"
                                        value="{{ $p['label']['en'] ?? '' }}" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">رقم الهاتف</label>
                                    <input type="text" class="form-control"
                                        name="phones[{{ $i }}][number]" value="{{ $p['number'] ?? '' }}"
                                        required>
                                </div>
                                <div class="col-md-2 d-grid">
                                    <button type="button" class="btn btn-danger remove-phone"><i
                                            class="fas fa-trash"></i></button>
                                </div>
                            </div>
                        @empty
                            {{-- صف افتراضي --}}
                            <div class="row g-2 phone-row align-items-end mb-2">
                                <div class="col-md-3">
                                    <label class="form-label">مسمّى (ar)</label>
                                    <input type="text" class="form-control" name="phones[0][label][ar]" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Label (en)</label>
                                    <input type="text" class="form-control" name="phones[0][label][en]" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">رقم الهاتف</label>
                                    <input type="text" class="form-control" name="phones[0][number]" required>
                                </div>
                                <div class="col-md-2 d-grid">
                                    <button type="button" class="btn btn-danger remove-phone"><i
                                            class="fas fa-trash"></i></button>
                                </div>
                            </div>
                        @endforelse
                    </div>
                </div>

                <div class="col-12">
                    <button class="btn btn-primary"><i class="fas fa-save mx-2"></i> حفظ</button>
                </div>
            </div>
        </form>
    </div>
@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const wrapper = document.getElementById('phonesWrapper');
            const addBtn = document.getElementById('addPhone');

            addBtn.addEventListener('click', function() {
                const index = wrapper.querySelectorAll('.phone-row').length;
                const html = `
        <div class="row g-2 phone-row align-items-end mb-2">
            <div class="col-md-3">
                <label class="form-label">مسمّى (ar)</label>
                <input type="text" class="form-control" name="phones[${index}][label][ar]" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Label (en)</label>
                <input type="text" class="form-control" name="phones[${index}][label][en]" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">رقم الهاتف</label>
                <input type="text" class="form-control" name="phones[${index}][number]" required>
            </div>
            <div class="col-md-2 d-grid">
                <button type="button" class="btn btn-danger remove-phone"><i class="fas fa-trash"></i></button>
            </div>
        </div>`;
                wrapper.insertAdjacentHTML('beforeend', html);
            });

            wrapper.addEventListener('click', function(e) {
                if (e.target.closest('.remove-phone')) {
                    e.target.closest('.phone-row').remove();
                }
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const dropZone = document.getElementById('logoDropZone');
            const input = document.getElementById('logoInput');
            const preview = document.getElementById('logoPreview');
            const clearBtn = document.getElementById('logoClear');
            const existing = "{{ $setting?->logo_path ? asset($setting->logo_path) : '' }}";

            const placeholder = `
    <div class="logo-placeholder text-muted">
      <i class="fas fa-image fa-2x mb-2"></i>
      <div>اسحب الشعار هنا أو اضغط لاختياره</div>
      <small>PNG / JPG / WEBP حتى 2MB</small>
    </div>`;

            function showImage(src) {
                preview.innerHTML = `<img src="${src}" alt="logo preview">`;
            }

            function showPlaceholder() {
                if (existing) preview.innerHTML = `<img src="${existing}" alt="logo">`;
                else preview.innerHTML = placeholder;
            }

            function handleFile(file) {
                if (!file || !file.type.startsWith('image/')) return;
                if (file.size > 2 * 1024 * 1024) { // 2MB
                    alert('الحد الأقصى 2 ميجابايت');
                    input.value = '';
                    showPlaceholder();
                    return;
                }
                const url = URL.createObjectURL(file);
                showImage(url);
            }

            input?.addEventListener('change', e => handleFile(e.target.files[0]));

            clearBtn?.addEventListener('click', () => {
                input.value = '';
                showPlaceholder();
            });

            // سحب وإفلات
            ['dragenter', 'dragover'].forEach(evt => {
                dropZone.addEventListener(evt, e => {
                    e.preventDefault();
                    e.stopPropagation();
                    dropZone.classList.add('dragover');
                });
            });
            ['dragleave', 'drop'].forEach(evt => {
                dropZone.addEventListener(evt, e => {
                    e.preventDefault();
                    e.stopPropagation();
                    dropZone.classList.remove('dragover');
                });
            });
            dropZone.addEventListener('drop', e => {
                const file = e.dataTransfer.files?.[0];
                if (file) {
                    // عيّن الملف للـ input عشان يتحفظ مع الفورم
                    const dt = new DataTransfer();
                    dt.items.add(file);
                    input.files = dt.files;
                    handleFile(file);
                }
            });

            // الضغط على المساحة يفتح اختيار الملف
            dropZone.addEventListener('click', () => input?.click());

            // تحديث كود اللون الظاهر بجانب الـ input
            document.querySelectorAll('.color-field input[type="color"]').forEach(el => {
                const hexEl = el.parentElement.querySelector('.color-hex');
                el.addEventListener('input', () => {
                    if (hexEl) hexEl.textContent = el.value;
                });
            });
        });
    </script>

@endsection
