@extends('layouts.master')
@section('title', 'كارت الاشتراك')

@section('css')
    <style>
     

        .card-container {
          
            border-radius: 12px;
            overflow: hidden;
            position: relative;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
            color: white;
            background: linear-gradient(135deg, #0a58ca, #003366);
            padding: 18px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            margin-bottom: 25px;
        }

        .logo {
            position: absolute;
            top: 8px;
            right: 8px;
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: #fff;
            overflow: hidden;
            border: 2px solid #0dcaf0;
        }

        .logo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .member-name {
            font-size: 1.1rem;
            font-weight: 700;
            color: #ffd43b;
            margin-top: 4px;
        }

        .details {
            font-size: 0.85rem;
            line-height: 1.4;
            margin-top: 8px;
        }

        .details p {
            margin: 0;
        }

        .qr-section {
            background: rgba(255, 255, 255, 0.15);
            text-align: center;
            border-radius: 10px;
            padding: 5px;
            margin-top: 8px;
        }

        .qr-section img {
            width: 75px;
            height: 75px;
            margin-top: 4px;
        }

        .qr-section small {
            color: #e2e8f0;
            font-size: 0.7rem;
            display: block;
            margin-top: 2px;
        }

        @media print {
            .no-print {
                display: none !important;
            }

            body {
                background: white;
                -webkit-print-color-adjust: exact;
            }

            @page {
                size: 8.6cm 5.4cm;
                margin: 0;
            }
        }
    </style>
@endsection

@section('content')
    <div class="no-print text-center mb-3">
        <button onclick="window.print()" class="btn btn-success px-4">🖨️ طباعة الكارت</button>
    </div>

    <div class="card-container">
      

        <div>
            <div class="member-name">{{ $sub->member->name }}</div>
            <div class="details">
                <p><b>📄 الفاتورة:</b> {{ $sub->invoice_code }}</p>
                <p><b>🏢 الفرع:</b> {{ $sub->branch->name }}</p>
                <p><b>📅 من:</b> {{ $sub->start_date->format('Y-m-d') }}</p>
                <p><b>⏳ إلى:</b> {{ $sub->end_date->format('Y-m-d') }}</p>
                <p><b>💳 الدفع:</b> {{ $sub->paymentMethod->name_ar ?? '—' }}</p>
            </div>
        </div>

        <div class="qr-section">
            <small>امسح الكود لعرض تفاصيل الاشتراك</small>
            <img src="https://api.qrserver.com/v1/create-qr-code/?data={{ urlencode(route('subscriptions.show', $sub->id)) }}&size=120x120"
                alt="QR Code">
        </div>
    </div>
@endsection
