@extends('layouts.master')

@section('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .card {
            background: #0f2233;
            border: 1px solid #1e3b4d;
            border-radius: 14px
        }

        .section-title {
            font-weight: 700;
            color: #a7d1ff
        }

        .form-control,
        .form-select {
            color: #fff;
            border: 1px solid #24465f
        }

        .form-control:focus,
        .form-select:focus {
            border-color: #0d6efd;
            box-shadow: none
        }

        .details-box {
            border: 1px solid #24465f;
            border-radius: 10px;
            padding: 10px
        }

        .table-darkish {
            --bs-table-color: #e7f4ff;
            --bs-table-border-color: #1e3b4d
        }

        #memberCard {
            background: #13283a;
            border: 1px solid #1e3b4d;
            border-radius: 10px
        }

        .btn-outline-success {
            border-color: #198754;
            color: #8fd19e;
        }

        .btn-outline-success:hover {
            background: #198754;
            color: #fff
        }

        .select2-container .select2-selection--single {
            border: 1px solid #24465f;
            height: 38px;
            color: #fff
        }

        .modal-fullscreen .modal-content {
            background: linear-gradient(135deg, #0f2233, #122c40);
            border: 1px solid #1e3b4d;
        }

        .table-darkish th {
            background: #17354a;
            color: #a7d1ff;
        }

        .table-darkish td {
            vertical-align: middle;
        }

        .summary-tile {
            background: #13283a;
            border-radius: 12px;
            padding: 15px 10px;
            min-height: 110px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .summary-tile .label {
            font-size: 0.85rem;
            opacity: .8;
            margin-bottom: 6px;
        }

        .summary-tile .value {
            font-size: 1.3rem;
            font-weight: 700;
        }

        .tile-input {
            background: #13283a !important;
            border-radius: 12px;
            padding: 12px 10px;
            min-height: 110px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .tile-input input {
            width: 100%;
            background: transparent !important;
            border: none !important;
            border-bottom: 1px #24465f !important;
            text-align: center;
            color: #ff8a8a !important;
            font-size: 1.2rem;
            font-weight: 700;
        }

        .tile-input label {
            font-size: 0.85rem;
            opacity: .8;
            margin-bottom: 6px;
        }

        .btn-outline-info {
            border-color: #0dcaf0;
            color: #0dcaf0;
        }

        .btn-outline-info:hover {
            background: #0dcaf0;
            color: #000;
        }

        .btn-outline-warning {
            border-color: #ffc107;
            color: #ffc107;
        }

        .btn-outline-warning:hover {
            background: #ffc107;
            color: #000;
        }
    </style>
@endsection

@section('content')
    <form id="subForm" method="POST" action="{{ route('subscriptions.store') }}">
        @csrf
        <div class="container-fluid">
            {{-- ===== عنوان الصفحة + الأزرار ===== --}}
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h3 class="fw-bold text-light">
                    <i class="fas fa-plus-circle text-success me-2"></i> إنشاء اشتراك
                </h3>

                <div class="d-flex gap-2">
                    {{-- زر إدارة الدفع --}}
                    <button type="button" id="paymentBtn" class="btn btn-outline-success px-4" data-bs-toggle="modal"
                        data-bs-target="#paymentFullModal">
                        <i class="fas fa-wallet me-2"></i> سداد
                    </button>

                    {{-- زر الحفظ --}}
                    <button type="submit" id="saveBtn" class="btn btn-success px-4" disabled>
                        <i class="fas fa-save me-2"></i> حفظ الاشتراك
                    </button>
                </div>
            </div>


            {{-- رقم الاشتراك / التاريخ / الحالة --}}
            <div class="card p-3 mb-3">
                <div class="row g-3">

                    {{-- رقم الاشتراك --}}
                    <div class="col-md-2">
                        <label class="section-title">رقم الوثيقة</label>
                        <div class="form-control border-0 bg-light fw-bold">
                            {{ $nextNo }}
                        </div>
                        <input type="hidden" name="subscription_no" value="{{ $nextNo }}">
                    </div>

                    {{-- تاريخ الاشتراك (ميلادي + هجري) --}}
                    <div class="col-md-2">
                        <label class="section-title">تاريخ الاشتراك</label>
                        <input type="date" id="greg_date" name="greg_date" class="form-control"
                            value="{{ date('Y-m-d') }}" required>
                    </div>

                    <div class="col-md-2">
                        <label class="section-title">التاريخ الهجري</label>
                        <input type="text" id="hijri_date" name="hijri_date" class="form-control text-right bg-light"
                            readonly>
                    </div>

                    {{-- حالة الاشتراك --}}
                    <div class="col-md-2">
                        <label class="section-title">حالة الاشتراك</label>
                        <select id="status" name="status" class="form-select">
                            <option value="under_review" selected>تحت المراجعة</option>
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label class="section-title">مقدم الخدمة</label>
                        <select name="service_user_id" id="service_user_id" class="form-select " required>
                            <option value="">— اختر مقدم الخدمة —</option>
                            @foreach ($users as $u)
                                <option value="{{ $u->id }}" {{ auth()->id() == $u->id ? 'selected' : '' }}>
                                    {{ $u->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label class="section-title">مسؤول المبيعات</label>
                        <select name="provider_user_id" id="provider_user_id" class="form-select " required>
                            <option value="">— اختر مسؤول المبيعات —</option>
                            @foreach ($users as $u)
                                <option value="{{ $u->id }}" {{ auth()->id() == $u->id ? 'selected' : '' }}>
                                    {{ $u->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            {{-- الفرع / العضو / مقدم الخدمة / مسئول المبيعات --}}
            <div class="card shadow-sm border-0 p-4 mb-3" style="border-radius: 16px;">
                <div class="row g-4 ">
                    {{-- الفرع --}}
                    <div class="col-md-5">
                        <label class="fw-semibold mb-1">الفرع</label>
                        @if (!empty($userBranch))
                            <input type="hidden" id="branch_id" name="branch_id" value="{{ $userBranch->id }}">
                            <div class="form-control border-0 bg-light fw-bold text-primary">
                                <i class="fas fa-store me-2 text-muted"></i> {{ $userBranch->name }}
                            </div>
                        @else
                            <select id="branch_id" name="branch_id" class="form-select select2 shadow-sm" required>
                                <option value="">— اختر الفرع —</option>
                                <option value="0">كل الفروع</option>
                                @foreach ($branches ?? [] as $b)
                                    <option value="{{ $b->id }}">{{ $b->name }}</option>
                                @endforeach
                            </select>
                        @endif
                    </div>

                    {{-- العضو --}}
                    <div class="col-md-5">
                        <label class="fw-semibold mb-1">العضو</label>
                        <select id="member_id" name="member_id" class="form-select select2 shadow-sm" required>
                            <option value="">— اختر العضو —</option>
                        </select>
                    </div>

                    {{-- كارت بيانات العضو --}}
                    <div class="col-md-2 mt-3">
                        <label class="fw-semibold mb-1"></label>
                        <div id="memberCard"
                            class="d-none mt-3 p-2 rounded-3 border-bottom bg-white shadow-sm d-flex justify-content-between align-items-center"
                            style="transition: all 0.3s ease;">
                            <div>
                                <div class="small text-muted">عدد الاشتراكات</div>

                            </div>
                            <div>
                                <div class="fw-bold text-dark badge bg-secondary" id="m_count">0</div>
                                {{-- <span id="m_status_badge" class="badge bg-secondary px-3 py-2 fs-6">غير نشط</span> --}}
                            </div>
                        </div>
                    </div>


                </div>
            </div>

            <div class="lockable">
                {{-- نوع الاشتراك --}}
                <div class="card p-3 mb-3">


                    <div class="row g-3">


                        <div class="col-md-2">
                            <div class="d-flex flex-column justify-content-between align-items-center mb-2">
                                <label class="section-title">نوع الاشتراك</label>
                                <div class="d-flex flex-column  gap-2">
                                    <div>
                                        <input type="radio" class="btn-check" name="subscription_type"
                                            id="type_service" value="service" checked>
                                        <label class="btn btn-outline-info w-100 py-1 small" for="type_service">
                                            <i class="fas fa-concierge-bell me-1"></i> خدمة
                                        </label>
                                    </div>

                                    <div>
                                        <input type="radio" class="btn-check" name="subscription_type" id="type_offer"
                                            value="offer">
                                        <label class="btn btn-outline-warning w-100 py-1 small" for="type_offer">
                                            <i class="fas fa-gift me-1"></i> عرض
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <label id="item_label">اختر الخدمة</label>
                            <select id="item_id" name="item_id" class="form-select select2" required>
                                <option value="">— اختر الخدمة —</option>
                            </select>

                            <div id="offerServicesBox" class="mt-3 d-none">
                                <label>الخدمات داخل العرض</label>
                                <select id="offer_service_id" name="offer_service_id"
                                    class="form-select select2"></select>
                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label>تاريخ البداية</label>
                                    <input type="date" id="start_date" name="start_date" class="form-control"
                                        value="{{ date('Y-m-d') }}">
                                </div>
                                <div class="col-md-6">
                                    <label>تاريخ النهاية</label>
                                    <input type="date" id="end_date" name="end_date" class="form-control" readonly>
                                </div>

                                <div class="col-12">
                                    <label>تفاصيل الاشتراك</label>
                                    <div class="details-box">
                                        <div><i class="fas fa-tag"></i> الاسم: <span id="det_name">—</span></div>
                                        <div><i class="fas fa-money-bill-wave"></i> السعر:
                                            <span id="det_price">—</span>
                                        </div>
                                        <div><i class="fas fa-percent"></i> الخصم:
                                            <span id="det_discount">—</span>
                                        </div>
                                        <div><i class="fas fa-clock"></i> المدة:
                                            <span id="det_duration">—</span>
                                        </div>
                                    </div>
                                </div>

                                {{-- hidden fields للتجميع للسيرفر --}}
                                <input type="hidden" id="price_input" name="price" value="0">
                                <input type="hidden" id="discount_input" name="discount" value="0">
                                <input type="hidden" id="tax_input" name="tax" value="0">
                                <input type="hidden" id="total_input" name="total" value="0">
                            </div>
                        </div>
                    </div>
                </div>

                {{-- الملخص المالي --}}
                <div class="row g-3 text-center mb-3">
                    <div class="col-md-2">
                        <div class="summary-tile">
                            <div class="label">السعر الأساسي</div>
                            <div id="sum_price" class="value">0.00</div>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="tile-input">
                            <label for="extra_discount">خصم إضافي</label>
                            <input type="number" id="extra_discount" name="extra_discount" step="0.01"
                                min="0" value="0" placeholder="0.00">
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="summary-tile">
                            <div class="label">إجمالي الخصومات</div>
                            <div id="sum_discount" class="value text-danger">0.00</div>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="summary-tile">
                            <div class="label">صافي المبلغ بعد الخصومات</div>
                            <div id="sum_after_discount" class="value text-info">0.00</div>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="summary-tile">
                            <div class="label">ضريبة القيمة المضافة (15%)</div>
                            <div id="sum_tax" class="value text-warning">0.00</div>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="summary-tile">
                            <div class="label">الإجمالي بعد الضريبة</div>
                            <div id="sum_total" class="value text-success">0.00</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- 💳 مودال الدفع الكامل --}}
        <div class="modal fade" id="paymentFullModal" tabindex="-1" aria-labelledby="paymentFullModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content bg-dark text-light">
                    <div class="modal-header ">
                        <h5 class="modal-title">
                            <i class="fas fa-credit-card me-2 text-success"></i> إدارة طرق الدفع
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">
                        <div class="container-fluid">

                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <button type="button" class="btn btn-outline-success" id="addPaymentBtn">
                                    <i class="fas fa-plus"></i> إضافة طريقة دفع
                                </button>

                                <div class="fw-bold">
                                    💰 المدفوع: <span id="paid_sum">0.00</span>
                                    &nbsp;—&nbsp;
                                    💳 المتبقي: <span id="remain_sum">0.00</span>
                                </div>
                            </div>

                            <table class="table table-darkish table-bordered text-center" id="paymentsTable">
                                <thead>
                                    <tr>
                                        <th>طريقة الدفع</th>
                                        <th>المبلغ</th>
                                        <th>إجراء</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>

                            <div class="alert alert-secondary mt-4">
                                <strong>ملحوظة:</strong> يجب أن يساوي مجموع المبالغ
                                <span class="text-success fw-bold">الإجمالي بعد الضريبة</span>
                                لحفظ الاشتراك.
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer ">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-arrow-right"></i> رجوع
                        </button>
                        <button type="button" class="btn btn-success" id="confirmPaymentsBtn">
                            <i class="fas fa-check"></i> حفظ الدفع
                        </button>
                    </div>
                </div>
            </div>
        </div>

        {{-- مودال إضافة طريقة دفع (صغير) --}}
        <div class="modal fade" id="addPaymentModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header ">
                        <h5 class="modal-title"><i class="fas fa-credit-card me-2"></i> إضافة طريقة دفع</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-2">
                            <label>طريقة الدفع</label>
                            <select id="modal_method_id" class="form-select select2">
                                @foreach ($methods ?? [] as $m)
                                    <option value="{{ $m->id }}">{{ $m->name_ar }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-2">
                            <label>المبلغ</label>
                            <input type="number" step="0.01" min="0" id="modal_amount"
                                class="form-control text-center">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="button" class="btn btn-success" id="savePaymentRow">إضافة</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection

@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/min/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment-hijri@2.1.2/moment-hijri.min.js"></script>

    <script>
        $(function() {

            // =======================
            // 0) إعدادات عامة + Helpers
            // =======================
            const SERVICES = @json($services ?? []);
            const OFFERS = @json($offers ?? []);
            const METHODS = @json($methods ?? []);
            const HAS_FIXED_BRANCH = Boolean(@json(!empty($userBranch)));

            const toNum = v => Number(parseFloat(v || 0).toFixed(2)) || 0;
            const money = v => toNum(v).toFixed(2);
            const unitToDays = (v, u) => {
                v = toNum(v);
                if (u === 'months') return v * 30;
                if (u === 'years') return v * 365;
                return v;
            };

            // عناصر DOM
            const $branch = $('#branch_id');
            const $member = $('#member_id');
            const $memberCard = $('#memberCard');
            const $mCount = $('#m_count');

            const $serviceUser = $('#service_user_id');
            const $providerUser = $('#provider_user_id');
            const $gregDate = $('#greg_date');

            const $typeRadios = $('input[name="subscription_type"]');
            const $item = $('#item_id');
            const $offerBox = $('#offerServicesBox');
            const $offerSvc = $('#offer_service_id');

            const $start = $('#start_date');
            const $end = $('#end_date');

            const $detName = $('#det_name');
            const $detPrice = $('#det_price');
            const $detDiscount = $('#det_discount');
            const $detDuration = $('#det_duration');

            const $extra = $('#extra_discount');
            const $sumPrice = $('#sum_price');
            const $sumDisc = $('#sum_discount');
            const $sumAfter = $('#sum_after_discount');
            const $sumTax = $('#sum_tax');
            const $sumTotal = $('#sum_total');

            const $priceInput = $('#price_input');
            const $discInput = $('#discount_input');
            const $taxInput = $('#tax_input');
            const $totalInput = $('#total_input');

            const $payTbody = $('#paymentsTable tbody');
            const $paid = $('#paid_sum');
            const $remain = $('#remain_sum');

            const $saveBtn = $('#saveBtn');
            const $paymentBtn = $('#paymentBtn');

            let paymentIndex = 0;

            let current = {
                type: 'service',
                name: '—',
                price: 0,
                discount: 0,
                durationDays: 0
            };

            // =======================
            // 1) Select2 أساسي
            // =======================
            // كل select2 ما عدا العضو (هنديّه إعداد خاص)
            $('.select2').not('#member_id').select2({
                width: '100%',
                placeholder: 'اختر...',
                allowClear: true
            });

            // =======================
            // 2) تحويل التاريخ إلى هجري
            // =======================
            function updateHijri() {
                const g = $gregDate.val();
                if (!g) return;
                $('#hijri_date').val(moment(g, 'YYYY-MM-DD').format('iD-iM-iYYYY'));
            }
            updateHijri();
            $gregDate.on('change', updateHijri);

            // =======================
            // 3) تحميل الأعضاء حسب الفرع
            // =======================
            function initMemberSelect2() {
                if ($member.data('select2')) {
                    $member.select2('destroy');
                }

                $member.select2({
                    width: '100%',
                    placeholder: 'اختر العضو',
                    allowClear: true,
                    templateResult: function(data) {
                        if (!data.id) return data.text;

                        let $el = $(data.element);
                        let status = $el.data('status');
                        let color = status === 'نشط' ? '#28a745' : '#dc3545';

                        return $(`
                                <div style="display:flex; justify-content:space-between;">
                                    <span>${data.text}</span>
                                    <span style="color:${color}; font-weight:bold;">${status}</span>
                                </div>
                            `);
                    },
                    templateSelection: function(data) {
                        return data.text || '';
                    }
                });
            }

            function fillMembersOptions(rows) {
                $member.empty().append('<option value="">— اختر العضو —</option>');

                (rows || []).forEach(m => {
                    let rawStatus = String(m.status ?? '').trim().toLowerCase();
                    let statusText =
                        (m.status == 1 ||
                            m.status === '1' ||
                            m.status === true ||
                            rawStatus === 'active' ||
                            rawStatus === 'نشط') ?
                        'نشط' :
                        'غير نشط';

                    let count = m.subscriptions_count ?? 0;

                    $member.append(`
                        <option value="${m.id}"
                                data-status="${statusText}"
                                data-count="${count}">
                            ${m.name}
                        </option>
                    `);
                });

                initMemberSelect2();
            }

            function loadMembersForBranch(id) {

                $member.empty().append('<option value="">— جاري التحميل —</option>');

                // كل الفروع
                if (id === "0") {
                    $.get("/get-all-members", function(rows) {
                        fillMembersOptions(rows || []);
                    });
                    return;
                }

                // لو فرع ثابت من الـ backend
                if (HAS_FIXED_BRANCH && !id) {
                    const fixedId = $branch.val();
                    if (!fixedId) {
                        $member.html('<option value="">— لا يوجد فرع —</option>');
                        return;
                    }
                    id = fixedId;
                }

                if (!id) {
                    $member.html('<option value="">— اختر الفرع أولاً —</option>');
                    return;
                }

                $.get(`/branches/${id}/members`, function(rows) {
                    fillMembersOptions(rows || []);
                });
            }

            // عند تغيير الفرع
            $branch.on('change', function() {
                $memberCard.addClass('d-none');
                loadMembersForBranch(this.value);
                validateBaseSelections();
            });

            // لو الفرع مُحدد مسبقاً (فرع ثابت)
            if ($branch.val()) {
                loadMembersForBranch($branch.val());
            }

            // عند اختيار العضو
            $member.on('change', function() {
                const $o = $(this).find(':selected');

                if (!$o.val()) {
                    $memberCard.addClass('d-none');
                    validateBaseSelections();
                    return;
                }

                const count = $o.data('count') || 0;
                $mCount.text(count);

                $memberCard.removeClass('d-none');
                validateBaseSelections();
            });

            // =======================
            // 4) تعبئة الخدمات/العروض
            // =======================
            function fillItems() {
                const t = $('input[name="subscription_type"]:checked').val() || 'service';
                $('#item_label').text(t === 'offer' ? 'اختر العرض' : 'اختر الخدمة');

                $item.empty().append(`<option value="">— اختر ${t === 'offer' ? 'العرض' : 'الخدمة'} —</option>`);
                $offerBox.addClass('d-none');
                $offerSvc.empty();

                const src = (t === 'offer') ? OFFERS : SERVICES;

                src.forEach(r => {
                    let name = typeof r.name === 'object' ?
                        (r.name.ar || r.name.en || Object.values(r.name)[0]) :
                        r.name;

                    const $o = $('<option>').val(r.id).text(name);

                    if (t === 'service') {
                        $o.data('price', r.price || 0)
                            .data('duration_value', r.duration_value || 0)
                            .data('duration_unit', r.duration_unit || 'days');
                    } else {
                        $o.data('discount_type', r.discount_type || 'amount')
                            .data('discount_value', r.discount_value || 0)
                            .data('duration_value', r.duration_value || 0)
                            .data('duration_unit', r.duration_unit || 'days');
                    }

                    $item.append($o);
                });

                // إعادة تهيئة select2 للخدمة/العرض
                if ($item.data('select2')) $item.select2('destroy');
                $item.select2({
                    width: '100%',
                    placeholder: 'اختر...',
                    allowClear: true
                });
            }

            fillItems();

            // =======================
            // 5) تحديث تاريخ النهاية
            // =======================
            function updateEnd() {
                if (!current.durationDays) return;
                const s = $start.val();
                if (!s) return;

                const d = new Date(s + 'T00:00:00');
                d.setDate(d.getDate() + current.durationDays - 1);
                $end.val(d.toISOString().slice(0, 10));
            }

            $start.on('change', updateEnd);

            // =======================
            // 6) الحسابات (السعر/الخصم/الضريبة)
            // =======================
            function recalcTotals() {

                $detName.text(current.name);
                $detPrice.text(money(current.price));
                $detDiscount.text(money(current.discount));
                $detDuration.text(current.durationDays ? (current.durationDays + ' يوم') : '—');

                let price = toNum(current.price);
                let disc = toNum(current.discount);
                let extra = toNum($extra.val());

                if (extra < 0) {
                    alert('🚫 لا يمكن إدخال خصم إضافي سالب.');
                    extra = 0;
                    $extra.val('0');
                }

                const maxExtra = Math.max(0, price - disc);
                if (extra > maxExtra) {
                    alert(`⚠️ أقصى خصم إضافي مسموح هو ${money(maxExtra)} لأن الصافي لا يمكن أن يكون سالبًا.`);
                    extra = maxExtra;
                    $extra.val(money(maxExtra));
                }

                const net = Math.max(0, price - disc - extra); // الصافي بعد كل الخصومات
                const tax = net * 0.15; // الضريبة على الصافي فقط
                const total = net + tax; // الإجمالي بعد الضريبة

                $sumPrice.text(money(price));
                $sumDisc.text(money(disc + extra));
                $sumAfter.text(money(net));
                $sumTax.text(money(tax));
                $sumTotal.text(money(total));

                $priceInput.val(money(price));
                $discInput.val(money(disc + extra));
                $taxInput.val(money(tax));
                $totalInput.val(money(total));

                recalcPayments();
                updateEnd();
                updateSaveButton();
            }

            $extra.on('input', recalcTotals);

            // =======================
            // 7) تغيير الخدمة / العرض
            // =======================
            function resetCurrentAndPayments() {
                current = {
                    type: current.type,
                    name: '—',
                    price: 0,
                    discount: 0,
                    durationDays: 0
                };
                $extra.val('0');
                $end.val('');
                clearPayments();
                recalcTotals();
            }

            // تغيير نوع الاشتراك (خدمة / عرض)
            $typeRadios.on('change', function() {
                current.type = $(this).val() || 'service';
                resetCurrentAndPayments();
                fillItems();
            });

            // عند اختيار الخدمة أو العرض
            $item.on('change', function() {
                resetCurrentAndPayments();

                const t = $('input[name="subscription_type"]:checked').val();
                const $o = $item.find(':selected');
                if (!$o.val()) return;

                if (t === 'service') {
                    current = {
                        type: 'service',
                        name: $o.text(),
                        price: toNum($o.data('price')),
                        discount: 0,
                        durationDays: unitToDays(
                            toNum($o.data('duration_value')),
                            $o.data('duration_unit') || 'days'
                        )
                    };
                    $offerBox.addClass('d-none');
                    recalcTotals();
                } else {
                    // عرض → نحمل الخدمات داخل العرض
                    $.get(`/offers/${$o.val()}/services`, function(rows) {
                        $offerSvc.empty().append(
                            '<option value="">— اختر الخدمة داخل العرض —</option>');
                        (rows || []).forEach(s => {
                            $offerSvc.append(`
                                <option value="${s.id}"
                                        data-name="${s.name}"
                                        data-price="${toNum(s.price)}"
                                        data-duration_days="${unitToDays(toNum(s.duration_value), s.duration_unit || 'days')}">
                                    ${s.name}
                                </option>
                            `);
                        });

                        if ($offerSvc.data('select2')) $offerSvc.select2('destroy');
                        $offerSvc.select2({
                            width: '100%',
                            placeholder: 'اختر...',
                            allowClear: true
                        });

                        $offerBox.removeClass('d-none');
                    });
                }
            });

            // عند اختيار خدمة داخل العرض
            $offerSvc.on('change', function() {
                resetCurrentAndPayments();

                const $s = $offerSvc.find(':selected');
                const $o = $item.find(':selected');
                if (!$s.val() || !$o.val()) return;

                const basePrice = toNum($s.data('price'));
                const discType = $o.data('discount_type');
                const discValue = toNum($o.data('discount_value'));

                let discountAmount = 0;
                if (discType === 'percent') {
                    discountAmount = basePrice * discValue / 100;
                } else {
                    discountAmount = discValue;
                }

                current = {
                    type: 'offer',
                    name: $s.data('name'),
                    price: basePrice,
                    discount: discountAmount,
                    durationDays: toNum($s.data('duration_days'))
                };

                recalcTotals();
            });

            // =======================
            // 8) الدفع
            // =======================
            const paymentModal = new bootstrap.Modal(document.getElementById('addPaymentModal'));

            function recalcPayments() {
                let paid = 0;
                $payTbody.find('input[name$="[amount]"]').each(function() {
                    let v = toNum($(this).val());
                    if (v < 0) {
                        v = 0;
                        $(this).val('0.00');
                    }
                    paid += v;
                });

                const due = toNum($sumTotal.text());
                const remain = Math.max(0, due - paid);

                $paid.text(money(paid));
                $remain.text(money(remain));

                updateSaveButton();
            }

            function clearPayments() {
                $payTbody.empty();
                paymentIndex = 0;
                recalcPayments();
            }

            function addPaymentRow(methodId, methodName, amount) {
                const row = `
                    <tr>
                        <td>
                            ${methodName}
                            <input type="hidden" name="payments[${paymentIndex}][method_id]" value="${methodId}">
                        </td>
                        <td>
                            <input type="number" step="0.01" min="0"
                                   name="payments[${paymentIndex}][amount]"
                                   value="${money(amount)}"
                                   class="form-control text-center pay-amount">
                        </td>
                        <td>
                            <button type="button" class="btn btn-sm btn-danger del-row">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>`;
                $payTbody.append(row);
                paymentIndex++;
                recalcPayments();
            }

            $('#addPaymentBtn').on('click', function() {
                const remain = toNum($remain.text());
                const due = toNum($sumTotal.text());

                if (due <= 0) {
                    alert('⚠️ لا يوجد إجمالي مستحق.');
                    return;
                }

                if (remain <= 0) {
                    alert('💰 لا يوجد مبلغ متبقٍ.');
                    return;
                }

                $('#modal_method_id').val(METHODS[0]?.id || '');
                $('#modal_amount').val(money(remain));
                paymentModal.show();
            });

            $('#savePaymentRow').on('click', function() {
                const id = $('#modal_method_id').val();
                const name = $('#modal_method_id option:selected').text();
                const amount = toNum($('#modal_amount').val());
                const remain = toNum($remain.text());

                if (!id) return alert('⚠️ اختر طريقة دفع.');
                if (amount <= 0) return alert('⚠️ أدخل مبلغًا صالحًا.');
                if (amount > remain) return alert('🚫 لا يمكن إدخال مبلغ أكبر من المتبقي.');

                const exists = $payTbody.find(`input[name$="[method_id]"][value="${id}"]`);
                if (exists.length) {
                    if (!confirm(`طريقة "${name}" مضافة مسبقًا.\nهل تريد إضافة صف جديد بنفس الطريقة؟`)) {
                        return;
                    }
                }

                addPaymentRow(id, name, amount);
                paymentModal.hide();
            });

            $(document).on('click', '.del-row', function() {
                $(this).closest('tr').remove();
                recalcPayments();
            });

            $(document).on('input', '.pay-amount', function() {
                if (toNum(this.value) < 0) {
                    this.value = '0.00';
                }
                recalcPayments();
            });

            $('#confirmPaymentsBtn').on('click', function() {
                const due = toNum($sumTotal.text());
                const paid = toNum($paid.text());

                if (due <= 0) {
                    alert('⚠️ لا يوجد إجمالي مستحق.');
                    return;
                }
                if (Math.abs(due - paid) > 0.01) {
                    alert('⚠️ مجموع المدفوع لا يساوي الإجمالي بعد الضريبة.');
                    return;
                }

                alert('✅ تم حفظ بيانات السداد، ويمكنك الآن حفظ الاشتراك ما دامت بيانات الهيدر مكتملة.');
            });

            // =======================
            // 9) منطق القفل / الفتح
            // =======================
            function lockAllSections() {
                $(".lockable").css({
                    "pointer-events": "none",
                    "opacity": "0.4"
                });

                $saveBtn.prop("disabled", true);
                $paymentBtn.prop("disabled", true);
            }

            function unlockAllSections() {
                $(".lockable").css({
                    "pointer-events": "auto",
                    "opacity": "1"
                });

                $paymentBtn.prop("disabled", false);
                updateSaveButton();
            }

            function isHeaderValid() {
                const branch = $("#branch_id").val() || (HAS_FIXED_BRANCH ? "{{ $userBranch->id ?? '' }}" : '');
                const member = $("#member_id").val();
                const serviceUser = $("#service_user_id").val();
                const providerUser = $("#provider_user_id").val();
                const dateG = $("#greg_date").val();

                return Boolean(branch && member && serviceUser && providerUser && dateG);
            }

            function updateSaveButton() {
                const due = parseFloat($("#sum_total").text()) || 0;
                const paid = parseFloat($("#paid_sum").text()) || 0;
                const headerOk = isHeaderValid();

                $saveBtn.prop(
                    "disabled",
                    !headerOk || Math.abs(due - paid) > 0.01 || due <= 0
                );
            }

            function validateBaseSelections() {
                if (!isHeaderValid()) {
                    lockAllSections();
                } else {
                    unlockAllSections();
                }
            }

            // تشغيل أولي
            lockAllSections();
            recalcTotals(); // يصفّر القيم في البداية

            $("#branch_id").on("change", validateBaseSelections);
            $("#member_id").on("change", validateBaseSelections);
            $("#service_user_id").on("change", validateBaseSelections);
            $("#provider_user_id").on("change", validateBaseSelections);
            $("#greg_date").on("change", validateBaseSelections);

            function canOpenPayment() {
                const total = parseFloat($("#sum_total").text()) || 0;
                const item = $("#item_id").val();

                if (!isHeaderValid()) {
                    return {
                        ok: false,
                        msg: "يجب استكمال بيانات الهيدر أولاً (الفرع، العضو، مقدم الخدمة، مسؤول المبيعات وتاريخ الاشتراك)"
                    };
                }

                if (!item) return {
                    ok: false,
                    msg: "يجب اختيار الخدمة أو العرض"
                };
                if (total <= 0) return {
                    ok: false,
                    msg: "لا يوجد مبلغ مستحق — اختر خدمة أولاً"
                };

                return {
                    ok: true
                };
            }

            $("#paymentFullModal").on("show.bs.modal", function(e) {
                const check = canOpenPayment();

                if (!check.ok) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    alert("⚠️ " + check.msg);
                    return false;
                }

                const netTotal = parseFloat($("#sum_total").text()) || 0;
                const currentPaid = parseFloat($("#paid_sum").text()) || 0;
                const remain = Math.max(0, netTotal - currentPaid);
                $("#remain_sum").text(remain.toFixed(2));
            });

            $("#paymentBtn").on("click", function(e) {
                const check = canOpenPayment();
                if (!check.ok) {
                    e.preventDefault();
                    alert("⚠️ " + check.msg);
                }
            });

        });
    </script>
@endsection
