@extends('layouts.master')
@section('title', 'إدارة الاشتراكات')

@section('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

    <style>
        .stat-card {
            background: #0d1b2a;
            border-radius: 14px;
            padding: 12px 10px;
            color: #e0eaf5;
            transition: 0.25s ease-in-out;
            cursor: pointer;
        }

        .stat-card .icon {
            opacity: 0.9;
        }

        .stat-card h3 {
            margin: 0;
            font-weight: bold;
            font-size: 1.2rem;
            color: black;
        }

        .stat-card small {
            font-size: 0.8rem;
            opacity: .85;
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 14px rgba(0, 0, 0, .18);
        }

        .stat-card.active {
            outline: 2px solid #0d6efd;
            box-shadow: 0 0 0 3px rgba(13, 110, 253, 0.25);
        }

        /* جدول أخف */
        #subscriptionsTable.table tbody td,
        #subscriptionsTable.table thead th {
            padding: .25rem .45rem;
            font-size: .8rem;
            vertical-align: middle;
        }

        #subscriptionsTable.table {
            margin-bottom: 0;
        }

        /* checkbox أصغر */
        .form-check-input.sub-check,
        #checkAll.form-check-input {
            width: 13px;
            height: 13px;
            cursor: pointer;
        }

        /* Dropdown الإجراءات */
        .action-dropdown .dropdown-menu {
            min-width: 230px;
            border-radius: 10px;
            overflow: hidden;
        }

        .action-dropdown .dropdown-item.disabled {
            opacity: .4;
            pointer-events: none;
        }

        .btn-teal {
            background: #13928f !important;
            color: #fff !important;
            border-radius: 10px;
            transition: 0.25s;
        }

        .btn-teal:hover {
            background: #0f7774 !important;
        }

        .action-dropdown .dropdown-menu .dropdown-item {
            font-size: 0.9rem;
            font-weight: 500;
        }

        .action-dropdown .dropdown-item i {
            width: 30px;
            text-align: center;
        }

        .dropdown-toggle::after {
            display: none !important;
        }

        /* ===== جدول أنيق واحترافي ===== */

        .stylish-table thead th {
            background: #0d1b2a !important;
            color: #d9e8ff !important;
            font-weight: 600;
            font-size: 0.9rem;
            border-bottom: 2px solid #1b263b !important;
            white-space: nowrap;
        }

        .stylish-table tbody tr {
            transition: 0.2s;
        }

        .stylish-table tbody tr:hover {
            background: #eef5ff !important;
        }

        .stylish-table td,
        .stylish-table th {
            padding: 8px 12px !important;
            vertical-align: middle !important;
            font-size: 0.88rem;
            border-color: #d4dde6 !important;
        }

        #subscriptionsTable thead th,
        #subscriptionsTable tbody td {
            text-align: center !important;
            vertical-align: middle !important;
        }



        /* الشيك بوكس */
        .form-check-input {
            width: 16px !important;
            height: 16px !important;
            cursor: pointer;
        }

        /* تحسين شكل البادچ للحالة */
        .badge {
            font-size: 0.75rem !important;
            padding: 6px 10px !important;
            border-radius: 6px !important;
            font-weight: 600 !important;
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">

        {{-- العنوان + زر إنشاء --}}
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="mb-0 fw-bold">قائمة الاشتراكات</h2>
            <a href="{{ route('subscriptions.create') }}" class="btn btn-success px-4">
                <i class="fas fa-plus-circle me-1"></i> إنشاء اشتراك جديد
            </a>
        </div>

        {{-- بطاقات الإحصائيات (تعمل كفلاتر) --}}
        <div class="row g-3 mb-3">

            {{-- الكل (افتراضي نشط) --}}
            <div class="col-md-3 col-sm-6">
                <div class="stat-card text-center status-card active" data-status=""
                    style="background: linear-gradient(135deg, #4b6cb7 0%, #182848 100%);">
                    <div class="icon mb-1">
                        <i class="fas fa-layer-group fa-lg"></i>
                    </div>
                    <small>كل الاشتراكات</small>
                    <h3 id="stat_total">
                        {{ ($stats['new'] ?? 0) + ($stats['under_review'] ?? 0) + ($stats['approved'] ?? 0) + ($stats['rejected'] ?? 0) }}
                    </h3>
                </div>
            </div>

            {{-- جديدة (مخفي حالياً – لو احتجته اظهار الـ col) --}}
            <div class="col-md-2 col-sm-6 d-none">
                <div class="stat-card text-center status-card" data-status="new"
                    style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
                    <div class="icon mb-1">
                        <i class="fas fa-plus-circle fa-lg"></i>
                    </div>
                    <small>الاشتراكات الجديدة</small>
                    <h3 id="stat_new">{{ $stats['new'] ?? 0 }}</h3>
                </div>
            </div>

            {{-- تحت المراجعة --}}
            <div class="col-md-3 col-sm-6">
                <div class="stat-card text-center status-card" data-status="under_review"
                    style="background: linear-gradient(135deg, #ffc107 0%, #ffb300 100%); color:#212529;">
                    <div class="icon mb-1">
                        <i class="fas fa-hourglass-half fa-lg"></i>
                    </div>
                    <small>تحت المراجعة</small>
                    <h3 id="stat_under_review">{{ $stats['under_review'] ?? 0 }}</h3>
                </div>
            </div>

            {{-- معتمدة --}}
            <div class="col-md-3 col-sm-6">
                <div class="stat-card text-center status-card" data-status="approved"
                    style="background: linear-gradient(135deg, #198754 0%, #28a745 100%);">
                    <div class="icon mb-1">
                        <i class="fas fa-check-circle fa-lg"></i>
                    </div>
                    <small>الاشتراكات المعتمدة</small>
                    <h3 id="stat_approved">{{ $stats['approved'] ?? 0 }}</h3>
                </div>
            </div>

            {{-- مرفوضة --}}
            <div class="col-md-3 col-sm-6">
                <div class="stat-card text-center status-card" data-status="rejected"
                    style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);">
                    <div class="icon mb-1">
                        <i class="fas fa-times-circle fa-lg"></i>
                    </div>
                    <small>الاشتراكات المرفوضة</small>
                    <h3 id="stat_rejected">{{ $stats['rejected'] ?? 0 }}</h3>
                </div>
            </div>

        </div>


        {{-- 🔍 فلاتر البحث --}}
        <div class="card p-3 mb-3">
            <div class="row g-3">

                {{-- فرع --}}
                <div class="col-md-4">
                    <label class="fw-bold">الفرع</label>
                    <select id="filter_branch" class="form-select">
                        <option value="">كل الفروع</option>
                        @foreach ($allBranches ?? [] as $b)
                            <option value="{{ $b->id }}">{{ $b->name }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- مسجّل الاشتراك --}}
                <div class="col-md-4">
                    <label class="fw-bold">مسجّل الاشتراك</label>
                    <select id="filter_created_by" class="form-select">
                        <option value="">الكل</option>
                        @foreach ($usersList ?? [] as $u)
                            <option value="{{ $u->id }}">{{ $u->name }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- نوع الاشتراك --}}
                <div class="col-md-4">
                    <label class="fw-bold">نوع الاشتراك</label>
                    <select id="filter_type" class="form-select">
                        <option value="">الكل</option>
                        <option value="service">خدمة</option>
                        <option value="offer">عرض</option>
                    </select>
                </div>

            </div>
        </div>



        {{-- شريط الإجراءات - على الشمال --}}
        <div class="d-flex justify-content-end mb-3">
            <div class="dropdown action-dropdown">

                <button class="btn btn-teal dropdown-toggle d-flex align-items-center gap-2"
                    style="background:#13928f; border:none; padding:8px 18px; font-weight:600;" type="button"
                    data-bs-toggle="dropdown">

                    <i class="fas fa-tools"></i>
                    <span>الإجراءات</span>
                </button>

                <ul class="dropdown-menu shadow border-0 rounded-3 text-center" style="min-width:240px;">

                    <li>
                        <button type="button" class="dropdown-item py-2" id="actionApprove">
                            <i class="fas fa-check text-success me-2"></i> اعتماد المحدد
                        </button>
                    </li>
                    <li>
                        <button type="button" class="dropdown-item py-2" id="actionReject">
                            <i class="fas fa-times text-danger me-2"></i> رفض المحدد
                        </button>
                    </li>

                    <li>
                        <button type="button" class="dropdown-item py-2" id="actionReReview">
                            <i class="fas fa-sync text-warning me-2"></i> إعادة إلى تحت المراجعة
                        </button>
                    </li>

                    <li>
                        <hr class="dropdown-divider">
                    </li>

                    <li>
                        <button type="button" class="dropdown-item py-2" id="actionPrintSelected">
                            <i class="fas fa-print me-2"></i> طباعة فواتير المحدد
                        </button>
                    </li>

                    <li>
                        <button type="button" class="dropdown-item py-2" id="actionPrintAll">
                            <i class="fas fa-file-pdf me-2"></i> طباعة مجمعة لكل النتائج
                        </button>
                    </li>

                </ul>
            </div>
        </div>


        {{-- جدول الاشتراكات --}}
        <div class="card shadow-sm border-0">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table id="subscriptionsTable" class="table table-hover table-striped  align-middle  mb-0">
                        <thead class="table-dark ">
                            <tr>
                                <th style="width:45px;" class="text-center">
                                    <input type="checkbox" id="checkAll" class="form-check-input">
                                </th>
                                <th style="width:50px;">#</th>
                                <th>رقم الفاتورة</th>
                                <th>العضو</th>
                                <th>الفرع</th>
                                <th>نوع الاشتراك</th>
                                <th>الخدمة / العرض</th>
                                <th>مسجل الاشتراك</th>
                                <th>رقم الاعتماد</th>

                                <th style="width:140px;">الحالة</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>


    </div>
@endsection


@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        let table;
        let currentStatusFilter = ''; // افتراضي: كل الاشتراكات

        $(function() {

            // ========== DataTable ==========
            table = $('#subscriptionsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('subscriptions.index') }}",
                    data: function(d) {
                        d.status = currentStatusFilter || ''; // يروح للكونترولر
                        d.branch_id = $('#filter_branch').val();
                        d.created_by = $('#filter_created_by').val();
                        d.type = $('#filter_type').val();
                    }
                },
                columns: [{
                        data: "id",
                        render: id =>
                            `<input type="checkbox" class="form-check-input sub-check" value="${id}">`,
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'invoice_no',
                        name: 'invoice_no'
                    },
                    {
                        data: 'member',
                        name: 'member'
                    },
                    {
                        data: 'branch',
                        name: 'branch'
                    },
                    {
                        data: 'subscription_type',
                        name: 'subscription_type'
                    },
                    {
                        data: 'item_name',
                        name: 'item_name'
                    },
                    {
                        data: 'created_by',
                        name: 'created_by'
                    },
                    {
                        data: 'verification_code',

                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [2, 'desc']
                ],
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json'
                }
            });

            table.on('draw', function() {
                $('#checkAll').prop('checked', false);
                refreshActionsState();
            });

            // ⬅️ إعادة تحميل الجدول عند تغيير الفلاتر
            $('#filter_branch, #filter_created_by, #filter_type').on('change', function() {
                table.ajax.reload(null, true);
            });


            // ========== الكروت كفلاتر ==========
            $('.status-card').on('click', function() {
                const $card = $(this);
                const status = $card.data('status'); // "" أو قيمة

                $('.status-card').removeClass('active');
                $card.addClass('active');

                currentStatusFilter = status; // لو فاضي => الكل
                table.ajax.reload(null, true);
            });

            // ========== اختيار الكل ==========
            $('#checkAll').on('change', function() {
                $('.sub-check').prop('checked', this.checked);
                refreshActionsState();
            });

            // ========== تغيير اختيار صف ==========
            $(document).on('change', '.sub-check', function() {
                const total = $('.sub-check').length;
                const checked = $('.sub-check:checked').length;
                $('#checkAll').prop('checked', total > 0 && total === checked);
                refreshActionsState();
            });

            function getSelectedIds() {
                const ids = [];
                $('.sub-check:checked').each(function() {
                    ids.push($(this).val());
                });
                return ids;
            }

            function refreshActionsState() {
                const ids = getSelectedIds();
                const hasSelected = ids.length > 0;
                const inUnderReview = (currentStatusFilter === 'under_review');
                const inRejected = (currentStatusFilter === 'rejected');

                // اعتماد:
                // يعمل في "تحت المراجعة" و "المرفوضة"
                $('#actionApprove').toggleClass('disabled', !(hasSelected && (inUnderReview || inRejected)));

                // رفض:
                // يعمل فقط في "تحت المراجعة"
                $('#actionReject').toggleClass('disabled', !(hasSelected && inUnderReview));

                // إعادة إلى تحت المراجعة:
                // يعمل فقط في "المرفوضة"
                $('#actionReReview').toggleClass('disabled', !(hasSelected && inRejected));

                // الطباعة للمحدد: متاح فقط لو في صفوف مختارة
                $('#actionPrintSelected').toggleClass('disabled', !hasSelected);

                // طباعة مجمعة: يعتمد على الفلتر فقط، دائماً مفعلة (حتى لو مفيش سطور حالياً)
                // هنا سيظل الزر فعال، والمستخدم لو ضغط ومافيش بيانات السيرفر يرجعله رسالة مناسبة
            }

            // ========== دالة عامة للـ Bulk Status ==========
            function bulkAction(status, titleText) {
                const ids = getSelectedIds();
                if (!ids.length) return;

                Swal.fire({
                    title: titleText,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء'
                }).then(result => {
                    if (!result.isConfirmed) return;

                    $.ajax({
                        url: "{{ url('/subscriptions/bulk-status') }}",
                        method: 'POST',
                        data: {
                            _token: "{{ csrf_token() }}",
                            ids: ids,
                            status: status
                        },
                        success: res => {
                            table.ajax.reload(null, false);
                            $('#checkAll').prop('checked', false);
                            refreshActionsState();

                            if (res.stats) {
                                $('#stat_new').text(res.stats.new);
                                $('#stat_under_review').text(res.stats.under_review);
                                $('#stat_approved').text(res.stats.approved);
                                $('#stat_rejected').text(res.stats.rejected);
                                $('#stat_total').text(
                                    res.stats.new +
                                    res.stats.under_review +
                                    res.stats.approved +
                                    res.stats.rejected
                                );
                            }

                            Swal.fire('تم', res.message || 'تم تنفيذ العملية بنجاح', 'success');
                        },
                        error: () => {
                            Swal.fire('خطأ', 'تعذر تنفيذ العملية، حاول مرة أخرى', 'error');
                        }
                    });
                });
            }

            // ========== أزرار الإجراءات ==========
            // اعتماد المحدد
            $('#actionApprove').on('click', function() {
                if ($(this).hasClass('disabled')) return;

                const msg = (currentStatusFilter === 'rejected') ?
                    'هل تريد إعادة اعتماد الاشتراكات المرفوضة المحددة؟' :
                    'هل تريد اعتماد الاشتراكات المحددة؟';

                bulkAction('approved', msg);
            });

            // رفض المحدد
            $('#actionReject').on('click', function() {
                if ($(this).hasClass('disabled')) return;
                bulkAction('rejected', 'هل تريد رفض الاشتراكات المحددة؟');
            });

            // إعادة إلى تحت المراجعة
            $('#actionReReview').on('click', function() {
                if ($(this).hasClass('disabled')) return;
                bulkAction('under_review', 'هل تريد إعادة الاشتراكات المحددة إلى تحت المراجعة؟');
            });

            // ========== طباعة المحدد ==========
            $('#actionPrintSelected').on('click', function() {
                if ($(this).hasClass('disabled')) return;

                const ids = getSelectedIds();
                if (!ids.length) return;

                // 👈 نفتح نافذة طباعة مجمعة لنفس تصميم الفاتورة
                const url = "{{ url('/subscriptions/print-multi') }}" + '?ids=' + encodeURIComponent(ids
                    .join(','));
                window.open(url, '_blank');
            });

            // ========== طباعة مجمعة لكل النتائج حسب الفلتر الحالي ==========
            $('#actionPrintAll').on('click', function() {
                const url = "{{ url('/subscriptions/print-multi') }}" +
                    '?all=1' +
                    '&status=' + encodeURIComponent(currentStatusFilter || '');

                window.open(url, '_blank');
            });

            // بداية
            refreshActionsState();
        });
    </script>
@endsection
